/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.j2ee.common.operations.AddSecurityRoleOperationDataModel;
import com.ibm.etools.j2ee.common.operations.ModelModifierOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.common.operations.J2EEModifierHelperCreator;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class AddSecurityRoleOperation
extends ModelModifierOperation {
    public AddSecurityRoleOperation(AddSecurityRoleOperationDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected void addHelpers() {
        AddSecurityRoleOperationDataModel model = (AddSecurityRoleOperationDataModel)this.operationDataModel;
        ModifierHelper helper = this.createRoleHelper(model);
        this.setOwner(helper, model);
        this.modifier.addHelper(helper);
    }

    private ModifierHelper createRoleHelper(AddSecurityRoleOperationDataModel model) {
        SecurityRole role = CommonFactory.eINSTANCE.createSecurityRole();
        role.setRoleName(model.getStringProperty("AddSecurityRoleOperationDataModel.ROLE_NAME"));
        String desc = (String)model.getProperty("AddSecurityRoleOperationDataModel.ROLE_DESCRIPTION");
        if (desc != null) {
            EObject root = model.getDeploymentDescriptorRoot();
            int j2eeVertion = 0;
            switch (model.getDeploymentDescriptorType()) {
                case 2: {
                    j2eeVertion = ((Application)root).getJ2EEVersionID();
                    break;
                }
                case 3: {
                    j2eeVertion = ((EJBJar)root).getJ2EEVersionID();
                    break;
                }
                case 4: {
                    j2eeVertion = ((WebApp)root).getJ2EEVersionID();
                }
            }
            if (j2eeVertion >= 14) {
                Description description = CommonFactory.eINSTANCE.createDescription();
                description.setValue(desc);
                role.getDescriptions().add((Object)description);
            } else {
                role.setDescription(desc);
            }
        }
        ModifierHelper helper = new ModifierHelper();
        helper.setValue((Object)role);
        return helper;
    }

    private void setOwner(ModifierHelper helper, AddSecurityRoleOperationDataModel model) {
        EObject root = model.getDeploymentDescriptorRoot();
        if (root != null) {
            switch (model.getDeploymentDescriptorType()) {
                case 2: {
                    this.setOwner(helper, (Application)root);
                    break;
                }
                case 3: {
                    this.setOwner(helper, (EJBJar)root);
                    break;
                }
                case 4: {
                    this.setOwner(helper, (WebApp)root);
                }
            }
        }
    }

    private void setOwner(ModifierHelper helper, Application application) {
        helper.setOwner((EObject)application);
        helper.setFeature((EStructuralFeature)ApplicationPackage.eINSTANCE.getApplication_SecurityRoles());
    }

    private void setOwner(ModifierHelper helper, EJBJar ejbJar) {
        helper.setFeature((EStructuralFeature)EjbPackage.eINSTANCE.getAssemblyDescriptor_SecurityRoles());
        AssemblyDescriptor descriptor = ejbJar.getAssemblyDescriptor();
        if (descriptor != null) {
            helper.setOwner((EObject)descriptor);
        } else {
            ModifierHelper ownerHelper = J2EEModifierHelperCreator.createAssemblyDescriptorHelper((EJBJar)ejbJar);
            helper.setOwnerHelper(ownerHelper);
        }
    }

    private void setOwner(ModifierHelper helper, WebApp webApp) {
        helper.setOwner((EObject)webApp);
        helper.setFeature((EStructuralFeature)WebapplicationPackage.eINSTANCE.getWebApp_SecurityRoles());
    }
}

