/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.common.operations.EARArtifactEditOperationDataModel;
import com.ibm.etools.j2ee.common.operations.ServerTargetDataModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public abstract class AddArchiveToEARDataModel
extends EARArtifactEditOperationDataModel {
    public static final String ARCHIVE_MODULE = "AddModuleToEARDataModel.ARCHIVE_PROJECT";
    public static final String ARCHIVE_URI = "AddModuleToEARDataModel.URI";
    public static final String SYNC_TARGET_RUNTIME = "AddModuleToEARDataModel.SYNC_TARGET_RUNTIME";

    @Override
    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(ARCHIVE_MODULE);
        this.addValidBaseProperty(ARCHIVE_URI);
        this.addValidBaseProperty(SYNC_TARGET_RUNTIME);
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        IProject project;
        if ("ArtifactEditOperationDataModel.PROJECT_NAME".equals(propertyName)) {
            project = this.getTargetProject();
            try {
                if (!(project != null && project.exists() && project.isOpen() && project.hasNature("org.eclipse.jst.j2ee.EARNature"))) {
                    return WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.ADD_PROJECT_NOT_EAR);
                }
            }
            catch (CoreException e) {
                J2eePlugin.logError(e);
            }
        }
        if (ARCHIVE_MODULE.equals(propertyName)) {
            project = (IProject)this.getProperty(propertyName);
            if (project == null) {
                return WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.ADD_MODULE_MODULE_NULL);
            }
            if (!project.isOpen()) {
                return WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.ADD_MODULE_MODULE_CLOSED);
            }
        } else if (ARCHIVE_URI.equals(propertyName)) {
            String uri = this.getStringProperty(ARCHIVE_URI);
            if (uri == null || uri.trim().length() == 0) {
                return WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.ADD_PROJECT_URI_EMPTY);
            }
            EARArtifactEdit earEdit = null;
            try {
                earEdit = this.getEARArtifactEditForRead();
                if (earEdit.uriExists(uri)) {
                    IStatus iStatus = WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.ADD_PROJECT_URI_EXISTS);
                    return iStatus;
                }
            }
            finally {
                if (earEdit != null) {
                    earEdit.dispose();
                }
            }
        }
        return super.doValidateProperty(propertyName);
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean returnValue = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(ARCHIVE_MODULE)) {
            this.notifyDefaultChange(ARCHIVE_URI);
        }
        return returnValue;
    }

    @Override
    protected Object getDefaultProperty(String propertyName) {
        if (propertyName.equals(ARCHIVE_URI)) {
            return this.getDefaultArchiveURI();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected String getDefaultArchiveURI() {
        WorkbenchComponent module = (WorkbenchComponent)this.getProperty(ARCHIVE_MODULE);
        if (module != null) {
            StringBuffer b = new StringBuffer();
            b.append(module.getName().replace(' ', '_'));
            b.append('.');
            b.append(this.getDefaultURIExtension());
            return b.toString();
        }
        return "";
    }

    protected String getDefaultURIExtension() {
        return "jar";
    }

    public boolean isModuleArchive() {
        return false;
    }

    public ServerTargetDataModel getServerTargetDataModel() {
        ServerTargetDataModel model = new ServerTargetDataModel();
        IRuntime earRuntime = ServerCore.getProjectProperties((IProject)this.getTargetProject()).getRuntimeTarget();
        if (earRuntime != null) {
            model.setProperty("ServerTargetDataModel.RUNTIME_TARGET_ID", earRuntime.getId());
        } else {
            model.setProperty("ServerTargetDataModel.RUNTIME_TARGET_ID", null);
        }
        WorkbenchComponent module = (WorkbenchComponent)this.getProperty(ARCHIVE_MODULE);
        IProject modProject = this.getProjectForGivenComponent(module);
        if (modProject != null) {
            model.setProperty("ServerTargetDataModel.PROJECT_NAME", modProject.getName());
        }
        return model;
    }

    public IProject getProjectForGivenComponent(WorkbenchComponent wbComp) {
        IProject modProject = null;
        modProject = StructureEdit.getContainingProject((WorkbenchComponent)wbComp);
        return modProject;
    }

    public AddArchiveToEARDataModel createArchiveModel() {
        AddArchiveToEARDataModel model = null;
        return model;
    }
}

