/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee;

import com.ibm.etools.j2ee.J2eePlugin;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.componentcore.EnterpriseBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EjbFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.project.facet.EARFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.UtilityProjectCreationDataModelProvider;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class J2EEProjectUtilities
extends org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities {
    public static final IWorkspace ws = ResourcesPlugin.getWorkspace();

    public static boolean isEARComponent(IVirtualComponent aComponent) {
        return !aComponent.isBinary() && J2EEProjectUtilities.isEARProject((IProject)aComponent.getProject());
    }

    public static IVirtualComponent[] getReferencingEARComponents(IVirtualComponent aComponent) {
        if (aComponent == null) {
            return new IVirtualComponent[0];
        }
        if (J2EEProjectUtilities.isEARComponent(aComponent)) {
            return new IVirtualComponent[]{aComponent};
        }
        ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>();
        if (aComponent.isBinary()) {
            IProject[] earProjects = J2EEProjectUtilities.getAllProjectsInWorkspaceOfType((String)"jst.ear");
            int i = 0;
            while (i < earProjects.length) {
                IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProjects[i]);
                IVirtualReference[] references = earComponent.getReferences();
                boolean refFound = false;
                int j = 0;
                while (j < references.length && !refFound) {
                    if (references[j].getReferencedComponent().equals(aComponent)) {
                        refFound = true;
                        result.add(earComponent);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            IVirtualComponent[] refComponents = aComponent.getReferencingComponents();
            int i = 0;
            while (i < refComponents.length) {
                if (J2EEProjectUtilities.isEARComponent(refComponents[i])) {
                    result.add(refComponents[i]);
                }
                ++i;
            }
        }
        return result.toArray(new IVirtualComponent[result.size()]);
    }

    public static ArchiveManifest readManifest(IVirtualComponent component) {
        if (!component.isBinary()) {
            IVirtualFile vManifest = component.getRootFolder().getFile("META-INF/MANIFEST.MF");
            if (vManifest.exists()) {
                IFile manifestFile = vManifest.getUnderlyingFile();
                InputStream in = null;
                try {
                    in = manifestFile.getContents();
                    ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl(in);
                    return archiveManifestImpl;
                }
                catch (IOException e) {
                    J2eePlugin.logError(e);
                }
                catch (CoreException e) {
                    J2eePlugin.logError(e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                            in = null;
                        }
                        catch (IOException e) {
                            J2eePlugin.logError(e);
                        }
                    }
                }
            }
        } else {
            EnterpriseBinaryComponentHelper.IReferenceCountedArchive archive = EnterpriseBinaryComponentHelper.ArchiveCache.getInstance().getArchive(component);
            if (archive == null) {
                EnterpriseBinaryComponentHelper helper = EnterpriseBinaryComponentHelper.getHelper((IVirtualComponent)component);
                try {
                    ArchiveManifest manifest;
                    archive = helper.accessArchive();
                    ArchiveManifest archiveManifest = manifest = archive.getManifest();
                    return archiveManifest;
                }
                catch (Exception exception) {
                }
                finally {
                    if (archive != null) {
                        archive.close();
                    }
                    if (helper != null) {
                        helper.dispose();
                    }
                }
            } else {
                return archive.getManifest();
            }
        }
        return null;
    }

    public static IVirtualReference[] getJ2EEModuleReferences(IVirtualComponent earComponent) {
        return org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.getJ2EEModuleReferences((IVirtualComponent)earComponent);
    }

    public static String getJ2EEDDProjectVersion(IProject project) {
        IVirtualFile vFile;
        IVirtualComponent comp;
        int type = -1;
        String ddURI = null;
        if (J2EEProjectUtilities.isEARProject((IProject)project)) {
            type = 1;
            ddURI = "META-INF/application.xml";
        } else if (J2EEProjectUtilities.isEJBProject((IProject)project)) {
            type = 0;
            ddURI = "META-INF/ejb-jar.xml";
        } else if (J2EEProjectUtilities.isApplicationClientProject((IProject)project)) {
            type = 3;
            ddURI = "META-INF/application-client.xml";
        } else if (J2EEProjectUtilities.isJCAProject((IProject)project)) {
            type = 2;
            ddURI = "META-INF/ra.xml";
        } else if (J2EEProjectUtilities.isDynamicWebProject((IProject)project)) {
            type = 4;
            ddURI = "WEB-INF/web.xml";
        }
        if (type != -1 && (comp = ComponentCore.createComponent((IProject)project)) != null && (vFile = comp.getRootFolder().getFile((IPath)new Path(ddURI))).exists()) {
            InputStream in = null;
            try {
                in = vFile.getUnderlyingFile().getContents();
                JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(in);
                int vers = quickPeek.getVersion() == -1 ? J2EEProjectUtilities.getJEEVersion(project) : quickPeek.getVersion();
                String string = J2EEVersionUtil.convertVersionIntToString((int)vers);
                return string;
            }
            catch (CoreException e) {
                J2eePlugin.logError(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        J2eePlugin.logError(e);
                    }
                }
            }
        }
        return null;
    }

    private static int getJEEVersion(IProject project) {
        if (J2EEProjectUtilities.isEARProject((IProject)project) || J2EEProjectUtilities.isApplicationClientProject((IProject)project)) {
            return 50;
        }
        if (J2EEProjectUtilities.isEJBProject((IProject)project)) {
            return 30;
        }
        if (J2EEProjectUtilities.isDynamicWebProject((IProject)project)) {
            return 25;
        }
        return -1;
    }

    public static IProject getProject(String name) {
        return ws.getRoot().getProject(name);
    }

    public static IProject createEARProject(String name) {
        return J2EEProjectUtilities.createEARProject(name, false);
    }

    public static IProject createEARProject(String name, boolean waitForBuildToComplete) {
        return J2EEProjectUtilities.createEARProject(name, 14, false, waitForBuildToComplete);
    }

    public static IProject createEARProject(String name, int facetVersion, boolean generateDD, boolean waitForBuildToComplete) {
        IDataModel dataModel = J2EEProjectUtilities.getEARCreationDataModel(name, facetVersion, generateDD);
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.ear", null, waitForBuildToComplete);
    }

    public static IProject createWebProject(String name, String earName) {
        return J2EEProjectUtilities.createWebProject(name, earName, false);
    }

    public static IProject createWebProject(String name, String earName, boolean waitForBuildToComplete) {
        return J2EEProjectUtilities.createWebProject(name, earName, 24, waitForBuildToComplete, true);
    }

    public static IProject createWebProject(String name, String earName, int facetVersion, boolean waitForBuildToComplete, boolean generateDD) {
        IDataModel dataModel = J2EEProjectUtilities.getWebCreationDataModel(name, earName, facetVersion, generateDD);
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.web", earName, waitForBuildToComplete);
    }

    public static IProject createUtilityProject(String name, String earName) {
        return J2EEProjectUtilities.createUtilityProject(name, earName, false);
    }

    public static IProject createUtilityProject(String name, String earName, boolean waitForBuildToComplete) {
        IDataModel dataModel = J2EEProjectUtilities.getUtilityCreationDataModel(name, earName);
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.utility", earName, waitForBuildToComplete);
    }

    public static IProject createEJBProject(String name, String earName) {
        return J2EEProjectUtilities.createEJBProject(name, earName, false);
    }

    public static IProject createEJBProject(String name, String earName, boolean waitForBuildToComplete) {
        return J2EEProjectUtilities.createEJBProject(name, earName, 21, waitForBuildToComplete, false);
    }

    public static IProject createEJBProject(String name, String earName, int facetVersion, boolean waitForBuildToComplete, boolean generateDD) {
        IDataModel dataModel = J2EEProjectUtilities.getEJBCreationDataModel(name, earName, facetVersion, generateDD);
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.ejb", earName, waitForBuildToComplete);
    }

    public static IProject createEJBProject(String name, String earName, Map<String, Object> facetModelProperties, int facetVersion, boolean waitForBuildToComplete, boolean generateDD) {
        IDataModel dataModel = J2EEProjectUtilities.getEJBCreationDataModel(name, earName, facetVersion, generateDD);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        for (Map.Entry<String, Object> entry : facetModelProperties.entrySet()) {
            facetModel.setProperty(entry.getKey(), entry.getValue());
        }
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.ejb", earName, waitForBuildToComplete);
    }

    public static IProject createEJBProject(String name, String earName, String clientName, int facetVersion, boolean waitForBuildToComplete, boolean generateDD) {
        IDataModel dataModel = J2EEProjectUtilities.getEJBCreationDataModel(name, earName, facetVersion, generateDD);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.ejb");
        facetModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
        if (clientName != null && earName != null) {
            facetModel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", true);
            facetModel.setStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ", clientName);
        }
        return J2EEProjectUtilities.createAndExecute(dataModel, name, "jst.ejb", earName, waitForBuildToComplete);
    }

    private static IDataModel getEARCreationDataModel(String name, int facetVersion, boolean generateDD) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EARFacetProjectCreationDataModelProvider());
        J2EEProjectUtilities.configure(model, name, "jst.ear", null, facetVersion, false, generateDD);
        return model;
    }

    private static IDataModel getWebCreationDataModel(String name, String earName, int facetVersion, boolean generateDD) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
        J2EEProjectUtilities.configure(model, name, "jst.web", earName, facetVersion, facetVersion == 25, generateDD);
        return model;
    }

    private static IDataModel getUtilityCreationDataModel(String name, String earName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new UtilityProjectCreationDataModelProvider());
        J2EEProjectUtilities.configure(model, name, "jst.utility", earName, 0, false, true);
        return model;
    }

    private static IDataModel getEJBCreationDataModel(String name, String earName, int facetVersion, boolean generateDD) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbFacetProjectCreationDataModelProvider());
        J2EEProjectUtilities.configure(model, name, "jst.ejb", earName, facetVersion, facetVersion == 30, generateDD);
        return model;
    }

    private static void configure(IDataModel model, String name, String facet, String earName, int facetVersion, boolean isJEE5, boolean generateDD) {
        model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)name);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetDM = map.getFacetDataModel(facet);
        facetDM.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", generateDD);
        if (earName != null) {
            facetDM.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", true);
            facetDM.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earName);
        }
        if (facetVersion != 0) {
            String versionText = J2EEVersionUtil.convertVersionIntToString((int)facetVersion);
            facetDM.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", versionText);
        }
        if (isJEE5) {
            facetDM = map.getFacetDataModel("jst.java");
            facetDM.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", "5.0");
        }
    }

    private static IProject createAndExecute(IDataModel model, String projectName, String type, String earName, boolean waitForBuildToComplete) {
        J2EEProjectUtilities.runModel(model, waitForBuildToComplete);
        J2EEProjectUtilities.waitForClasspathUpdate();
        return J2EEProjectUtilities.getProject(projectName);
    }

    /*
     * Loose catch block
     */
    private static void runModel(IDataModel dataModel, boolean waitForBuildToComplete) {
        try {
            try {
                dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                if (waitForBuildToComplete) {
                    Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                }
            }
            catch (ExecutionException e) {
                J2eePlugin.logError(e);
                dataModel.dispose();
            }
            catch (OperationCanceledException e) {
                J2eePlugin.logError(e);
                dataModel.dispose();
            }
            catch (InterruptedException e) {
                J2eePlugin.logError(e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                dataModel.dispose();
            }
        }
        finally {
            dataModel.dispose();
        }
    }

    private static void waitForClasspathUpdate() {
        Job[] jobs = Job.getJobManager().find((Object)"EAR Libraries Update Job");
        if (jobs.length > 0) {
            try {
                int i = 0;
                while (i < jobs.length) {
                    if (jobs[i].getName().equals("EAR Libraries Update Job")) {
                        jobs[i].join();
                    }
                    ++i;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

