/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.web.internal.operations.AddServletMappingOperation;
import com.ibm.etools.j2ee.web.internal.operations.WebMessages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddServletMappingDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String SERVLET = "AddServletMappingOperationDataModel.SERVLET";
    public static final String URL_PATTERN = "AddServletMappingOperationDataModel.URL_PATTERN";

    public WTPOperation getDefaultOperation() {
        return new AddServletMappingOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SERVLET);
        this.addValidBaseProperty(URL_PATTERN);
    }

    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = this.validateEE5Project();
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals(SERVLET)) {
            WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
            String servletName = this.getStringProperty(SERVLET);
            Servlet servlet = webApp.getServletNamed(servletName);
            return this.validateServlet(servlet);
        }
        if (propertyName.equals(URL_PATTERN)) {
            return this.validateURLPattern(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    protected IStatus validateEE5Project() {
        EObject app = this.getDeploymentDescriptorRoot();
        if (app == null) {
            String msg = MessageFormat.format(JavaCodeGenResourceHandler.AddSecurityRoleOperationDataModel_This_wizard_is_not_applicable_on_pr_, new Object[1]);
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateURLPattern(String urlPattern) {
        if (urlPattern == null || urlPattern.trim().length() == 0) {
            String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_MAPPING_URL_PATTERN_EMPTY, new String[]{urlPattern});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        String servletName = this.getStringProperty(SERVLET);
        Servlet servlet = webApp.getServletNamed(servletName);
        EList mappings = webApp.getServletMappings();
        boolean exists = false;
        if (mappings != null && !mappings.isEmpty()) {
            int i = 0;
            while (i < mappings.size()) {
                ServletMapping mapping = (ServletMapping)mappings.get(i);
                if (mapping.getServlet() == servlet && urlPattern.equals(mapping.getUrlPattern())) {
                    exists = true;
                    break;
                }
                ++i;
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_MAPPING_URL_PATTERN_EXIST, new String[]{urlPattern});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateServlet(Servlet servlet) {
        if (servlet == null) {
            String msg = WebMessages.ERR_SERVLET_MAPPING_SERVLET_NOT_EXIST;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

