/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddMimeMappingOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.webapplication.MimeMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddMimeMappingDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String MIME_MAPPING_EXTENSION = "AddMimeMappingOperationDataModel.MIME_MAPPING_EXTENSION";
    public static final String MIME_MAPPING_TYPE = "AddMimeMappingOperationDataModel.MIME_MAPPING_TYPE";

    public WTPOperation getDefaultOperation() {
        return new AddMimeMappingOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(MIME_MAPPING_EXTENSION);
        this.addValidBaseProperty(MIME_MAPPING_TYPE);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(MIME_MAPPING_EXTENSION)) {
            return this.validateName(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateName(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_MIME_MAPPING_EXTENSION_EMPTY, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        EList mappings = webApp.getMimeMappings();
        boolean exists = false;
        if (mappings != null) {
            int size = mappings.size();
            int i = 0;
            while (i < size) {
                String extension = ((MimeMapping)mappings.get(i)).getExtension();
                if (name.equals(extension)) {
                    exists = true;
                    break;
                }
                ++i;
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_MIME_MAPPING_EXTENSION_EXIST, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

