/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.common.frameworks.internal.datamodel.WTPPropertyDescriptor;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.web.internal.operations.AddFilterMappingOperation;
import com.ibm.etools.j2ee.web.internal.operations.WebMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddFilterMappingDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String FILTER = "AddFilterMappingOperationDataModel.FILTER";
    public static final String DISPATCHER_TYPE_NAME = "AddFilterMappingOperationDataModel.DISPATCHER_TYPE_NAME";
    public static final String URL_PATTERN = "AddFilterMappingOperationDataModel.URL_PATTERN";
    public static final String DISPATCHER_TYPE = "AddFilterMappingOperationDataModel.DISPATCHER_TYPE";

    public WTPOperation getDefaultOperation() {
        return new AddFilterMappingOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(DISPATCHER_TYPE);
        this.addValidBaseProperty(URL_PATTERN);
        this.addValidBaseProperty(DISPATCHER_TYPE_NAME);
        this.addValidBaseProperty(FILTER);
    }

    protected IStatus doValidateProperty(String propertyName) {
        WebApp webApp;
        IStatus status = this.validateEE5Project();
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals(FILTER) && (webApp = (WebApp)this.getDeploymentDescriptorRoot()) != null) {
            String filterName = this.getStringProperty(FILTER);
            Filter filter = webApp.getFilterNamed(filterName);
            return this.validateFilter(filter);
        }
        if (propertyName.equals(URL_PATTERN)) {
            return this.validateURLPattern(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    protected IStatus validateEE5Project() {
        EObject app = this.getDeploymentDescriptorRoot();
        if (app == null) {
            String msg = MessageFormat.format(JavaCodeGenResourceHandler.AddSecurityRoleOperationDataModel_This_wizard_is_not_applicable_on_pr_, new Object[1]);
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean notify = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals(DISPATCHER_TYPE_NAME)) {
            this.setProperty(DISPATCHER_TYPE, this.getDispatcherValues((List)propertyValue));
        }
        return notify;
    }

    private List getDispatcherValues(List list) {
        ArrayList<DispatcherType> dispatcherTypes = new ArrayList<DispatcherType>();
        int i = 0;
        while (i < list.size()) {
            String dispatcherTypeName = (String)list.get(i);
            dispatcherTypes.add(DispatcherType.get((String)dispatcherTypeName));
            ++i;
        }
        return dispatcherTypes;
    }

    protected WTPPropertyDescriptor[] getStringValues(List values) {
        WTPPropertyDescriptor[] names = new WTPPropertyDescriptor[values.size()];
        int i = 0;
        while (i < values.size()) {
            names[i] = new WTPPropertyDescriptor(values.get(i));
            ++i;
        }
        return names;
    }

    private WTPPropertyDescriptor[] getValidDispatcherTypeNames() {
        return this.getStringValues(DispatcherType.VALUES);
    }

    protected WTPPropertyDescriptor[] doGetValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals(DISPATCHER_TYPE_NAME)) {
            return this.getValidDispatcherTypeNames();
        }
        return super.doGetValidPropertyDescriptors(propertyName);
    }

    private IStatus validateURLPattern(String urlPattern) {
        if (urlPattern == null || urlPattern.trim().length() == 0) {
            String msg = org.eclipse.jst.j2ee.internal.web.operations.WebMessages.getResourceString((String)WebMessages.ERR_MAPPING_URL_EMPTY, (Object[])new String[]{urlPattern});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        if (webApp != null) {
            String filterName = this.getStringProperty(FILTER);
            Filter filter = webApp.getFilterNamed(filterName);
            EList mappings = webApp.getFilterMappings();
            boolean exists = false;
            if (mappings != null && !mappings.isEmpty()) {
                int i = 0;
                while (i < mappings.size()) {
                    FilterMapping mapping = (FilterMapping)mappings.get(i);
                    if (mapping.getFilter() == filter && urlPattern.equals(mapping.getUrlPattern())) {
                        exists = true;
                        break;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = org.eclipse.jst.j2ee.internal.web.operations.WebMessages.getResourceString((String)WebMessages.ERR_MAPPING_URL_EXISTS, (Object[])new String[]{urlPattern});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateFilter(Filter filter) {
        if (filter == null) {
            String msg = org.eclipse.jst.j2ee.internal.web.operations.WebMessages.ERR_DISPLAY_NAME_EMPTY;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

