/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.common.operations.ModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddExceptionErrorPageOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.webapplication.ErrorPage;
import org.eclipse.jst.j2ee.webapplication.ExceptionTypeErrorPage;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddExceptionErrorPageDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String EXCEPTION_ERROR_PAGE_LOCATION = "AddExceptionErrorPageOperationDataModel.EXCEPTION_ERROR_PAGE_LOCATION";
    public static final String EXCEPTION_ERROR_PAGE_EXCEPTION_TYPE = "AddExceptionErrorPageOperationDataModel.EXCEPTION_ERROR_PAGE_EXCEPTION_TYPE";

    public WTPOperation getDefaultOperation() {
        return new AddExceptionErrorPageOperation((ModelModifierOperationDataModel)this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(EXCEPTION_ERROR_PAGE_LOCATION);
        this.addValidBaseProperty(EXCEPTION_ERROR_PAGE_EXCEPTION_TYPE);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(EXCEPTION_ERROR_PAGE_EXCEPTION_TYPE)) {
            return this.validateExceptionType(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(EXCEPTION_ERROR_PAGE_LOCATION)) {
            return this.validateLocation(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateLocation(String location) {
        if (location == null || location.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_ERROR_PAGE_LOCATION_EMPTY, (Object[])new String[]{location});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (!location.startsWith("/")) {
            String msg = WebMessages.ERR_ERROR_PAGE_LOCATION_MUST_START_WITH_SLASH;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return this.validateForDuplicates();
    }

    private IStatus validateForDuplicates() {
        EList errorPages = ((WebApp)this.getDeploymentDescriptorRoot()).getErrorPages();
        int i = 0;
        while (i < errorPages.size()) {
            ExceptionTypeErrorPage ecErrorPage;
            ErrorPage errorPage = (ErrorPage)errorPages.get(i);
            if (errorPage.isExceptionType() && (ecErrorPage = (ExceptionTypeErrorPage)errorPage).getLocation().equals(this.getStringProperty(EXCEPTION_ERROR_PAGE_LOCATION)) && ecErrorPage.getExceptionTypeName().equals(this.getStringProperty(EXCEPTION_ERROR_PAGE_EXCEPTION_TYPE))) {
                String msg = WebMessages.getResourceString((String)WebMessages.ERR_ERROR_PAGE_LOCATION_EXIST, (Object[])new String[]{this.getStringProperty(EXCEPTION_ERROR_PAGE_LOCATION)});
                return WTPCommonPlugin.createErrorStatus((String)msg);
            }
            ++i;
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateExceptionType(String exceptionType) {
        if (exceptionType == null || exceptionType.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_EXCEPTION_TYPE_EMPTY, (Object[])new String[]{exceptionType});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return this.validateForDuplicates();
    }
}

