/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddEnvEntryOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddEnvEntryDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String ENV_ENTRY_NAME = "AddEnvEntriesOperationDataModel.ENV_ENTRY_NAME";
    public static final String ENV_ENTRY_TYPE = "AddEnvEntriesOperationDataModel.ENV_ENTRY_TYPE";
    public static final String ENV_ENTRY_VALUE = "AddEnvEntriesOperationDataModel.ENV_ENTRY_VALUE";

    public WTPOperation getDefaultOperation() {
        return new AddEnvEntryOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(ENV_ENTRY_NAME);
        this.addValidBaseProperty(ENV_ENTRY_TYPE);
        this.addValidBaseProperty(ENV_ENTRY_VALUE);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(ENV_ENTRY_NAME)) {
            return this.validateName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(ENV_ENTRY_VALUE)) {
            return this.validateValue();
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateValue() {
        String type = this.getStringProperty(ENV_ENTRY_TYPE);
        String value = this.getStringProperty(ENV_ENTRY_VALUE);
        if (type == null || type == "") {
            return WTPCommonPlugin.createErrorStatus((String)"Please select a type");
        }
        if (value == null) {
            return WTPCommonPlugin.createErrorStatus((String)"Please select a value");
        }
        if (type.equals("Boolean") && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            return WTPCommonPlugin.createErrorStatus((String)(String.valueOf(value) + " Is not a vaild Boolean value"));
        }
        if (type.equals("Integer")) {
            try {
                Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                return WTPCommonPlugin.createErrorStatus((String)(String.valueOf(value) + " Is not a vaild Integer value"));
            }
        }
        if (type.equals("Long")) {
            try {
                Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                return WTPCommonPlugin.createErrorStatus((String)(String.valueOf(value) + " Is not a vaild Long value"));
            }
        }
        if (type.equals("Byte")) {
            try {
                Byte.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                return WTPCommonPlugin.createErrorStatus((String)(String.valueOf(value) + " Is not a vaild Byte value"));
            }
        }
        if (type.equals("Double")) {
            try {
                Double.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                return WTPCommonPlugin.createErrorStatus((String)(String.valueOf(value) + " Is not a vaild Double value"));
            }
        }
        if (type.equals("Short")) {
            try {
                Short.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                return WTPCommonPlugin.createErrorStatus((String)(String.valueOf(value) + " Is not a vaild Short value"));
            }
        }
        if (type.equals("Float")) {
            try {
                Float.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                return WTPCommonPlugin.createErrorStatus((String)(String.valueOf(value) + " Is not a vaild Float value"));
            }
        }
        if (type.equals("Character")) {
            IStatus createErrorStatus = WTPCommonPlugin.createErrorStatus((String)(String.valueOf(value) + " Is not a vaild Character value"));
            if (value.length() > 1) {
                return createErrorStatus;
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus validateName(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_ENV_ENTRY_NAME_EMPTY, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        EList entries = webApp.getEnvironmentProperties();
        boolean exists = false;
        if (entries != null) {
            int size = entries.size();
            int i = 0;
            while (i < size) {
                String entryName = ((EnvEntry)entries.get(i)).getName();
                if (name.equals(entryName)) {
                    exists = true;
                    break;
                }
                ++i;
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_ENV_ENTRY_NAME_EXIST, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

