/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web;

import com.ibm.etools.j2ee.web.IBaseWebNature;
import com.ibm.etools.j2ee.web.J2EEWebNatureRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;

public class J2EEWebNatureRuntimeUtilities {
    protected static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        ProjectUtilities.addNatureToProject((IProject)proj, (String)natureId);
    }

    public static IBaseWebNature getRuntime(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            IBaseWebNature nature = null;
            if (project.hasNature("org.eclipse.jst.j2ee.web.WebNature")) {
                nature = (IBaseWebNature)project.getNature("org.eclipse.jst.j2ee.web.WebNature");
            }
            return nature;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static J2EEWebNatureRuntime getJ2EERuntime(IProject project) {
        IBaseWebNature nature = J2EEWebNatureRuntimeUtilities.getRuntime(project);
        if (nature != null && nature.isJ2EE()) {
            return (J2EEWebNatureRuntime)nature;
        }
        return null;
    }

    public static boolean hasRuntime(IProject project) {
        try {
            return project.hasNature("org.eclipse.jst.j2ee.web.WebNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasJ2EERuntime(IProject project) {
        if (project == null || !project.exists()) {
            return false;
        }
        return JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
    }

    public static String getDefaultJ2EEWebContentName() {
        return J2EEPlugin.getDefault().getJ2EEPreferences().getJ2EEWebContentFolderName();
    }

    public static String getDefaultStaticWebContentName() {
        return J2EEPlugin.getDefault().getJ2EEPreferences().getStaticWebContentFolderName();
    }

    public static IPath getDefaultJ2EEWebContentPath() {
        return new Path(J2EEWebNatureRuntimeUtilities.getDefaultJ2EEWebContentName());
    }

    public static String getContextRootFromWebProject(IProject project) {
        IBaseWebNature nature = J2EEWebNatureRuntimeUtilities.getRuntime(project);
        String contextRoot = "";
        contextRoot = nature.getContextRoot();
        return contextRoot;
    }

    public static IPath getDefaultWEBINFPath() {
        return J2EEWebNatureRuntimeUtilities.getDefaultJ2EEWebContentPath().append("WEB-INF");
    }

    public static IPath getDefaultWebOutputFolderPath() {
        return J2EEWebNatureRuntimeUtilities.getDefaultWEBINFPath().append("classes");
    }

    public static IPath getWebOutputFolderPath(String webContentName) {
        return new Path(webContentName).append("WEB-INF").append("classes");
    }

    public static String getDefaultJavaSourceName() {
        return J2EEPlugin.getDefault().getJ2EEPreferences().getJavaSourceFolderName();
    }
}

