/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.wsc.ejb_editor;

import com.ibm.etools.emf.workbench.ui.custom.widgets.SectionEditableTable;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.webservice.atk.ui.editor.common.DialogElementAdd;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionTableViewer;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionTableViewerEditorInitializer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.internal.webservice.adapter.AdapterText;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandRemoveElement;
import org.eclipse.jst.j2ee.internal.webservice.constants.ATKUIConstants;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientFactory;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientPackage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class SectionTableViewerEditor
extends SectionTableViewer {
    protected int DEFAULT_COLUMN_WIDTH = 80;
    protected TableEditor editor_;
    protected TableEditorListener tableEditorListener_;
    protected String[] columns_;
    protected EStructuralFeature[] features_;
    protected String[] featureValues_;
    protected boolean[] nillable_;
    protected Text text_;
    protected AdapterText adapter_;
    protected SectionEditableTable main_table;
    protected ArtifactEdit artifactEdit = null;
    protected ISelectionChangedListener sel_listener = null;

    public SectionTableViewerEditor(Composite parent, int style, String aTitle, String formInfo, SectionTableViewerEditorInitializer initializer) {
        super(parent, style, aTitle, formInfo, initializer);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        this.addDisposeListener();
        TableViewer aViewer = (TableViewer)super.createViewer(parent);
        this.useTableLayout(aViewer.getTable());
        aViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' || e.character == ' ') {
                    SectionTableViewerEditor.this.tableEditorListener_.editSelection();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return aViewer;
    }

    protected void useTableLayout(Table table) {
        SectionTableViewerEditorInitializer tableViewerInitializer = (SectionTableViewerEditorInitializer)this.controlInitializer;
        this.columns_ = tableViewerInitializer.getTableColumns();
        table.setHeaderVisible(tableViewerInitializer.getHeaderVisible());
        table.setLinesVisible(tableViewerInitializer.getGridVisible());
        TableLayout tableLayout = new TableLayout();
        int maxWidth = this.DEFAULT_COLUMN_WIDTH;
        int i = 0;
        while (i < this.columns_.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(this.columns_[i]);
            tableColumn.pack();
            int tableColumnWidth = Math.max(this.DEFAULT_COLUMN_WIDTH, tableColumn.getWidth());
            maxWidth = Math.max(maxWidth, tableColumnWidth);
            ColumnWeightData columnData = new ColumnWeightData(tableColumnWidth, tableColumnWidth, true);
            tableLayout.addColumnData((ColumnLayoutData)columnData);
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        this.editor_ = new TableEditor(table);
        this.editor_.horizontalAlignment = 16384;
        this.editor_.grabHorizontal = true;
        this.editor_.minimumWidth = maxWidth;
        this.tableEditorListener_ = this.newTableEditorListener();
        table.addMouseListener((MouseListener)this.tableEditorListener_);
    }

    protected TableEditorListener newTableEditorListener() {
        return new TableEditorListener();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.internalDispose();
    }

    protected void internalDispose() {
        if (this.adapter_ != null) {
            this.adapter_.dispose();
        }
        if (this.text_ != null) {
            this.text_.dispose();
        }
    }

    private void addDisposeListener() {
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SectionTableViewerEditor.this.onDispose();
            }
        });
    }

    protected void onDispose() {
        if (this.main_table != null) {
            this.main_table.removeSectionChangedListener(this.sel_listener);
        }
        this.main_table = null;
    }

    @Override
    public void adaptModel(EObject eObject) {
        this.adapterViewer_.adapt(eObject);
        this.parent_ = eObject;
        this.setEnabled(eObject != null);
        if (this.getStructuredViewer().getContentProvider() != null) {
            this.getStructuredViewer().setInput((Object)eObject);
        }
        this.internalDispose();
    }

    @Override
    public void setArtifactEdit(ArtifactEdit anArtifactEdit) {
        this.artifactEdit = anArtifactEdit;
        EClass childEClass = null;
        EReference childFeature = null;
        EObject eObject = null;
        CommonPackage commonPKG = CommonPackage.eINSTANCE;
        Webservice_clientPackage wscddPKG = Webservice_clientFactory.eINSTANCE.getWebservice_clientPackage();
        ATKUIConstants atkuiConst = new ATKUIConstants();
        eObject = this.getHandler();
        childEClass = commonPKG.getParamValue();
        childFeature = wscddPKG.getHandler_InitParams();
        EStructuralFeature[] initParamsFeatures = new EStructuralFeature[]{commonPKG.getParamValue_Name(), commonPKG.getParamValue_Value(), commonPKG.getParamValue_Description()};
        boolean[] initParamsNillables = new boolean[]{false, false, true};
        String[] initParamsValues = new String[]{atkuiConst.defaultInitParamName(), atkuiConst.defaultInitParamValue(), atkuiConst.defaultDescription()};
        super.setArtifactEdit(anArtifactEdit, eObject, childEClass, (EStructuralFeature)childFeature);
        this.features_ = initParamsFeatures;
        this.nillable_ = initParamsNillables;
        this.featureValues_ = initParamsValues;
    }

    public void setMainViewer(SectionEditableTable mainViewer) {
        if (this.main_table == null) {
            this.main_table = mainViewer;
            this.sel_listener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    Object obj = selection.getFirstElement();
                    if (obj == null) {
                        SectionTableViewerEditor.this.setEnabled(false);
                    } else {
                        SectionTableViewerEditor.this.setEnabled(true);
                        SectionTableViewerEditor.this.adaptModel((EObject)obj);
                    }
                }
            };
            this.main_table.addSelectionChangedListener(this.sel_listener);
        }
    }

    protected EObject getHandler() {
        Object obj = this.main_table.getStructuredSelection().getFirstElement();
        if (obj != null && obj instanceof EObject) {
            return (EObject)obj;
        }
        return null;
    }

    @Override
    protected void handleAddButtonSelected(SelectionEvent event) {
        DialogElementAdd dialog = new DialogElementAdd(this.getShell(), this.columns_, this.featureValues_, this.artifactEdit, this.parent_, this.childEClass_, this.childFeature_, this.features_);
        dialog.setTitle(J2EEUIPlugin.getResourceString("%DIALOG_TITLE_ADD", new String[]{this.title}));
        dialog.open();
        Object addedObject = dialog.getAddedObject();
        if (addedObject != null) {
            EObject eObject = (EObject)addedObject;
            this.getStructuredViewer().setInput((Object)eObject.eContainer());
            this.setSelectionAsObject(addedObject);
            this.tableEditorListener_.editSelection();
        }
    }

    @Override
    protected void handleDeleteKeyPressed() {
        this.internalDispose();
        Object object = this.getSelectionAsObject();
        if (object != null && object instanceof EObject) {
            TableViewer tableViewer = (TableViewer)this.viewer;
            Table table = tableViewer.getTable();
            int selectionIndex = table.getSelectionIndex();
            int selectionCount = table.getItemCount();
            CommandRemoveElement command = new CommandRemoveElement(null, null, this.parent_, object, this.childFeature_);
            this.artifactEdit.getCommandStack().execute((Command)command);
            if (selectionIndex < selectionCount - 1) {
                this.setSelectionAsObject(tableViewer.getElementAt(selectionIndex));
            } else if (selectionCount - 2 >= 0) {
                this.setSelectionAsObject(tableViewer.getElementAt(selectionCount - 2));
            }
        }
    }

    protected class TableEditorListener
    implements MouseListener {
        protected int currSelectionIndex_ = -1;
        protected int editRow_ = -1;
        protected int editColumn_ = -1;

        public void mouseDoubleClick(MouseEvent e) {
            this.mouseDown(e);
        }

        public void mouseDown(MouseEvent e) {
            SectionTableViewerEditor.this.internalDispose();
            SectionTableViewerEditor.this.viewer.refresh();
            Table table = ((TableViewer)SectionTableViewerEditor.this.viewer).getTable();
            if (table.isFocusControl()) {
                TableItem tableItem;
                int selectedColumnIndex;
                int selectedRowIndex = this.getSelectedRow(table, e.y);
                if (this.currSelectionIndex_ != -1 && selectedRowIndex != -1 && this.currSelectionIndex_ == selectedRowIndex && (selectedColumnIndex = this.getSelectedColumn(tableItem = table.getItem(selectedRowIndex), e.x, e.y)) != -1 && (SectionTableViewerEditor.this.text_ == null || SectionTableViewerEditor.this.text_.isDisposed() || selectedColumnIndex != SectionTableViewerEditor.this.editor_.getColumn())) {
                    this.editSelection(selectedRowIndex, selectedColumnIndex);
                }
                this.currSelectionIndex_ = selectedRowIndex;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        private int getSelectedRow(Table table, int y) {
            TableItem[] tableItems = table.getItems();
            int i = 0;
            while (i < tableItems.length) {
                Rectangle rectangle = tableItems[i].getBounds(0);
                if (rectangle != null && y >= rectangle.y && y < rectangle.y + rectangle.height) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private int getSelectedColumn(TableItem tableItem, int x, int y) {
            int i = 0;
            while (i < SectionTableViewerEditor.this.columns_.length) {
                if (tableItem.getBounds(i).contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected void editSelection(int row, int column) {
            this.editRow_ = row;
            this.editColumn_ = column;
            Table table = ((TableViewer)SectionTableViewerEditor.this.viewer).getTable();
            TableItem tableItem = table.getItem(row);
            Object object = SectionTableViewerEditor.this.getSelectionAsObject();
            if (object != null && object instanceof EObject) {
                SectionTableViewerEditor.this.text_ = new Text((Composite)table, 0);
                SectionTableViewerEditor.this.text_.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\u001b') {
                            TableEditorListener.this.cancelSelection();
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
                SectionTableViewerEditor.this.text_.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 16) {
                            TableEditorListener.this.traverseTabNext();
                        } else if (e.detail == 8) {
                            TableEditorListener.this.traverseTabPrevious();
                        }
                    }
                });
                SectionTableViewerEditor.this.adapter_ = this.createTextAdapter((EObject)object, column);
                SectionTableViewerEditor.this.adapter_.setArtifactEdit(SectionTableViewerEditor.this.artifactEdit);
                SectionTableViewerEditor.this.editor_.setEditor((Control)SectionTableViewerEditor.this.text_, tableItem, column);
                SectionTableViewerEditor.this.text_.setFocus();
                SectionTableViewerEditor.this.text_.selectAll();
            }
        }

        protected AdapterText createTextAdapter(EObject eObject, int column) {
            return new AdapterText(SectionTableViewerEditor.this.artifactEdit, eObject, SectionTableViewerEditor.this.features_[column], SectionTableViewerEditor.this.text_, SectionTableViewerEditor.this.nillable_[column]);
        }

        protected void traverseTabNext() {
            this.cancelSelection();
            Table table = ((TableViewer)SectionTableViewerEditor.this.viewer).getTable();
            if (this.editRow_ != table.getItems().length - 1 || this.editColumn_ != SectionTableViewerEditor.this.columns_.length - 1) {
                if (this.editColumn_ < SectionTableViewerEditor.this.columns_.length - 1) {
                    ++this.editColumn_;
                } else {
                    this.editColumn_ = 0;
                    ++this.editRow_;
                    table.select(this.editRow_);
                }
                this.editSelection(this.editRow_, this.editColumn_);
            }
        }

        protected void traverseTabPrevious() {
            this.cancelSelection();
            if (this.editRow_ != 0 || this.editColumn_ != 0) {
                if (this.editColumn_ > 0) {
                    --this.editColumn_;
                } else {
                    this.editColumn_ = SectionTableViewerEditor.this.columns_.length - 1;
                    --this.editRow_;
                    ((TableViewer)SectionTableViewerEditor.this.viewer).getTable().select(this.editRow_);
                }
                this.editSelection(this.editRow_, this.editColumn_);
            }
        }

        public void cancelSelection() {
            SectionTableViewerEditor.this.internalDispose();
            SectionTableViewerEditor.this.viewer.refresh();
        }

        public void editSelection() {
            Table table = ((TableViewer)SectionTableViewerEditor.this.viewer).getTable();
            int selectedRowIndex = table.getSelectionIndex();
            if (selectedRowIndex != -1 && SectionTableViewerEditor.this.columns_.length > 0) {
                SectionTableViewerEditor.this.internalDispose();
                SectionTableViewerEditor.this.viewer.refresh();
                this.editSelection(selectedRowIndex, 0);
            }
            this.currSelectionIndex_ = selectedRowIndex;
        }
    }
}

