/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.ws;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.webtools.flatui.WidgetFactory;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WebServiceDescBrowseDialog
extends Dialog {
    private Table webServiceDescTable_;
    private TableViewer webServiceDescList_;
    private Label status_;
    private WebServices webServices_;
    private String[] excluded_;
    private String addedWebServicesDescName_;
    private Color red_;
    private WidgetFactory wf_;

    public WebServiceDescBrowseDialog(Shell shell, WebServices ws, String[] excluded) {
        super(shell);
        this.webServices_ = ws;
        this.excluded_ = excluded;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(J2EEUIPlugin.getResourceString("%DIALOG_TITLE_WEB_SERVICE_DESC"));
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        parent.getShell().setSize(400, 300);
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        composite.setLayoutData((Object)gd);
        this.wf_ = new WidgetFactory();
        this.webServiceDescTable_ = this.wf_.createTable(composite, 65540);
        this.webServiceDescTable_.setLayoutData((Object)gd);
        this.webServiceDescList_ = new TableViewer(this.webServiceDescTable_);
        this.webServiceDescList_.setContentProvider((IContentProvider)new WebServiceDescContentProvider());
        this.webServiceDescList_.setLabelProvider((IBaseLabelProvider)new WebServiceDescLabelProvider());
        this.webServiceDescList_.setInput((Object)this.webServices_);
        this.status_ = new Label(composite, 64);
        this.status_.setVisible(false);
        this.status_.setText(J2EEUIPlugin.getResourceString("%MSG_NO_WS_DESC"));
        this.red_ = new Color((Device)this.getShell().getDisplay(), 255, 0, 0);
        this.status_.setForeground(this.red_);
        if (this.webServiceDescTable_.getItemCount() > 0) {
            this.webServiceDescTable_.select(0);
        } else {
            this.status_.setVisible(true);
        }
        return composite;
    }

    public String getAddedWebServicesDescName() {
        return this.addedWebServicesDescName_;
    }

    protected void okPressed() {
        TableItem[] selection = this.webServiceDescTable_.getSelection();
        if (selection.length > 0) {
            TableItem item = selection[0];
            this.addedWebServicesDescName_ = item.getText();
            this.setReturnCode(0);
        } else {
            this.setReturnCode(1);
        }
        this.disposeWidgets();
        this.close();
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.disposeWidgets();
        this.close();
    }

    private void disposeWidgets() {
        if (this.red_ != null && !this.red_.isDisposed()) {
            this.red_.dispose();
        }
        if (this.wf_ != null) {
            this.wf_.dispose();
        }
    }

    public class WebServiceDescContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            int size;
            EList wsds = WebServiceDescBrowseDialog.this.webServices_.getWebServiceDescriptions();
            int resultSize = size = wsds.size();
            Object[] temp = new Object[size];
            Iterator i = wsds.iterator();
            int j = 0;
            while (i.hasNext()) {
                WebServiceDescription wsd = (WebServiceDescription)i.next();
                if (this.isExcluded(wsd)) {
                    temp[j] = null;
                    --resultSize;
                } else {
                    temp[j] = wsd;
                }
                ++j;
            }
            Object[] result = new Object[resultSize];
            int m = 0;
            int k = 0;
            while (k < size) {
                Object wsd = temp[k];
                if (wsd != null) {
                    result[m] = wsd;
                    ++m;
                }
                ++k;
            }
            return result;
        }

        private boolean isExcluded(WebServiceDescription wsd) {
            boolean excluded = false;
            String wsdName = wsd.getWebServiceDescriptionName();
            if (wsdName != null) {
                int size = WebServiceDescBrowseDialog.this.excluded_.length;
                int i = 0;
                while (i < size) {
                    if (wsdName.equals(WebServiceDescBrowseDialog.this.excluded_[i])) {
                        excluded = true;
                        break;
                    }
                    ++i;
                }
            }
            return excluded;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }
    }

    public class WebServiceDescLabelProvider
    extends LabelProvider {
        private Image image_ = null;

        public Image getImage(Object element) {
            Image imageObj;
            if (this.image_ == null && (imageObj = J2EEUIPlugin.getDefault().getImage("icons/obj16/webservicedesc.gif")) != null) {
                this.image_ = imageObj;
            }
            return this.image_;
        }

        public String getText(Object element) {
            WebServiceDescription wsd = (WebServiceDescription)element;
            return wsd.getWebServiceDescriptionName();
        }

        public void dispose() {
            if (this.image_ != null && !this.image_.isDisposed()) {
                this.image_.dispose();
            }
            super.dispose();
        }
    }
}

