/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.common;

import com.ibm.etools.webservice.atk.ui.editor.common.ExtendedAdapterViewer;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionControlInitializer;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionEditableControlInitializer;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionModelAbstract;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.webservice.adapter.AdapterViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class SectionViewer
extends SectionModelAbstract {
    protected AdapterViewer adapterViewer_;
    protected StructuredViewer viewer;
    protected Button addButton;
    protected Button removeButton;
    protected Button editButton;
    protected Composite clientComposite;
    protected Composite composite;

    public SectionViewer(Composite parent, int style, String aTitle, String formInfo, SectionEditableControlInitializer initializer) {
        super(parent, style, aTitle, formInfo, initializer);
    }

    @Override
    protected SectionControlInitializer createDefaultControlInitializer() {
        return new SectionEditableControlInitializer();
    }

    @Override
    public Composite createCollapsableClient(Composite parent) {
        if (!this.getSectionControlInitializer().getCollapsable()) {
            parent.setLayoutData((Object)new GridData(1808));
        }
        Composite collapsableSection = this.getWf().createComposite(parent);
        collapsableSection.setLayout((Layout)new GridLayout());
        collapsableSection.setLayoutData((Object)new GridData(1808));
        this.createMainViewerComposite(collapsableSection);
        this.addDeleteKeyLister();
        return collapsableSection;
    }

    protected void addDeleteKeyLister() {
        this.viewer.getControl().addKeyListener(this.getDeleteKeyListener());
    }

    protected KeyListener getDeleteKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
                char asciiDel = e.character;
                if (asciiDel == '\u007f') {
                    SectionViewer.this.handleDeleteKeyPressed();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        };
    }

    protected void createMainViewerComposite(Composite parent) {
        this.clientComposite = this.getWf().createComposite(parent);
        GridLayout gl = this.commonGridLayout();
        gl.numColumns = this.getEditableInitializer().getNumberOfViewerCompositeColumns();
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        this.clientComposite.setLayout((Layout)gl);
        this.clientComposite.setLayoutData((Object)new GridData(1808));
        this.viewer = this.getEditableInitializer().hasBorderOnTable ? this.createViewer(this.clientComposite) : this.createNoBorderViewer(this.clientComposite);
        this.createButtonComposite(this.clientComposite);
        this.getWf().paintBordersFor(this.clientComposite);
        this.adapterViewer_ = this.newAdapterViewer((Viewer)this.viewer);
    }

    protected AdapterViewer newAdapterViewer(Viewer v) {
        return new ExtendedAdapterViewer(v);
    }

    protected SectionEditableControlInitializer getEditableInitializer() {
        return (SectionEditableControlInitializer)this.controlInitializer;
    }

    protected StructuredViewer createNoBorderViewer(Composite parent) {
        return this.viewer;
    }

    protected void createButtonComposite(Composite parent) {
        SectionEditableControlInitializer initializer = this.getEditableInitializer();
        this.composite = this.getWf().createComposite(parent);
        GridLayout gl = this.commonGridLayout();
        if (!initializer.buttonsOnRight) {
            gl.numColumns = initializer.getNumberOfButtonCompositeColumns();
            gl.makeColumnsEqualWidth = true;
            this.composite.setLayoutData((Object)new GridData(544));
        } else {
            gl.marginHeight = 2;
            this.composite.setLayoutData((Object)new GridData(2));
        }
        this.composite.setLayout((Layout)gl);
        if (initializer.hasAddButton()) {
            this.createAddButton(this.composite);
        }
        if (initializer.hasEditButton()) {
            this.createEditButton(this.composite);
        }
        if (initializer.hasRemoveButton()) {
            this.createRemoveButton(this.composite);
        }
    }

    protected void createAddButton(Composite parent) {
        this.addButton = this.getWf().createButton(parent, this.getMessage("%LABEL_ADD"), 8);
        this.addButton.setLayoutData((Object)new GridData(256));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SectionViewer.this.handleAddButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.addSelectionChangedListener(this.createAddButtonEnablementSelectionChangedListener());
    }

    protected void createRemoveButton(Composite parent) {
        this.removeButton = this.getWf().createButton(parent, this.getMessage("%LABEL_REMOVE"), 8);
        this.removeButton.setLayoutData((Object)new GridData(256));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SectionViewer.this.handleRemoveButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton.setEnabled(false);
        this.addSelectionChangedListener(this.createRemoveButtonEnablementSelectionChangedListener());
    }

    protected void createEditButton(Composite parent) {
        this.editButton = this.getWf().createButton(parent, this.getMessage("%LABEL_EDIT"), 8);
        this.editButton.setLayoutData((Object)new GridData(256));
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SectionViewer.this.handleEditButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.setEnabled(false);
        this.addSelectionChangedListener(this.createEditButtonEnablementSelectionChangedListener());
    }

    protected ISelectionChangedListener createAddButtonEnablementSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SectionViewer.this.handleAddButtonEnablementSelectionChanged();
            }
        };
    }

    protected ISelectionChangedListener createRemoveButtonEnablementSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SectionViewer.this.handleRemoveButtonEnablementSelectionChanged();
            }
        };
    }

    protected ISelectionChangedListener createEditButtonEnablementSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SectionViewer.this.handleEditButtonEnablementSelectionChanged();
            }
        };
    }

    protected void handleAddButtonEnablementSelectionChanged() {
        this.addButton.setEnabled(true);
    }

    protected void handleRemoveButtonEnablementSelectionChanged() {
        ISelection sel = this.viewer.getSelection();
        if (sel.isEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
    }

    protected void handleEditButtonEnablementSelectionChanged() {
        ISelection sel = this.viewer.getSelection();
        if (sel.isEmpty()) {
            this.editButton.setEnabled(false);
        } else if (sel instanceof IStructuredSelection) {
            this.editButton.setEnabled(((IStructuredSelection)sel).size() == 1);
        } else {
            this.editButton.setEnabled(false);
        }
    }

    public StructuredViewer getStructuredViewer() {
        return this.viewer;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.viewer.setContentProvider(contentProvider);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setInput(Object input) {
        this.viewer.setInput(input);
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    public Object getSelectionAsObject() {
        ISelection selection = this.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection, true);
    }

    public void setSelectionAsObject(Object object) {
        this.setSelection((ISelection)new StructuredSelection(object));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void removeSectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void setEnabled(boolean enabled) {
        if (this.addButton != null) {
            if (enabled) {
                this.handleAddButtonEnablementSelectionChanged();
            } else {
                this.addButton.setEnabled(enabled);
            }
        }
        if (this.removeButton != null) {
            if (enabled) {
                this.handleRemoveButtonEnablementSelectionChanged();
            } else {
                this.removeButton.setEnabled(enabled);
            }
        }
        if (this.editButton != null) {
            if (enabled) {
                this.handleEditButtonEnablementSelectionChanged();
            } else {
                this.editButton.setEnabled(enabled);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.adapterViewer_.dispose();
    }

    @Override
    public void adaptModel(EObject eObject) {
        this.setInput(eObject);
        this.adapterViewer_.adapt(eObject);
        this.setEnabled(eObject != null);
    }

    protected abstract StructuredViewer createViewer(Composite var1);

    protected abstract void handleAddButtonSelected(SelectionEvent var1);

    protected abstract void handleRemoveButtonSelected(SelectionEvent var1);

    protected abstract void handleEditButtonSelected(SelectionEvent var1);

    protected abstract void handleDeleteKeyPressed();
}

