/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.web.ui.wizards;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.ui.nls.CommonAppEJBResourceHandler;
import com.ibm.etools.common.ui.sections.StringArrayTableWizardSection;
import com.ibm.etools.common.ui.wizards.dialogs.HierarchySelection;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.j2ee.web.internal.operations.AddFilterDataModel;
import com.ibm.etools.web.ui.nls.WebUIResourceHandler;
import com.ibm.etools.web.ui.wizards.FirstWebWizardPage;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class AddFilterWizardPage
extends FirstWebWizardPage {
    private Combo projectNameCombo;
    private Text displayNameText;
    private Label classLabel;
    private Text classText;
    private Button classButton;
    private Button existingButton;
    private StringArrayTableWizardSection urlSection;
    private String projectName;

    public AddFilterWizardPage(AddFilterDataModel aModel, String pageName) {
        super((WTPOperationDataModel)aModel, pageName);
        this.setDescription(WebUIResourceHandler.ADD_FILTER_WIZARD_PAGE_DESC);
        this.setTitle(WebUIResourceHandler.ADD_FILTER_WIZARD_PAGE_TITLE);
    }

    protected String[] getValidationPropertyNames() {
        String[] propNames = new String[]{"ArtifactEditOperationDataModel.PROJECT_NAME", "AddServletFilterListenerCommonDataModel.DISPLAY_NAME", "AddServletFilterListenerCommonDataModel.USE_EXISTING_CLASS", "AddServletFilterListenerCommonDataModel.CLASS_NAME", "AddFilterDataModel.INIT_PARAM", "AddFilterDataModel.URL_MAPPINGS"};
        return propNames;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.createNameDescription(composite);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                AddFilterWizardPage.this.updateSourceFolder();
            }
        });
        this.updateSourceFolder();
        new StringArrayTableWizardSection(composite, WebUIResourceHandler.INIT_PARAM_LABEL, WebUIResourceHandler.ADD_BUTTON_LABEL, WebUIResourceHandler.REMOVE_BUTTON_LABEL, new String[]{CommonAppEJBResourceHandler.Name__UI_, CommonAppEJBResourceHandler.Value__UI_, WebUIResourceHandler.DESCRIPTION_LABEL}, ExtendedImageRegistry.getInstance().getImage(WebPlugin.getDefault().getImage("initializ_parameter")), this.model, "AddFilterDataModel.INIT_PARAM");
        this.urlSection = new StringArrayTableWizardSection(composite, WebUIResourceHandler.URL_MAPPINGS_LABEL, WebUIResourceHandler.ADD_BUTTON_LABEL, WebUIResourceHandler.REMOVE_BUTTON_LABEL, new String[]{WebUIResourceHandler.URL_PATTERN_LABEL}, ExtendedImageRegistry.getInstance().getImage(WebPlugin.getDefault().getImage("url_type")), this.model, "AddFilterDataModel.URL_MAPPINGS");
        this.createClassGroup(composite);
        this.displayNameText.setFocus();
        IStatus projectStatus = this.validateSelectedProject();
        if (!projectStatus.isOK()) {
            this.setErrorMessage(projectStatus.getMessage());
            composite.setEnabled(false);
        }
        return composite;
    }

    protected void createNameDescription(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        Label displayNameLabel = new Label(composite, 16384);
        displayNameLabel.setText(CommonAppEJBResourceHandler.Name__UI_);
        displayNameLabel.setLayoutData((Object)new GridData(32));
        this.displayNameText = new Text(composite, 2052);
        this.displayNameText.setLayoutData((Object)new GridData(768));
        this.displayNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = AddFilterWizardPage.this.displayNameText.getText();
                ArrayList<String[]> input = new ArrayList<String[]>();
                input.add(new String[]{"/" + text});
                AddFilterWizardPage.this.urlSection.setInput(input);
            }
        });
        this.synchHelper.synchText(this.displayNameText, "AddServletFilterListenerCommonDataModel.DISPLAY_NAME", null);
        Label descLabel = new Label(composite, 16384);
        descLabel.setText(WebUIResourceHandler.DESCRIPTION_LABEL);
        descLabel.setLayoutData((Object)new GridData(32));
        Text descText = new Text(composite, 2052);
        descText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(descText, "AddServletFilterListenerCommonDataModel.DESCRIPTION", null);
    }

    protected void createClassGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.existingButton = new Button(composite, 32);
        this.existingButton.setText(WebUIResourceHandler.USE_EXISTING_FILTER_CLASS);
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        this.existingButton.setLayoutData((Object)data);
        this.synchHelper.synchCheckbox(this.existingButton, "AddServletFilterListenerCommonDataModel.USE_EXISTING_CLASS", null);
        this.existingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFilterWizardPage.this.handleExistingButtonSelected();
            }
        });
        this.classLabel = new Label(composite, 16384);
        this.classLabel.setText(WebUIResourceHandler.CLASS_NAME_LABEL);
        this.classLabel.setLayoutData((Object)new GridData(32));
        this.classLabel.setEnabled(false);
        this.classText = new Text(composite, 2060);
        this.classText.setLayoutData((Object)new GridData(768));
        this.classText.setEnabled(false);
        this.synchHelper.synchText(this.classText, "AddServletFilterListenerCommonDataModel.CLASS_NAME", null);
        this.classButton = new Button(composite, 8);
        this.classButton.setText(WebUIResourceHandler.BROWSE_BUTTON_LABEL);
        this.classButton.setLayoutData((Object)new GridData(256));
        this.classButton.setEnabled(false);
        this.classButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFilterWizardPage.this.handleClassButtonSelected();
            }
        });
    }

    private void handleExistingButtonSelected() {
        boolean enable = this.existingButton.getSelection();
        if (!enable) {
            this.classText.setText("");
        }
        this.classLabel.setEnabled(enable);
        this.classButton.setEnabled(enable);
    }

    private void handleClassButtonSelected() {
        IType type;
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IProject project = this.model.getTargetProject();
        HierarchySelection dialog = new HierarchySelection(this.getShell(), AddFilterDataModel.FILTER_INTERFACES, project, 4);
        dialog.setTitle(WebUIResourceHandler.FIND_FILTER_DIALOG_TITLE);
        dialog.setMessage(WebUIResourceHandler.FIND_FILTER_DIALOG_DESC);
        dialog.setUpperListLabel(CommonAppEJBWizardsResourceHandler.JAVA_CLASS_UPPER_LIST_LABEL);
        dialog.setLowerListLabel(CommonAppEJBWizardsResourceHandler.JAVA_CLASS_LOWER_LIST_LABEL);
        dialog.setErrorMessage(WebUIResourceHandler.NO_FILTER_CLASS_ERROR_MSG);
        if (dialog.open() == 0 && (type = (IType)dialog.getFirstResult()) != null) {
            this.classText.setText(type.getFullyQualifiedName());
        }
        this.getControl().setCursor(null);
    }

    public boolean canFlipToNextPage() {
        if (this.existingButton.getSelection()) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public boolean canFinish() {
        if (this.existingButton.getSelection()) {
            return this.classText.getText().trim().length() > 0 && super.canFlipToNextPage();
        }
        return false;
    }

    public String getDisplayName() {
        return this.displayNameText.getText();
    }

    private void updateSourceFolder() {
        String sourceFolder;
        if (this.projectNameCombo.getText() != null && this.projectNameCombo.getText().trim().length() != 0 && (sourceFolder = this.getDefaultJavaSourceFolder(ProjectUtilities.getProject((String)this.projectNameCombo.getText())).getFullPath().toOSString()) != null) {
            this.model.setProperty("NewJavaClassDataModel.SOURCE_FOLDER", (Object)sourceFolder);
        }
    }

    protected void createProjectNameGroup(Composite composite) {
        Label projectNameLabel = new Label(composite, 16384);
        projectNameLabel.setLayoutData((Object)new GridData(32));
        projectNameLabel.setText(J2EEUIMessages.getResourceString((String)"32"));
        this.projectNameCombo = new Combo(composite, 2060);
        this.projectNameCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.projectNameCombo, "ArtifactEditOperationDataModel.PROJECT_NAME", null);
        this.initializeProjectList();
    }

    private void initializeProjectList() {
        IProject[] workspaceProjects = ProjectUtilities.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            if (this.isProjectValid(project)) {
                items.add(project.getName());
            }
            ++i;
        }
        if (items.isEmpty()) {
            this.setErrorMessage(WebUIResourceHandler.ERR_NO_WEB_PROJECTS);
            return;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.projectNameCombo.setItems(names);
        IProject selectedProject = null;
        try {
            String projectNameFromModel;
            if (this.model != null && (projectNameFromModel = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) != null && projectNameFromModel.length() > 0) {
                selectedProject = ProjectUtilities.getProject((String)projectNameFromModel);
            }
        }
        catch (Exception exception) {}
        try {
            if (selectedProject == null) {
                selectedProject = this.getSelectedProject();
            }
            if (selectedProject != null && selectedProject.isAccessible() && selectedProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                this.projectNameCombo.setText(selectedProject.getName());
                this.model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)selectedProject.getName());
            }
        }
        catch (CoreException coreException) {}
        if (this.projectName == null && names.length > 0) {
            this.projectName = names[0];
        }
        if ((this.projectNameCombo.getText() == null || this.projectNameCombo.getText().length() == 0) && this.projectName != null) {
            this.projectNameCombo.setText(this.projectName);
            this.model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)this.projectName);
        }
    }

    private IProject getSelectedProject() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection stucturedSelection = (IStructuredSelection)selection;
        if (stucturedSelection.getFirstElement() instanceof EObject) {
            return ProjectUtilities.getProject((Object)stucturedSelection.getFirstElement());
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getJavaProject() != null) {
            return element.getJavaProject().getProject();
        }
        return null;
    }

    private IJavaElement getInitialJavaElement(ISelection selection) {
        IResource resource;
        IAdaptable adaptable;
        Object selectedElement;
        IJavaProject jelem = null;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (jelem = (IJavaElement)(adaptable = (IAdaptable)selectedElement).getAdapter(IJavaElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (jelem == null && resource.getType() != 4) {
                resource = resource.getParent();
                jelem = (IJavaElement)resource.getAdapter(IJavaElement.class);
            }
            if (jelem == null) {
                jelem = JavaCore.create((IResource)resource);
            }
        }
        if (jelem == null) {
            Object elem;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            IWorkbenchPart part = window.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = window.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof IJavaElement) {
                jelem = (IJavaElement)elem;
            }
        }
        if (jelem == null || jelem.getElementType() == 1) {
            try {
                IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
                if (projects.length == 1) {
                    jelem = projects[0];
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
            }
        }
        return jelem;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IFolder getDefaultJavaSourceFolder(IProject project) {
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources.length > 0) {
            try {
                return (IFolder)sources[0].getCorrespondingResource();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

