/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.web.ui.dialogs;

import com.ibm.etools.web.ui.nls.WebUIResourceHandler;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SuperInterfaceSelectionDialog
extends TypeSelectionDialog2 {
    protected static final int ADD_ID = 1025;
    protected IType[] wtOldContent;
    protected Viewer wtViewer;
    protected IJavaProject wtJavaProject;

    public SuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, IJavaProject p) {
        this(parent, context, p, null);
    }

    public SuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, IJavaProject p, Viewer viewer) {
        super(parent, false, context, SuperInterfaceSelectionDialog.createSearchScope(p), 6);
        this.setStatusLineAboveButtons(true);
        this.wtJavaProject = p;
        this.wtViewer = viewer;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, WebUIResourceHandler.ADD_LABEL, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void cancelPressed() {
        this.refreshViewer();
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addSelectedInterface();
        }
        this.refreshViewer();
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.addSelectedInterface();
        this.refreshViewer();
        super.okPressed();
    }

    protected void addSelectedInterface() {
        List input;
        Object ref = this.getFirstResult();
        String added = null;
        if (ref instanceof IType) {
            added = ((IType)ref).getFullyQualifiedName();
        }
        if (ref instanceof TypeNameMatch) {
            TypeNameMatch type = (TypeNameMatch)ref;
            added = type.getFullyQualifiedName();
        }
        if (this.wtViewer != null && added != null && !(input = (List)this.wtViewer.getInput()).contains(added)) {
            input.add(added);
        }
    }

    public Object getFirstResult() {
        TypeNameMatch[] result = this.getSelectedTypes();
        if (result == null || result.length == 0) {
            return null;
        }
        return result[0];
    }

    protected static IJavaSearchScope createSearchScope(IJavaProject p) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{p});
    }

    protected void handleDefaultSelected() {
        this.buttonPressed(1025);
    }

    protected void refreshViewer() {
        if (this.wtViewer != null) {
            TableViewer tabViewer;
            this.wtViewer.refresh();
            if (this.wtViewer instanceof TableViewer && (tabViewer = (TableViewer)this.wtViewer).getTable() != null) {
                tabViewer.getTable().select(tabViewer.getTable().getItemCount() - 1);
            }
        }
    }

    public Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        return control;
    }
}

