/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ui.navigator.framework;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.ui.navigator.framework.IRefreshHandlerListener;
import com.ibm.etools.ui.navigator.framework.IRootObjectProvider;
import com.ibm.etools.ui.navigator.framework.ModelManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;

public abstract class AbstractRootObjectProvider
implements IResourceChangeListener,
IResourceDeltaVisitor,
IRootObjectProvider {
    private final HashMap modelManagerCache = new HashMap();
    private final List listeners = new ArrayList();
    private boolean modelLoaded = false;

    public AbstractRootObjectProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected HashMap getModelManagerCache() {
        return this.modelManagerCache;
    }

    @Override
    public synchronized boolean hasLoadedModels(Object context) {
        return this.modelLoaded;
    }

    @Override
    public synchronized void setModelLoaded(Object context, boolean aModelLoaded) {
        this.modelLoaded = aModelLoaded;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                J2EEUIPlugin.logError(e);
            }
            catch (SWTException swte) {
                J2EEUIPlugin.logError(swte);
            }
            catch (SWTError swte) {
                J2EEUIPlugin.logError(swte);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.getListeners();
        synchronized (list) {
            if (aListener != null && !this.getListeners().contains(aListener)) {
                this.getListeners().add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRefreshHandlerListener(IRefreshHandlerListener aListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(aListener);
        }
    }

    protected List getListeners() {
        return this.listeners;
    }

    @Override
    public void notifyListeners(Object context) {
        int x = 0;
        while (x < this.listeners.size()) {
            IRefreshHandlerListener refreshHandler = (IRefreshHandlerListener)this.listeners.get(x);
            refreshHandler.onRefresh(context);
            ++x;
        }
    }

    public void dispose(Object context) {
        ModelManager modelManager = (ModelManager)this.modelManagerCache.remove(context);
        if (modelManager != null) {
            modelManager.dispose();
            modelManager = null;
        }
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        ModelManager modelManager = null;
        Object[] keys = this.modelManagerCache.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            modelManager = (ModelManager)this.modelManagerCache.remove(keys[i]);
            if (modelManager != null) {
                modelManager.dispose();
            }
            ++i;
        }
    }
}

