/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.manifest.ui;

import com.ibm.etools.common.ui.nls.CommonAppEJBResourceHandler;
import com.ibm.etools.emf.workbench.ui.custom.widgets.FormControlInitializer;
import com.ibm.etools.emf.workbench.ui.custom.widgets.PageControlInitializer;
import com.ibm.etools.emf.workbench.ui.listeners.IValidateEditListener;
import com.ibm.etools.emf.workbench.ui.listeners.ValidateEditListener;
import com.ibm.etools.emf.workbench.ui.nls.EMFWorkbenchUIResourceHandler;
import com.ibm.etools.emf.workbench.ui.presentation.BaseMultiPageEditorPart;
import com.ibm.etools.j2ee.common.ui.classpath.ManifestErrorPrompter;
import com.ibm.etools.j2ee.manifest.ui.DependenciesPage;
import com.ibm.etools.j2ee.manifest.ui.DocumentOutputStream;
import com.ibm.etools.j2ee.ui.nls.UIResourceHandler;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.internal.common.ClasspathModel;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelEvent;
import org.eclipse.jst.j2ee.internal.common.ClasspathModelListener;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.ResourceStateValidator;

public class JARDependencyEditor
extends BaseMultiPageEditorPart
implements ClasspathModelListener,
IDocumentListener,
IElementStateListener,
IResourceChangeListener {
    protected DependenciesPage dependenciesPage;
    protected ManifestTextEditor sourcePage;
    protected MultiPageSelectionProvider selectionProvider;
    protected ClasspathModel model;
    protected boolean documentChanged;
    protected int sourcePageIndex;
    protected boolean readOnly = false;
    protected IValidateEditListener validateEditListener;
    protected boolean isClosed = false;
    protected IOException caughtManifestException;
    protected boolean manifestWasInvalid = false;

    protected void initializeEditingDomain() {
    }

    protected void initializeInvalidEditingDomain() {
    }

    protected void initializeProviders() {
    }

    protected void primCreatePages() {
        this.initializeValidateEditListener();
        this.createDependenciesPage();
        this.createSourcePage();
        this.initializeResourceListener();
        this.dependenciesPage.setModel(this.getModel());
    }

    private void initializeResourceListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 4);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getResource().equals((Object)this.getProject()) && this.isDirty()) {
            this.closeEditor();
        }
    }

    protected ClasspathModel getModel() {
        if (this.model == null) {
            this.initializeModel();
        }
        return this.model;
    }

    protected void initializeModel() {
        this.model = new ExtendedClasspathModel(this.parseManifestFromFileInput());
        this.model.setProject(this.getProject());
        this.model.addListener((ClasspathModelListener)this);
    }

    protected void createDependenciesPage() {
        ViewForm viewForm = new ViewForm(this.getContainer(), 0);
        PageControlInitializer init = new PageControlInitializer();
        init.setIsHome(true);
        init.setMessageAreaWidth(400);
        init.setValidateEditListener(this.getValidateEditListener());
        init.setInfopopID("com.ibm.etools.j2ee.ui.EJB_JAR_DEPENDENCIES_EDITOR_PAGE1");
        this.dependenciesPage = new DependenciesPage((Composite)viewForm, 0, (FormControlInitializer)init);
        viewForm.setContent((Control)this.dependenciesPage);
        int index = this.addPage((Control)viewForm);
        this.setPageText(index, UIResourceHandler.DEPENDENCIES_TAB_UI_);
    }

    protected void createSourcePage() {
        try {
            this.sourcePage = this.createTextEditor();
            this.sourcePageIndex = this.addPage((IEditorPart)this.sourcePage, this.getEditorInput());
            this.setPageText(this.sourcePageIndex, CommonAppEJBResourceHandler.Source_UI_);
            if (this.getDocument() != null) {
                this.getDocument().addDocumentListener((IDocumentListener)this);
            }
            this.sourcePage.getDocumentProvider().addElementStateListener((IElementStateListener)this);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)CommonAppEJBResourceHandler.Error_creating_nested_text_editor_UI_, null, (IStatus)e.getStatus());
        }
    }

    protected ManifestTextEditor createTextEditor() {
        return new ManifestTextEditor();
    }

    protected IContentOutlinePage createContentOutlinePage() {
        return null;
    }

    protected void refreshPages() {
    }

    protected Viewer getPage(IStructuredSelection aSelection) {
        return null;
    }

    public boolean isDirty() {
        if (this.sourcePage != null) {
            return super.isDirty();
        }
        return false;
    }

    public boolean isSourcePageVisible() {
        return this.getActiveEditor() == this.sourcePage;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initializeSelectionProvider();
        site.setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    protected void initializeSelectionProvider() {
        this.selectionProvider = new MultiPageSelectionProvider((MultiPageEditorPart)this){
            ISelection lastSelection;
            {
                this.lastSelection = StructuredSelection.EMPTY;
            }

            public MultiPageEditorPart getMultiPageEditor() {
                return JARDependencyEditor.this;
            }

            public ISelection getSelection() {
                if (JARDependencyEditor.this.isSourcePageVisible()) {
                    return super.getSelection();
                }
                return this.lastSelection;
            }

            public void setSelection(ISelection selection) {
                if (JARDependencyEditor.this.isSourcePageVisible()) {
                    super.setSelection(selection);
                } else {
                    this.lastSelection = selection;
                    this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                }
            }
        };
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
        if (this.dependenciesPage != null) {
            this.dependenciesPage.dispose();
        }
        if (this.sourcePage != null) {
            this.sourcePage.dispose();
        }
        if (this.model != null) {
            this.model.removeListener((ClasspathModelListener)this);
            this.model.dispose();
        }
    }

    protected void removeListeners() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.sourcePage != null && this.sourcePage.getDocumentProvider() != null) {
            if (this.getDocument() != null) {
                this.getDocument().removeDocumentListener((IDocumentListener)this);
            }
            this.sourcePage.getDocumentProvider().removeElementStateListener((IElementStateListener)this);
        }
    }

    public void modelChanged(ClasspathModelEvent evt) {
        if (evt.getEventType() == 1 || evt.getEventType() == 5 || evt.getEventType() == 7) {
            this.refreshSourcePage();
        }
    }

    public void refreshSourcePage() {
        if (this.getDocument() != null) {
            DocumentOutputStream out = new DocumentOutputStream(this.getDocument());
            ArchiveManifest mf = ((ExtendedClasspathModel)this.model).getManifest();
            try {
                mf.writeSplittingClasspath((OutputStream)out);
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void refreshFromSourcePage(ArchiveManifest mf) {
        if (mf != null) {
            this.model.setManifest(mf);
        }
    }

    protected boolean refreshFromSourcePageIfPossible() {
        ArchiveManifest mf = this.parseManifestFromSourcePage();
        if (this.caughtManifestException != null) {
            this.showManifestException();
            if (this.getActivePage() != this.sourcePageIndex) {
                super.setActivePage(this.sourcePageIndex);
                super.pageChange(this.sourcePageIndex);
            }
            return false;
        }
        this.manifestWasInvalid = false;
        this.documentChanged = false;
        if (mf != null) {
            this.refreshFromSourcePage(mf);
        }
        return true;
    }

    protected IDocument getDocument() {
        if (this.sourcePage.getDocumentProvider() != null) {
            return this.sourcePage.getDocumentProvider().getDocument((Object)this.getEditorInput());
        }
        return null;
    }

    /*
     * Loose catch block
     */
    protected ArchiveManifest parseManifest(InputStream in) {
        ArchiveManifestImpl archiveManifestImpl;
        block11: {
            archiveManifestImpl = new ArchiveManifestImpl(new Manifest(in));
            if (in == null) break block11;
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return archiveManifestImpl;
        catch (IOException ex) {
            ArchiveManifestImpl archiveManifestImpl2;
            block12: {
                try {
                    this.caughtManifestException = ex;
                    archiveManifestImpl2 = new ArchiveManifestImpl();
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return archiveManifestImpl2;
        }
    }

    protected ArchiveManifest parseManifestFromSourcePage() {
        if (this.getDocument() != null) {
            StringBufferInputStream in = new StringBufferInputStream(this.getDocument().get());
            return this.parseManifest(in);
        }
        return null;
    }

    protected ArchiveManifest parseManifestFromFileInput() {
        IEditorInput input = this.getEditorInput();
        InputStream in = null;
        try {
            IStorage storage;
            if (input instanceof IStorageEditorInput && (storage = ((IStorageEditorInput)input).getStorage()) != null) {
                in = storage.getContents();
            }
        }
        catch (CoreException core) {
            J2EEUIPlugin.logError(core);
        }
        if (in != null) {
            return this.parseManifest(in);
        }
        return null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (this.getActivePage() == this.sourcePageIndex) {
            this.documentChanged = true;
        }
    }

    protected boolean showManifestException() {
        return this.showManifestException(EMFWorkbenchUIResourceHandler.ERROR_READING_MANIFEST_DIALOG_MESSAGE_EDITOR, false);
    }

    protected boolean showManifestException(String message, boolean includeCancel) {
        boolean answer = ManifestErrorPrompter.showManifestException(this.getContainer().getShell(), message, includeCancel, this.caughtManifestException);
        this.caughtManifestException = null;
        this.manifestWasInvalid = true;
        return answer;
    }

    protected void setActivePage(int pageIndex) {
        if (this.caughtManifestException != null) {
            super.setActivePage(this.sourcePageIndex);
            this.showManifestException();
        } else {
            super.setActivePage(pageIndex);
        }
    }

    protected void pageChange(int pageIndex) {
        if (pageIndex != this.sourcePageIndex && (this.documentChanged || this.manifestWasInvalid) && !this.refreshFromSourcePageIfPossible()) {
            return;
        }
        super.pageChange(pageIndex);
    }

    public void doSave(IProgressMonitor monitor) {
        boolean manifestBad = false;
        if (this.isSourcePageVisible()) {
            ArchiveManifest mf = this.parseManifestFromSourcePage();
            if (this.caughtManifestException == null) {
                this.refreshFromSourcePage(mf);
            } else {
                if (!this.showManifestException(EMFWorkbenchUIResourceHandler.SAVE_MANIFEST_WITH_ERROR, true)) {
                    return;
                }
                manifestBad = true;
            }
        }
        this.sourcePage.primDoSave(monitor);
        if (manifestBad) {
            return;
        }
        if (this.model != null) {
            this.model.fireSavedEvent();
            this.model.getClassPathSelection().setModified(false);
        }
    }

    protected void updateBuildPathFailed(InvocationTargetException badNews) {
        J2EEUIPlugin.logError(badNews);
    }

    protected void initializeValidateEditListener() {
        this.validateEditListener = new ValidateEditListener((IWorkbenchPart)this, (ResourceStateValidator)this.getModel()){

            protected void updatePartReadOnly() {
                super.updatePartReadOnly();
                JARDependencyEditor.this.updateActionBars();
            }
        };
    }

    public IValidateEditListener getValidateEditListener() {
        return this.validateEditListener;
    }

    public boolean hasReadOnlyContents() {
        if (this.isReadOnly()) {
            return true;
        }
        if (this.getValidateEditListener() != null) {
            return this.getValidateEditListener().hasReadOnlyFiles();
        }
        return false;
    }

    public void udpateReadOnlyStatusMessages(boolean hasReadOnlyContents) {
        this.updateActionBars();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean aBoolean) {
        this.readOnly = aBoolean;
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
        this.refreshFromSourcePageIfPossible();
    }

    public void elementDeleted(Object element) {
        if (this.isClosed || this.isDisposed()) {
            return;
        }
        if (this.isDirty() && !this.getProject().exists()) {
            this.removeListeners();
            this.isClosed = true;
            this.closeEditor();
        }
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    public void selectReveal(ISelection selection) {
        Object obj;
        IStructuredSelection select = (IStructuredSelection)selection;
        if (select != null && "Main-Class".equals(obj = select.getFirstElement()) && !this.manifestWasInvalid) {
            int index = 0;
            this.setActivePage(index);
            this.dependenciesPage.setFocusToMainClassSection();
        }
    }

    protected boolean isValidInput() {
        return this.getProject() != null && ModuleCoreNature.getModuleCoreNature((IProject)this.getProject()) != null;
    }

    protected String getRedirectedEditorID() {
        return "org.eclipse.ui.DefaultTextEditor";
    }

    protected String getRedirectedEditorMessage() {
        return EMFWorkbenchUIResourceHandler.REDIRECT_TEXT_EDITOR_UI_;
    }

    public void setFocus() {
        if (this.dependenciesPage != null && this.getActivePage() == 0) {
            this.dependenciesPage.forceFocus();
        }
        super.setFocus();
    }

    public class ExtendedClasspathModel
    extends ClasspathModel {
        public ExtendedClasspathModel(ArchiveManifest initialManifest) {
            super(initialManifest);
        }

        public ArchiveManifest getManifest() {
            return this.manifest;
        }
    }

    protected class ManifestTextEditor
    extends TextEditor {
        public void close(final boolean save) {
            Display display = this.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ManifestTextEditor.this.getSourceViewer() != null) {
                        ManifestTextEditor.this.getSite().getPage().closeEditor((IEditorPart)JARDependencyEditor.this, save);
                    }
                }
            });
        }

        public void doSave(IProgressMonitor progressMonitor) {
            JARDependencyEditor.this.doSave(progressMonitor);
        }

        public void primDoSave(IProgressMonitor progressMonitor) {
            this.performSave(false, progressMonitor);
        }

        protected void validateState(IEditorInput input) {
            boolean wasReadOnly = this.isEditorInputReadOnly();
            boolean validated = JARDependencyEditor.this.validateEditListener.validateState().isOK();
            if (this.getSourceViewer() != null) {
                this.getSourceViewer().setEditable(validated);
            }
            if (wasReadOnly != this.isEditorInputReadOnly()) {
                this.updateStateDependentActions();
            }
        }
    }
}

