/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;

public class UpdateManifestOperation
implements IRunnableWithProgress {
    protected String projectName;
    protected String classPathValue;
    protected boolean replace;

    public UpdateManifestOperation(String aProjectName, String aSpaceDelimitedPath, boolean replaceInsteadOfMerge) {
        this.projectName = aProjectName;
        this.classPathValue = aSpaceDelimitedPath;
        this.replace = replaceInsteadOfMerge;
    }

    protected IProject getProject() {
        return J2EEPlugin.getWorkspace().getRoot().getProject(this.projectName);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IProject p = this.getProject();
        try {
            ArchiveManifest mf = J2EEProjectUtilities.readManifest((IProject)p);
            if (mf == null) {
                mf = new ArchiveManifestImpl();
            }
            mf.addVersionIfNecessary();
            if (this.replace) {
                mf.setClassPath(this.classPathValue);
            } else {
                mf.mergeClassPath(ArchiveUtil.getTokens((String)this.classPathValue));
            }
            J2EEProjectUtilities.writeManifest((IProject)p, (ArchiveManifest)mf);
        }
        catch (IOException ex) {
            throw new WFTWrappedException((Throwable)ex);
        }
    }
}

