/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.wizard;

import com.ibm.etools.emf.workbench.ui.nls.EMFWorkbenchUIResourceHandler;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;

public class JARDependencyUtil {
    private static JARDependencyUtil singleton;

    protected JARDependencyUtil() {
    }

    public static JARDependencyUtil getSingleton() {
        if (singleton == null) {
            singleton = new JARDependencyUtil();
        }
        return singleton;
    }

    public void addJARDependencyIfNecessary(IProject referencing, IProject referenced, IProject earProj, IRunnableContext context, boolean allowAutoBuild, boolean shouldFork) {
        IDataModel dataModel = DataModelFactory.createDataModel(JARDependencyDataModelProvider.class);
        dataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)referencing.getName());
        dataModel.setProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME", (Object)referenced.getName());
        dataModel.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)earProj.getName());
        dataModel.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 0);
        JARDependencyOperation op = new JARDependencyOperation(dataModel);
        this.executeOperation(context, allowAutoBuild, shouldFork, op);
    }

    public void addJARDependencyIfNecessary(IProject referencing, IProject referenced, IProject earProj, IRunnableContext context, boolean allowAutoBuild) {
        this.addJARDependencyIfNecessary(referencing, referenced, earProj, context, allowAutoBuild, true);
    }

    public void addJARDependencyIfNecessary(IProject referencing, String jarName, IProject earProj, IRunnableContext context, boolean allowAutoBuild, boolean shouldFork) {
        IDataModel dataModel = DataModelFactory.createDataModel(JARDependencyDataModelProvider.class);
        dataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)referencing.getName());
        dataModel.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)earProj.getName());
        ArrayList<String> jarList = new ArrayList<String>();
        jarList.add(jarName);
        dataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", jarList);
        dataModel.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 0);
        JARDependencyOperation op = new JARDependencyOperation(dataModel);
        this.executeOperation(context, allowAutoBuild, shouldFork, op);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeOperation(IRunnableContext context, boolean allowAutoBuild, boolean shouldFork, JARDependencyOperation op) {
        if (context == null) {
            context = new ProgressMonitorDialog(null);
        }
        boolean switchAutoBuild = !allowAutoBuild && ProjectUtilities.getCurrentAutoBuildSetting();
        try {
            try {
                if (switchAutoBuild) {
                    ProjectUtilities.turnAutoBuildOff();
                }
                context.run(shouldFork, true, (IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)op));
                return;
            }
            catch (InvocationTargetException ex) {
                String title;
                String msg = title = EMFWorkbenchUIResourceHandler.An_internal_error_occurred_ERROR_;
                if (ex.getTargetException() != null && ex.getTargetException().getMessage() != null) {
                    msg = ex.getTargetException().getMessage();
                }
                MessageDialog.openError(null, (String)title, (String)msg);
                J2EEUIPlugin.logError(ex);
                if (!switchAutoBuild) return;
                ProjectUtilities.turnAutoBuildOn();
                return;
            }
            catch (InterruptedException interruptedException) {
                if (!switchAutoBuild) return;
                ProjectUtilities.turnAutoBuildOn();
                return;
            }
        }
        finally {
            if (switchAutoBuild) {
                ProjectUtilities.turnAutoBuildOn();
            }
        }
    }
}

