/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.wizard;

import com.ibm.etools.emf.workbench.ui.nls.EMFWorkbenchUIResourceHandler;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.frameworks.internal.WTPPlugin;

public class ImportUtil {
    public static final int UNKNOWN = 0;
    public static final int EARFILE = 1;
    public static final int EJBJARFILE = 2;
    public static final int WARFILE = 3;
    public static final int CLIENTJARFILE = 4;
    public static final int RARFILE = 5;
    public static final int IMPORTCLASSTYPE = 6;
    public static final int J2EE14 = 256;
    public static final int J2EE13 = 128;
    public static final int J2EE12 = 64;
    public static final int J2EESpec = 448;
    public static final String EAR = EMFWorkbenchUIResourceHandler.Assembly_Application_Project_Suffix;
    public static final String EJB = EMFWorkbenchUIResourceHandler.Assembly_EJBJAR_Project_Suffix;
    public static final String WAR = EMFWorkbenchUIResourceHandler.Assembly_Web_Project_Suffix;
    public static final String JAR = EMFWorkbenchUIResourceHandler.Assembly_ClientJAR_Project_Suffix;
    public static final String RAR = EMFWorkbenchUIResourceHandler.Assembly_Connector_Project_Suffix;
    public static final String[] SUFFIXES = new String[]{"", EAR, EJB, WAR, JAR, RAR, ""};

    public static int getFileType(String fileName) {
        Archive anArchive = null;
        try {
            anArchive = CommonarchiveFactoryImpl.getActiveFactory().openArchive(fileName);
            int archiveType = ImportUtil.getArchiveType(anArchive);
            if (archiveType == 0 && ImportUtil.isImportClassType(fileName)) {
                return 6;
            }
            int n = archiveType;
            return n;
        }
        catch (Exception exception) {
            if (ImportUtil.isImportClassType(fileName)) {
                return 6;
            }
            return 0;
        }
        finally {
            if (anArchive != null && anArchive.isOpen()) {
                anArchive.close();
            }
        }
    }

    public static int getVersionedFileType(String fileName) {
        Archive anArchive = null;
        try {
            int archiveType = 0;
            try {
                anArchive = CommonarchiveFactoryImpl.getActiveFactory().openArchive(fileName);
                try {
                    int version = 0;
                    if (anArchive.isEJBJarFile()) {
                        archiveType = 2;
                        version = ((EJBJarFile)anArchive).getDeploymentDescriptor().getVersionID();
                        switch (version) {
                            case 11: {
                                archiveType |= 0x40;
                                break;
                            }
                            case 20: {
                                archiveType |= 0x80;
                                break;
                            }
                            case 21: {
                                archiveType |= 0x100;
                            }
                        }
                    } else if (anArchive.isWARFile()) {
                        archiveType = 3;
                        version = ((WARFile)anArchive).getDeploymentDescriptor().getVersionID();
                        switch (version) {
                            case 22: {
                                archiveType |= 0x40;
                                break;
                            }
                            case 23: {
                                archiveType |= 0x80;
                                break;
                            }
                            case 24: {
                                archiveType |= 0x100;
                            }
                        }
                    } else if (anArchive.isApplicationClientFile()) {
                        archiveType = 4;
                        version = ((ApplicationClientFile)anArchive).getDeploymentDescriptor().getVersionID();
                        switch (version) {
                            case 12: {
                                archiveType |= 0x40;
                                break;
                            }
                            case 13: {
                                archiveType |= 0x80;
                                break;
                            }
                            case 14: {
                                archiveType |= 0x100;
                            }
                        }
                    } else if (anArchive.isRARFile()) {
                        archiveType = 133;
                    } else if (anArchive.isEARFile()) {
                        archiveType = 1;
                        version = ((EARFile)anArchive).getDeploymentDescriptor().getVersionID();
                        switch (version) {
                            case 12: {
                                archiveType |= 0x40;
                                break;
                            }
                            case 13: {
                                archiveType |= 0x80;
                                break;
                            }
                            case 14: {
                                archiveType |= 0x100;
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {}
            if (archiveType == 0 && ImportUtil.isImportClassType(fileName)) {
                archiveType = 6;
            }
            int n = archiveType;
            return n;
        }
        finally {
            if (anArchive != null && anArchive.isOpen()) {
                anArchive.close();
            }
        }
    }

    public static int getArchiveType(Archive anArchive) {
        int type = 0;
        try {
            if (anArchive.isEJBJarFile()) {
                type = 2;
            } else if (anArchive.isWARFile()) {
                type = 3;
            } else if (anArchive.isApplicationClientFile()) {
                type = 4;
            } else if (anArchive.isRARFile()) {
                type = 5;
            } else if (anArchive.isEARFile()) {
                type = 1;
            }
        }
        catch (Exception exception) {}
        return type;
    }

    public static boolean isImportClassType(String fileName) {
        File file = new File(fileName);
        String fileExtension = ImportUtil.getExtension(file);
        if (file.isFile()) {
            if (fileExtension.equalsIgnoreCase("jar") || fileExtension.equalsIgnoreCase("zip") || fileExtension.equalsIgnoreCase("class")) {
                return true;
            }
        } else if (file.isDirectory()) {
            return false;
        }
        return false;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String findMatchingProjectName(String projectName) {
        if (projectName.trim().length() > 0) {
            IWorkspaceRoot root = J2EEPlugin.getWorkspace().getRoot();
            IProject[] projects = root.getProjects();
            String lowerCaseName = projectName.toLowerCase();
            if (projectName.length() == 0) {
                if (projects.length == 1) {
                    return projects[0].getName();
                }
                return null;
            }
            int i = 0;
            while (i < projects.length) {
                if (projects[i].exists() && (WTPPlugin.isPlatformCaseSensitive() ? projects[i].getName().equals(projectName) : projects[i].getName().toLowerCase().equals(lowerCaseName))) {
                    return projects[i].getName();
                }
                ++i;
            }
        }
        return projectName;
    }
}

