/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.wizard;

import com.ibm.etools.j2ee.common.wizard.AvailableJarsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.WARFileImpl;
import org.eclipse.swt.graphics.Image;

public class AvailableUtilJarsAndWebLibProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private Collection ejbClientJARs;

    public AvailableUtilJarsAndWebLibProvider() {
    }

    public AvailableUtilJarsAndWebLibProvider(Collection ejbClientJARs) {
        this.ejbClientJARs = ejbClientJARs;
    }

    public Object[] getElements(Object inputElement) {
        EList files = ((Archive)inputElement).getFiles();
        ArrayList<FileImpl> utilJars = new ArrayList<FileImpl>();
        int i = 0;
        while (i < files.size()) {
            List webLib;
            FileImpl file = (FileImpl)files.get(i);
            if (file.isArchive() && !file.isModuleFile() && file.getURI().endsWith(".jar") && !this.isEjbClientJAR(file)) {
                utilJars.add(file);
            }
            if (file.isWARFile() && !(webLib = ((WARFileImpl)file).getLibArchives()).isEmpty()) {
                utilJars.addAll(webLib);
            }
            ++i;
        }
        return utilJars.toArray();
    }

    private boolean isEjbClientJAR(FileImpl file) {
        return this.ejbClientJARs != null && this.ejbClientJARs.contains(file);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return AvailableJarsProvider.getUtilImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        FileImpl file = (FileImpl)element;
        if (file.getURI().startsWith("WEB-INF/lib/")) {
            String parentWarFileName = ((WARFile)file.eContainer()).getName();
            return String.valueOf(parentWarFileName) + "#" + file.getURI();
        }
        return file.getName();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Collection getEjbClientJARs() {
        return this.ejbClientJARs;
    }

    public void setEjbClientJARs(Collection collection) {
        this.ejbClientJARs = collection;
    }
}

