/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.dialogs;

import com.ibm.etools.emf.workbench.ui.nls.EMFWorkbenchUIResourceHandler;
import com.ibm.etools.j2ee.internal.project.IApplicationClientNatureConstants;
import com.ibm.etools.j2ee.internal.project.IEARNatureConstants;
import com.ibm.etools.j2ee.internal.project.IEJBNatureConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.dialogs.ISelectionValidator;

public class J2EEProjectSelectionValidator
implements ISelectionValidator {
    protected static String MUST_BE_MODULE_PROJECT = EMFWorkbenchUIResourceHandler.Must_be_an_Application_Cli_UI_;
    protected static String MUST_BE_EJB_PROJECT = EMFWorkbenchUIResourceHandler.Must_be_an_EJB_project__UI_;
    protected static String MUST_BE_WEB_PROJECT = EMFWorkbenchUIResourceHandler.Selection_must_be_a_Web_pr_UI_;
    protected static String MUST_BE_EAR_PROJECT = EMFWorkbenchUIResourceHandler.Must_be_an_Enterprise_Appl_UI_;
    protected static String MUST_BE_APP_CLIENT_J2EE13_PROJECT = EMFWorkbenchUIResourceHandler.Must_be_an_Application_Cli1_j2ee13_UI_;
    protected static String MUST_BE_APP_CLIENT_PROJECT = EMFWorkbenchUIResourceHandler.Must_be_an_Application_Cli1_UI_;
    protected static String MUST_BE_CONNECTOR_PROJECT = EMFWorkbenchUIResourceHandler.Must_be_an_Connector_Cli1_UI_;
    protected static String MUST_BE_EAR_J2EE13_PROJECT = EMFWorkbenchUIResourceHandler.Must_be_an_J2EE13_EAR_Project_UI_;
    public static final int MODULE_PROJECTS = 0;
    public static final int EJB_PROJECTS = 1;
    public static final int WEB_PROJECTS = 2;
    public static final int EAR_PROJECTS = 3;
    public static final int APP_CLIENT_PROJECTS = 4;
    public static final int APP_CLIENT_J2EE13_PROJECTS = 5;
    public static final int CONNECTOR_PROJECTS = 6;
    public static final int EAR_J2EE13_PROJECTS = 7;
    private static final int MAX_VALID_VALUE = 7;
    protected int filter;

    public J2EEProjectSelectionValidator(int projectType) {
        if (projectType < 0 || projectType > 7) {
            throw new IllegalArgumentException();
        }
        this.filter = projectType;
    }

    public String isValid(Object selection) {
        IProject project = this.selectionToProject(selection);
        String s = this.getAccessibleProjectValidationMessage(project);
        if (s != null) {
            return s;
        }
        switch (this.filter) {
            case 0: {
                return this.getModuleValidationMessage(project);
            }
            case 1: {
                return this.getAnyEJBValdiationMessage(project);
            }
            case 2: {
                return this.getWebValidationMessage(project);
            }
            case 3: {
                return this.getAnyEARValidationMessage(project);
            }
            case 4: {
                return this.get1_2AppClientValidationMessage(project);
            }
            case 5: {
                return this.get1_3AppClientValidationMessage(project);
            }
            case 6: {
                return this.getConnectorValidationMessage(project);
            }
            case 7: {
                return this.get1_3EARValidationMessage(project);
            }
        }
        return null;
    }

    protected String getAccessibleProjectValidationMessage(IProject project) {
        if (project != null && !project.isAccessible()) {
            return NLS.bind((String)EMFWorkbenchUIResourceHandler.PROJECT_NOT_ACCESSIBLE, (Object[])new String[]{project.getName()});
        }
        return null;
    }

    protected String getModuleValidationMessage(IProject project) {
        return this.isValidModuleProject(project) ? null : MUST_BE_MODULE_PROJECT;
    }

    protected String getAnyEJBValdiationMessage(IProject project) {
        return this.isValidModuleProject(project, IEJBNatureConstants.EJB_NATURE_IDS) ? null : MUST_BE_EJB_PROJECT;
    }

    protected String getWebValidationMessage(IProject project) {
        return this.isValidModuleProject(project, "org.eclipse.jst.j2ee.web.WebNature") ? null : MUST_BE_WEB_PROJECT;
    }

    protected String getAnyEARValidationMessage(IProject project) {
        return this.isValidModuleProject(project, IEARNatureConstants.NATURE_IDS) ? null : MUST_BE_EAR_PROJECT;
    }

    protected String get1_2AppClientValidationMessage(IProject project) {
        return this.isValidModuleProject(project, IApplicationClientNatureConstants.APPCLIENT_NATURE_IDS) ? null : MUST_BE_APP_CLIENT_PROJECT;
    }

    protected String get1_3AppClientValidationMessage(IProject project) {
        return this.isValidModuleProject(project, "org.eclipse.jst.j2ee.ApplicationClientNature") ? null : MUST_BE_APP_CLIENT_J2EE13_PROJECT;
    }

    protected String getConnectorValidationMessage(IProject project) {
        return this.isValidModuleProject(project, "org.eclipse.jst.j2ee.jca.ConnectorNature") ? null : MUST_BE_CONNECTOR_PROJECT;
    }

    protected String get1_3EARValidationMessage(IProject project) {
        return this.isValidModuleProject(project, "org.eclipse.jst.j2ee.EARNature") ? null : MUST_BE_EAR_J2EE13_PROJECT;
    }

    public boolean isValidModuleProject(IProject project) {
        return true;
    }

    public boolean isValidModuleProject(IProject project, String natureId) {
        if (project == null) {
            return false;
        }
        try {
            return project.hasNature(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean isValidModuleProject(IProject project, String natureId, String natureId1) {
        if (project == null) {
            return false;
        }
        try {
            return project.hasNature(natureId) || project.hasNature(natureId1);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidModuleProject(IProject project, String[] natureIds) {
        if (project == null) {
            return false;
        }
        try {
            int i = 0;
            while (true) {
                if (i >= natureIds.length) {
                    return false;
                }
                if (project.hasNature(natureIds[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IProject selectionToProject(Object o) {
        if (!(o instanceof IPath)) {
            return null;
        }
        IProject p = null;
        try {
            p = J2EEPlugin.getWorkspace().getRoot().getProject(o.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return p.exists() ? p : null;
    }
}

