/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards.listeners;

import com.ibm.etools.j2ee.common.presentation.temp.ExtendedCheckboxTreeViewer;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public class StandardTreeCheckStateListener
implements ICheckStateListener {
    public void checkStateChanged(CheckStateChangedEvent event) {
        if (event.getSource() instanceof ExtendedCheckboxTreeViewer) {
            ExtendedCheckboxTreeViewer viewer = (ExtendedCheckboxTreeViewer)((Object)event.getSource());
            TreeItem last = viewer.getLastClickedTreeItem();
            boolean checked = event.getChecked();
            if (last.getGrayed()) {
                last.setGrayed(false);
                last.setChecked(true);
                checked = true;
            }
            this.processChildren(checked, last, event);
            this.processParent(last);
        }
    }

    public void processParent(TreeItem last) {
        TreeItem parent = last.getParentItem();
        if (parent != null) {
            TreeItem[] items = parent.getItems();
            ArrayList<TreeItem> checked = new ArrayList<TreeItem>();
            int i = 0;
            while (i < items.length) {
                TreeItem current = items[i];
                if (current.getChecked()) {
                    checked.add(current);
                }
                ++i;
            }
            if (checked.isEmpty()) {
                parent.setChecked(false);
                parent.setGrayed(false);
            } else if (checked.size() < items.length) {
                parent.setChecked(true);
                parent.setGrayed(true);
            } else if (checked.size() == items.length) {
                parent.setChecked(true);
                parent.setGrayed(false);
            }
            this.processParent(parent);
        }
    }

    public boolean processChildren(boolean checked, TreeItem last, CheckStateChangedEvent event) {
        if (last.getItems().length != 0) {
            ((TreeViewer)event.getSource()).expandToLevel(last.getData(), 1);
            TreeItem[] items = last.getItems();
            int i = 0;
            while (i < last.getItemCount()) {
                items[i].setChecked(checked);
                this.processChildren(checked, items[i], event);
                ++i;
            }
            return true;
        }
        return false;
    }
}

