/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards;

import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.ui.gef.widgets.ClassConnectionAnchor;
import com.ibm.etools.ejb.ui.gef.widgets.ClassFigure;
import com.ibm.etools.ejb.ui.gef.widgets.DropShadowBorder;
import com.ibm.etools.ejb.ui.gef.widgets.FeatureGroupFigure;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class RelationshipCanvas
extends Canvas {
    boolean changeColorFirst = false;
    boolean changeColorSecond = false;
    boolean ejb20Setup = false;
    Color highLightedColor = ColorConstants.blue;
    LightweightSystem lws = new LightweightSystem();
    ClassFigure beanA = new ClassFigure(){

        protected void paintBorder(Graphics g) {
            if (RelationshipCanvas.this.changeColorFirst) {
                g.setLineStyle(3);
            }
            super.paintBorder(g);
        }
    };
    ClassFigure beanB = new ClassFigure(){

        protected void paintBorder(Graphics g) {
            if (RelationshipCanvas.this.changeColorSecond) {
                g.setLineStyle(3);
            }
            super.paintBorder(g);
        }
    };
    PolylineConnection connection = new PolylineConnection();
    Label roleAName = new Label(){

        protected void paintBorder(Graphics g) {
            if (RelationshipCanvas.this.changeColorSecond) {
                g.setLineStyle(3);
            }
            super.paintBorder(g);
        }
    };
    Label roleBName = new Label(){

        protected void paintBorder(Graphics g) {
            if (RelationshipCanvas.this.changeColorFirst) {
                g.setLineStyle(3);
            }
            super.paintBorder(g);
        }
    };
    Label relationshipName = new Label();
    Label roleAMultiplicity = new Label(){

        protected void paintBorder(Graphics g) {
            if (RelationshipCanvas.this.changeColorSecond && !RelationshipCanvas.this.ejb20Setup) {
                g.setLineStyle(3);
            } else if (RelationshipCanvas.this.changeColorFirst && RelationshipCanvas.this.ejb20Setup) {
                g.setLineStyle(3);
            }
            super.paintBorder(g);
        }
    };
    Label roleBMultiplicity = new Label(){

        protected void paintBorder(Graphics g) {
            if (RelationshipCanvas.this.changeColorFirst && !RelationshipCanvas.this.ejb20Setup) {
                g.setLineStyle(3);
            } else if (RelationshipCanvas.this.changeColorSecond && RelationshipCanvas.this.ejb20Setup) {
                g.setLineStyle(3);
            }
            super.paintBorder(g);
        }
    };

    public RelationshipCanvas(Composite parent, int style, boolean ejb20Setup) {
        super(parent, style);
        this.ejb20Setup = ejb20Setup;
        this.lws.setControl((Canvas)this);
        this.buildFigures();
    }

    private void setupClass(ClassFigure fig) {
        fig.setMinimumSize(new Dimension(100, 11));
        fig.setIcon(J2EEUIPlugin.getDefault().getImage("cmpEntity_obj"));
        FeatureGroupFigure group = new FeatureGroupFigure();
        group.setPreferredSize(new Dimension(9, 9));
        fig.getContentPane().add((IFigure)group);
        group = new FeatureGroupFigure();
        group.setPreferredSize(new Dimension(9, 9));
        fig.getContentPane().add((IFigure)group);
    }

    private void setupLabelBorder(Label lab) {
        lab.setBorder((Border)new CompoundBorder((Border)new LineBorder(FigureUtilities.mixColors((Color)ColorConstants.black, (Color)ColorConstants.titleGradient), 1), (Border)new MarginBorder(1, 2, 1, 1)));
        lab.setOpaque(true);
        lab.setBackgroundColor(ColorConstants.white);
    }

    private void highLightBorder(Label lab) {
        lab.setBorder((Border)new CompoundBorder((Border)new LineBorder(this.highLightedColor, 1), (Border)new MarginBorder(1, 2, 1, 1)));
    }

    private void clearLabelBorder(Label lab) {
        lab.setBorder(null);
    }

    private void buildFigures() {
        Figure mainFigure = new Figure();
        this.lws.setContents((IFigure)mainFigure);
        ToolbarLayout mainToolBar = new ToolbarLayout();
        mainToolBar.setMinorAlignment(0);
        mainToolBar.setSpacing(4);
        mainFigure.setLayoutManager((LayoutManager)mainToolBar);
        Figure contents = new Figure();
        contents.setLayoutManager((LayoutManager)new StackLayout());
        Figure relationshipLayer = new Figure();
        ToolbarLayout relationLayout = new ToolbarLayout();
        relationLayout.setMinorAlignment(0);
        relationLayout.setStretchMinorAxis(false);
        relationshipLayer.setMinimumSize(new Dimension(500, 10));
        relationshipLayer.setLayoutManager((LayoutManager)relationLayout);
        relationshipLayer.add((IFigure)this.relationshipName);
        mainFigure.add((IFigure)relationshipLayer);
        Figure firstClassLayer = new Figure();
        ToolbarLayout tb1 = new ToolbarLayout();
        tb1.setMinorAlignment(1);
        tb1.setStretchMinorAxis(false);
        firstClassLayer.setLayoutManager((LayoutManager)tb1);
        firstClassLayer.add((IFigure)this.beanA);
        contents.add((IFigure)firstClassLayer);
        Figure secondClassLayer = new Figure();
        ToolbarLayout tb2 = new ToolbarLayout();
        tb2.setMinorAlignment(2);
        tb2.setStretchMinorAxis(false);
        secondClassLayer.setLayoutManager((LayoutManager)tb2);
        secondClassLayer.add((IFigure)this.beanB);
        contents.add((IFigure)secondClassLayer);
        mainFigure.setBorder((Border)new MarginBorder(new Insets(1)));
        this.setupClass(this.beanA);
        this.setupClass(this.beanB);
        this.setupLabelBorder(this.relationshipName);
        this.connection.setSourceAnchor((ConnectionAnchor)new ClassConnectionAnchor((IFigure)this.beanA));
        this.connection.setTargetAnchor((ConnectionAnchor)new ClassConnectionAnchor((IFigure)this.beanB));
        ConnectionEndpointLocator c1 = new ConnectionEndpointLocator((Connection)this.connection, false);
        ConnectionEndpointLocator c2 = new ConnectionEndpointLocator((Connection)this.connection, true);
        ConnectionEndpointLocator c3 = new ConnectionEndpointLocator((Connection)this.connection, false);
        ConnectionEndpointLocator c4 = new ConnectionEndpointLocator((Connection)this.connection, true);
        c1.setVDistance(4);
        c1.setUDistance(10);
        c2.setVDistance(4);
        c2.setUDistance(10);
        c3.setVDistance(-3);
        c3.setUDistance(10);
        c4.setVDistance(-3);
        c4.setUDistance(10);
        this.connection.add((IFigure)this.roleAName, (Object)c1);
        this.connection.add((IFigure)this.roleBName, (Object)c2);
        this.connection.add((IFigure)this.roleAMultiplicity, (Object)c3);
        this.connection.add((IFigure)this.roleBMultiplicity, (Object)c4);
        Figure connectionLayer = new Figure();
        connectionLayer.setPreferredSize(1, 1);
        connectionLayer.add((IFigure)this.connection);
        contents.add((IFigure)connectionLayer);
        mainFigure.add((IFigure)contents);
    }

    public void setRoleANavigable(boolean value) {
        if (value) {
            this.connection.setSourceDecoration((RotatableDecoration)new PolylineDecoration());
        } else {
            this.connection.setSourceDecoration(null);
        }
    }

    public void setRoleBNavigable(boolean value) {
        if (value) {
            this.connection.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        } else {
            this.connection.setTargetDecoration(null);
        }
    }

    public void setRoleAName(String name) {
        int sx = this.connection.getEnd().x - this.connection.getStart().x;
        int width = (sx - 20) / 2 - 8;
        int i = this.getLargestSubstringConfinedTo(name, this.roleAName.getFont(), width);
        if (i < name.length()) {
            name = name.substring(0, i - 2);
            name = String.valueOf(name) + CommonAppEJBWizardsResourceHandler.Ellipsis_UI_;
        }
        this.roleAName.setText(name);
        if (this.roleAName.getBorder() != null && name.equals("")) {
            this.clearLabelBorder(this.roleAName);
        } else if (this.roleAName.getBorder() == null && !name.equals("")) {
            if (this.changeColorSecond) {
                this.highLightBorder(this.roleAName);
            } else {
                this.setupLabelBorder(this.roleAName);
            }
        }
    }

    public void setRoleBName(String name) {
        int sx = this.connection.getEnd().x - this.connection.getStart().x;
        int width = (sx - 20) / 2 - 8;
        int i = this.getLargestSubstringConfinedTo(name, this.roleBName.getFont(), width);
        if (i < name.length()) {
            name = name.substring(0, i - 2);
            name = String.valueOf(name) + CommonAppEJBWizardsResourceHandler.Ellipsis_UI_;
        }
        this.roleBName.setText(name);
        if (this.roleBName.getBorder() != null && name.equals("")) {
            this.clearLabelBorder(this.roleBName);
        } else if (this.roleBName.getBorder() == null && !name.equals("")) {
            if (this.changeColorFirst) {
                this.highLightBorder(this.roleBName);
            } else {
                this.setupLabelBorder(this.roleBName);
            }
        }
    }

    public void setRoleAMultiplicity(String name) {
        if (this.roleAMultiplicity.getBorder() != null && name.equals("")) {
            this.clearLabelBorder(this.roleAMultiplicity);
        } else if (this.roleAMultiplicity.getBorder() == null && !name.equals("")) {
            this.setupLabelBorder(this.roleAMultiplicity);
        }
        this.roleAMultiplicity.setText(name);
    }

    public void setRoleBMultiplicity(String name) {
        if (this.roleBMultiplicity.getBorder() != null && name.equals("")) {
            this.clearLabelBorder(this.roleBMultiplicity);
        } else if (this.roleBMultiplicity.getBorder() == null && !name.equals("")) {
            this.setupLabelBorder(this.roleBMultiplicity);
        }
        this.roleBMultiplicity.setText(name);
    }

    public void setRelationshipName(String name) {
        this.relationshipName.setText(name);
    }

    public void setBeanAName(String name) {
        this.beanA.setTitle(name);
    }

    public void setBeanBName(String name) {
        this.beanB.setTitle(name);
    }

    public void focusRoleAArea(boolean w) {
        if (w) {
            this.changeColorFirst = true;
            this.beanA.setBorder((Border)new DropShadowBorder(this.highLightedColor));
            if (!this.roleBName.getText().equals("")) {
                this.highLightBorder(this.roleBName);
            }
            if (this.ejb20Setup) {
                this.highLightBorder(this.roleAMultiplicity);
            } else {
                this.highLightBorder(this.roleBMultiplicity);
            }
        } else {
            this.changeColorFirst = false;
            this.beanA.setBorder((Border)new DropShadowBorder());
            if (!this.roleBName.getText().equals("")) {
                this.setupLabelBorder(this.roleBName);
            }
            if (this.ejb20Setup) {
                this.setupLabelBorder(this.roleAMultiplicity);
            } else {
                this.setupLabelBorder(this.roleBMultiplicity);
            }
        }
        this.roleBMultiplicity.repaint();
        this.roleBName.repaint();
        this.beanA.repaint();
    }

    public void focusRoleBArea(boolean w) {
        if (w) {
            this.changeColorSecond = true;
            this.beanB.setBorder((Border)new DropShadowBorder(this.highLightedColor));
            if (!this.roleAName.getText().equals("")) {
                this.highLightBorder(this.roleAName);
            }
            if (this.ejb20Setup) {
                this.highLightBorder(this.roleBMultiplicity);
            } else {
                this.highLightBorder(this.roleAMultiplicity);
            }
        } else {
            this.changeColorSecond = false;
            this.beanB.setBorder((Border)new DropShadowBorder());
            if (!this.roleAName.getText().equals("")) {
                this.setupLabelBorder(this.roleAName);
            }
            if (this.ejb20Setup) {
                this.setupLabelBorder(this.roleBMultiplicity);
            } else {
                this.setupLabelBorder(this.roleAMultiplicity);
            }
        }
        this.roleAName.repaint();
        this.roleAMultiplicity.repaint();
        this.beanB.repaint();
    }

    protected int getLargestSubstringConfinedTo(String s, Font f, int availableWidth) {
        FontMetrics metrics = FigureUtilities.getFontMetrics((Font)f);
        float avg = metrics.getAverageCharWidth();
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = FigureUtilities.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f).width) < availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }
}

