/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.wizards;

import com.ibm.etools.common.ui.nls.CommonAppEJBResourceHandler;
import com.ibm.etools.common.ui.wizards.GenericCommandWizard;
import com.ibm.etools.common.ui.wizards.PageBasedCommandWizardPage;
import com.ibm.etools.common.ui.wizards.nls.CommonAppEJBWizardsResourceHandler;
import com.ibm.etools.ejb.codegen.EJBGenHelpers;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.ejb.ui.operations.CreateOrUpdateEJBQueryOperation;
import com.ibm.etools.ejb.ui.wizards.helpers.EJBFindersWizardEditModel;
import com.ibm.etools.ejb.ui.wizards.helpers.SampleQueryGenerator;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Query;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class EJBFinders20WizardPageTwo
extends PageBasedCommandWizardPage {
    private static final Integer QUERY_STATEMENT_KEY = new Integer(0);
    protected Object[] sampleValues = null;
    protected Object[] sampleLabels = null;
    protected Composite composite;
    Text beanValue;
    Text asnValue;
    Text methodValue;
    Text descriptionValue;
    Text statementValue;
    Combo sampleSelection = null;
    EJBFindersWizardEditModel model;
    AdapterFactoryEditingDomain editingDomain;
    EnterpriseBean myBean;
    Query myQuery;

    public EJBFinders20WizardPageTwo(String pageName) {
        super(pageName);
        this.setImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("ejbql_wiz"));
        this.setTitle(CommonAppEJBWizardsResourceHandler.EJBQL_Query_UI_);
        this.setDescription(CommonAppEJBWizardsResourceHandler.Create_a_new_Query_);
    }

    @Override
    protected Composite createTopLevelComposite(Composite parent) {
        this.loadData();
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.etools.j2ee.ui.EJB_QUERY_PAGE2");
        Label bean = new Label(this.composite, 0);
        bean.setText(CommonAppEJBWizardsResourceHandler.Bean__UI_);
        this.beanValue = new Text(this.composite, 2056);
        this.beanValue.setLayoutData((Object)new GridData(768));
        Label asn = new Label(this.composite, 0);
        asn.setText(CommonAppEJBWizardsResourceHandler.abstract_schema_name_);
        this.asnValue = new Text(this.composite, 2056);
        this.asnValue.setLayoutData((Object)new GridData(768));
        Label method = new Label(this.composite, 0);
        method.setText(CommonAppEJBWizardsResourceHandler.Query_method_name___UI_);
        this.methodValue = new Text(this.composite, 2056);
        this.methodValue.setLayoutData((Object)new GridData(768));
        Label description = new Label(this.composite, 0);
        description.setText(CommonAppEJBResourceHandler.Description__UI_);
        description.setLayoutData((Object)new GridData(2));
        this.descriptionValue = new Text(this.composite, 2626);
        GridData data = new GridData(768);
        data.heightHint = 40;
        this.descriptionValue.setLayoutData((Object)data);
        Label selectionLabel = new Label(this.composite, 16384);
        selectionLabel.setText(CommonAppEJBWizardsResourceHandler.select_sample_query_);
        data = new GridData();
        data.horizontalAlignment = 4;
        selectionLabel.setLayoutData((Object)data);
        this.sampleSelection = new Combo(this.composite, 2060);
        this.sampleSelection.setLayoutData((Object)new GridData(768));
        this.getSamples();
        String[] holder = new String[this.sampleLabels.length];
        int i = 0;
        while (i < this.sampleLabels.length) {
            holder[i] = this.sampleLabels[i].toString();
            ++i;
        }
        this.sampleSelection.setItems(holder);
        data = new GridData(272);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 200;
        this.sampleSelection.setLayoutData((Object)data);
        Label statement = new Label(this.composite, 0);
        statement.setLayoutData((Object)new GridData(2));
        statement.setText(CommonAppEJBWizardsResourceHandler.Query_statement__UI_);
        data = new GridData(768);
        data.horizontalSpan = 2;
        statement.setLayoutData((Object)data);
        this.statementValue = new Text(this.composite, 2626);
        data = new GridData(768);
        data.heightHint = 100;
        data.horizontalSpan = 2;
        this.statementValue.setLayoutData((Object)data);
        if (this.model.getQuery() != null) {
            this.setDescription(CommonAppEJBWizardsResourceHandler.Edit_the_selected_Query_);
            if (this.myQuery.getEjbQL() != null) {
                this.statementValue.setText(this.myQuery.getEjbQL());
            }
            if (this.myQuery.getDescription() != null) {
                this.descriptionValue.setText(this.myQuery.getDescription());
            }
        }
        return this.composite;
    }

    @Override
    protected void enter() {
        if (this.model == null) {
            this.loadData();
        }
        this.beanValue.setText(this.model.getEnterpriseBean().getName());
        this.asnValue.setText(this.model.getEnterpriseBean().getName());
        this.methodValue.setText(this.model.getMethodElement().getSignature());
        if (this.model.getQuery() != null) {
            this.myQuery = this.model.getQuery();
        }
        super.enter();
    }

    public void getSamples() {
        SampleQueryGenerator sampleQ = new SampleQueryGenerator((ContainerManagedEntity)this.model.getEnterpriseBean());
        List sampleStatements = sampleQ.basicQueries();
        List sampleL = sampleQ.queryLabels();
        this.sampleValues = sampleStatements.toArray();
        this.sampleLabels = sampleL.toArray();
    }

    @Override
    protected void validateControls() {
        this.setOKStatus(QUERY_STATEMENT_KEY);
        String statement = this.statementValue.getText().trim();
        if (statement.length() == 0) {
            this.setErrorStatus(QUERY_STATEMENT_KEY, EJBUIResourceHandler.FINDER20_QUERY_STATEMENT_EMPTY_ERROR_UI);
        }
    }

    @Override
    public void performFinish() {
        boolean editing = false;
        if (this.model.getQuery() != null) {
            editing = true;
        }
        if (this.validateEditCheck()) {
            CreateOrUpdateEJBQueryOperation op = new CreateOrUpdateEJBQueryOperation(this.model, this.model.getProject(), this.composite.getShell());
            op.setStatement(this.statementValue.getText().trim());
            op.setDescription(this.descriptionValue.getText().trim());
            op.setIsEditing(editing);
            this.executeOperation((IHeadlessRunnableWithProgress)op);
        }
    }

    private void executeOperation(IHeadlessRunnableWithProgress op) {
        try {
            op.run(null);
        }
        catch (InterruptedException e) {
            J2EEUIPlugin.logError(e);
            throw new RuntimeException(e.toString());
        }
        catch (InvocationTargetException e) {
            J2EEUIPlugin.logError(e);
            throw new RuntimeException(e.toString());
        }
    }

    private boolean validateEditCheck() {
        if (this.myBean != null) {
            if (this.model.isEjbSelectMethod()) {
                return this.validateEditCheck(new JavaClass[]{this.myBean.getEjbClass()});
            }
            if (this.model.isLocal()) {
                return this.validateEditCheck(new JavaClass[]{this.myBean.getLocalHomeInterface()});
            }
            if (this.model.isRemote()) {
                return this.validateEditCheck(new JavaClass[]{this.myBean.getRemoteInterface()});
            }
        }
        return true;
    }

    private boolean validateEditCheck(JavaClass[] javaClasses) {
        IFile[] files = this.getReadOnlyFiles(javaClasses);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)this.getShell());
        return status.isOK();
    }

    private IFile[] getReadOnlyFiles(JavaClass[] javaClasses) {
        ArrayList<IResource> files = new ArrayList<IResource>(javaClasses.length);
        int i = 0;
        while (i < javaClasses.length) {
            IResource res;
            ICompilationUnit cu = EJBGenHelpers.getCompilationUnit((JavaClass)javaClasses[i]);
            if (cu != null && (res = cu.getResource()) != null && res.exists() && res.getType() == 1 && res.isReadOnly()) {
                files.add(res);
            }
            ++i;
        }
        IFile[] result = new IFile[files.size()];
        files.toArray(result);
        return result;
    }

    protected void loadData() {
        if (this.getWizard() instanceof GenericCommandWizard) {
            GenericCommandWizard wizard = (GenericCommandWizard)this.getWizard();
            this.model = (EJBFindersWizardEditModel)wizard.getWizardEditModel();
            this.editingDomain = (AdapterFactoryEditingDomain)this.model.getEditingDomain();
            this.myBean = this.model.getEnterpriseBean();
            if (this.model.getQuery() != null) {
                this.myQuery = this.model.getQuery();
            }
        }
    }

    @Override
    protected void addListeners() {
        this.statementValue.addListener(2, (Listener)this);
        if (this.sampleSelection != null) {
            this.sampleSelection.addListener(13, (Listener)this);
        }
    }

    @Override
    public void handleEvent(Event event) {
        if (this.sampleSelection != null && event.widget == this.sampleSelection) {
            SampleQueryGenerator.Association newAssoc = (SampleQueryGenerator.Association)this.sampleValues[this.sampleSelection.getSelectionIndex()];
            this.statementValue.setText(newAssoc.getKey().toString());
        }
        super.handleEvent(event);
    }

    public boolean isPageComplete() {
        boolean primComplete = super.isPageComplete();
        if (primComplete) {
            return this.model.isEditing() || this.isCurrentPage();
        }
        return primComplete;
    }

    public boolean isEJBQueryStatement() {
        if (this.model.getQuery() == null) {
            return false;
        }
        QueryMethod myQuery = this.model.getQuery().getQueryMethod();
        String curQuery = myQuery.getName();
        return curQuery.charAt(0) == 'e';
    }

    public void setupForCheatSheet() {
        this.statementValue.setText("select object(o) from CmpBean o");
        this.descriptionValue.setText("Description should go here");
        this.validateControls();
        this.validatePage();
    }
}

