/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.java.actions;

import com.ibm.etools.ejb.ui.java.actions.PromoteToInterfaceOperation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jem.internal.adapters.jdom.JDOMSearchHelper;
import org.eclipse.jem.java.JavaClass;

public class PromoteToHomeOperation
extends PromoteToInterfaceOperation {
    private static final String ENUM_RETURN_TYPE = "java.util.Enumeration";
    private static final String COL_RETURN_TYPE = "java.util.Collection";
    protected JavaClass remoteInterface;

    protected PromoteToHomeOperation(IMethod[] someClassMethods, JavaClass anInterface, JavaClass aRemoteInterface, boolean isLocalType) {
        super(someClassMethods, anInterface, isLocalType);
        this.setRemoteInterface(aRemoteInterface);
    }

    @Override
    protected String getInterfaceMethodName(IMethod beanMethod) {
        return this.getHomeInterfaceMethodName(beanMethod);
    }

    protected JavaClass getRemoteInterface() {
        return this.remoteInterface;
    }

    protected boolean isSingleFinder(String aTypeName) {
        if (aTypeName == null) {
            return false;
        }
        return !aTypeName.equals(ENUM_RETURN_TYPE) && !aTypeName.equals(COL_RETURN_TYPE);
    }

    protected String getReturnType(IMethod beanMethod) {
        if (beanMethod.getElementName().startsWith("ejbHome")) {
            return null;
        }
        String qualifiedName = null;
        try {
            String returnType = beanMethod.getReturnType();
            returnType = Signature.getTypeErasure((String)returnType);
            returnType = Signature.toString((String)returnType);
            qualifiedName = JDOMSearchHelper.resolveSimpleTypeName((IType)beanMethod.getDeclaringType(), (String)returnType);
        }
        catch (JavaModelException javaModelException) {}
        if (this.isSingleFinder(qualifiedName)) {
            return this.getRemoteInterface().getQualifiedName();
        }
        return null;
    }

    private Type getUpdatedReturnType(AST ast, IMethod beanMethod) {
        String qualifiedName = this.getReturnType(beanMethod);
        if (qualifiedName != null) {
            String simpleName = Signature.getSimpleName((String)qualifiedName);
            String qualifier = Signature.getQualifier((String)qualifiedName);
            QualifiedName qName = ast.newQualifiedName(ast.newName(qualifier), ast.newSimpleName(simpleName));
            return ast.newSimpleType((Name)qName);
        }
        return null;
    }

    protected boolean isFindMethod(IMethod beanMethod) {
        String methodName = beanMethod.getElementName();
        return methodName.startsWith("ejbFind");
    }

    @Override
    protected void modifyForInterface(MethodDeclaration newMethod, IMethod beanMethod) {
        super.modifyForInterface(newMethod, beanMethod);
        boolean isBMPFind = this.isFindMethod(beanMethod);
        newMethod.getName().setIdentifier(this.getInterfaceMethodName(beanMethod));
        Type updatedReturnType = this.getUpdatedReturnType(newMethod.getAST(), beanMethod);
        if (updatedReturnType != null) {
            newMethod.setReturnType2(updatedReturnType);
        }
        if (isBMPFind) {
            this.addException(newMethod, "javax.ejb.FinderException");
        } else if (beanMethod.getElementName().startsWith("ejbCreate")) {
            this.addException(newMethod, "javax.ejb.CreateException");
        }
        if (!this.isLocal) {
            this.addException(newMethod, "java.rmi.RemoteException");
        }
    }

    protected void setRemoteInterface(JavaClass newRemoteInterface) {
        this.remoteInterface = newRemoteInterface;
    }
}

