/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.java;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ImageOverlayIcon
extends CompositeImageDescriptor {
    static final int DEFAULT_SINGLE_WIDTH = 22;
    static final int DEFAULT_DOUBLE_WIDTH = 29;
    static final int DEFAULT_HEIGHT = 16;
    private Point fSingleSize;
    private Point fDoubleSize;
    private ImageDescriptor[] fOverlays;
    private Image base;

    public ImageOverlayIcon(Image base, ImageDescriptor[] overlays) {
        this.fOverlays = overlays;
        this.base = base;
        this.fSingleSize = new Point(22, 16);
        this.fDoubleSize = new Point(29, 16);
    }

    protected ImageData getBaseImageData() {
        return this.base.getImageData();
    }

    protected void drawInterfaceOverlay() {
        int x = this.getSize().x;
        if (this.fOverlays != null) {
            int length = this.fOverlays.length;
            int i = 2;
            while (i >= 0) {
                if (i < length && this.fOverlays[i] != null) {
                    ImageData id = this.fOverlays[i].getImageData();
                    this.drawImage(id, x -= id.width, this.getSize().y - id.height);
                }
                --i;
            }
        }
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData aBase = this.getBaseImageData();
        this.drawImage(aBase, 0, 0);
        this.drawInterfaceOverlay();
    }

    protected Point getSize() {
        if (this.fOverlays.length > 1) {
            return this.fDoubleSize;
        }
        return this.fSingleSize;
    }
}

