/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.insertions.wizards;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.ui.wizards.ResourceReferenceWizard;
import com.ibm.etools.common.ui.wizards.ResourceReferenceWizardPage;
import com.ibm.etools.ejb.ui.insertions.wizards.MDBResourceReferenceSelectionModel;
import com.ibm.etools.ejb.ui.insertions.wizards.ReferenceSnippetsHelper;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.emf.workbench.ui.wizard.datamodel.WTPWizardPage;
import com.ibm.etools.j2ee.reference.ResourceReferenceDataModel;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;

public class MDB20QueueConnectionResourceRefSelectionPage
extends WTPWizardPage {
    protected static final Object[] EMPTY_ELEMENTS = new Object[0];
    protected TableViewer resRefViewer;
    protected Button newButton;
    private DynamicAdapterFactory adapterFactory;
    private Label ownerLabel;
    private AdapterFactoryLabelProvider labelProvider;
    private Label ownerImage;

    public MDB20QueueConnectionResourceRefSelectionPage(String pageName, String title, MDBResourceReferenceSelectionModel model) {
        super((WTPOperationDataModel)model, pageName, title, J2EEUIPlugin.getDefault().getImageDescriptor("ejb_ref_wiz"));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.verticalSpacing = 10;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(768));
        this.createOwnerControls(main);
        this.createResourceRefView(main);
        this.createNewButton(main);
        this.setMessage(this.getTitleDescription());
        return main;
    }

    protected String getTitleDescription() {
        return EJBUIResourceHandler.SEL_QUEUE_CONNECTION_FACTORY_REF;
    }

    protected void addListeners() {
        this.resRefViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (sel instanceof ResourceRef) {
                    MDB20QueueConnectionResourceRefSelectionPage.this.model.setProperty(MDB20QueueConnectionResourceRefSelectionPage.this.getResRefProperty(), sel);
                }
                MDB20QueueConnectionResourceRefSelectionPage.this.validatePage();
            }
        });
        this.resRefViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!MDB20QueueConnectionResourceRefSelectionPage.this.isPageComplete()) {
                    return;
                }
                if (MDB20QueueConnectionResourceRefSelectionPage.this.model.getProperty(MDB20QueueConnectionResourceRefSelectionPage.this.getResRefProperty()) != null) {
                    IWizardPage nextPage = MDB20QueueConnectionResourceRefSelectionPage.this.getNextPage();
                    MDB20QueueConnectionResourceRefSelectionPage.this.getContainer().showPage(nextPage);
                }
            }
        });
        this.newButton.addListener(13, (Listener)this);
    }

    protected String getResRefProperty() {
        return "EJBReferenceSelectionModel.queueConnectionFactoryResRef";
    }

    private void createResourceRefView(Composite main) {
        this.resRefViewer = new TableViewer(main, 2564);
        Table table = this.resRefViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        table.setLayoutData((Object)gd);
        this.createTableContentProvider();
        this.adapterFactory = new DynamicAdapterFactory(null);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        this.resRefViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    protected void createTableContentProvider() {
        this.resRefViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return MDB20QueueConnectionResourceRefSelectionPage.this.getResRefs(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    protected Object[] getResRefs(Object inputElement) {
        if (inputElement instanceof EnterpriseBean) {
            return this.getQueueConnectionFactoyRefs((EnterpriseBean)inputElement);
        }
        if (inputElement instanceof WebApp) {
            return this.getQueueConnectionFactoyRefs((WebApp)inputElement);
        }
        if (inputElement instanceof ApplicationClient) {
            return this.getQueueConnectionFactoyRefs((ApplicationClient)inputElement);
        }
        return EMPTY_ELEMENTS;
    }

    protected Object[] getQueueConnectionFactoyRefs(ApplicationClient client) {
        EList resRefs = client.getResourceRefs();
        return this.getResourceRefs((List)resRefs);
    }

    protected Object[] getResourceRefs(List resRefs) {
        return this.getQueueConnectionRefs(resRefs);
    }

    protected Object[] getQueueConnectionRefs(List resRefs) {
        ArrayList<ResourceRef> queueConResRefs = new ArrayList<ResourceRef>();
        int i = 0;
        while (i < resRefs.size()) {
            ResourceRef ref = (ResourceRef)resRefs.get(i);
            if (ref.getType().equals("javax.jms.QueueConnectionFactory")) {
                queueConResRefs.add(ref);
            }
            ++i;
        }
        return queueConResRefs.toArray();
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"J2EEReferenceSnippetDataModel.selectedReference"};
    }

    protected Object[] getQueueConnectionFactoyRefs(WebApp app) {
        EList resRefs = app.getResourceRefs();
        return this.getResourceRefs((List)resRefs);
    }

    protected Object[] getQueueConnectionFactoyRefs(EnterpriseBean ejb) {
        EList resRefs = ejb.getResourceRefs();
        return this.getResourceRefs((List)resRefs);
    }

    protected void createOwnerControls(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(768));
        Label label = new Label(main, 0);
        label.setText(this.getOwnerLabelString());
        this.ownerImage = new Label(main, 0);
        this.ownerLabel = new Label(main, 0);
        this.ownerLabel.setLayoutData((Object)new GridData(512));
    }

    protected String getOwnerLabelString() {
        return EJBUIResourceHandler.MDB_QUEUE_CONN_REF_OWNER_LBL;
    }

    protected void createNewButton(Composite main) {
        this.newButton = new Button(main, SWT.BUTTON_MASK);
        GridData gd = new GridData(2);
        this.newButton.setLayoutData((Object)gd);
        this.newButton.setText(this.getNewButtonString());
        this.newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MDB20QueueConnectionResourceRefSelectionPage.this.handleNewButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected String getNewButtonString() {
        return EJBUIResourceHandler.NEW_QUEUE_CON_RESREF;
    }

    protected void handleNewButtonPressed() {
        Object owner = this.model.getProperty("J2EEReferenceSnippetDataModel.owner");
        Object[] refs = this.getResRefs(owner);
        IWizard wizard = this.createNewEJBReferenceWizard(owner);
        if (wizard != null) {
            WizardDialog dialog = new WizardDialog(this.getShell(), wizard);
            dialog.create();
            this.setDefaultRefType(wizard);
            dialog.getShell().setSize(400, 500);
            int result = dialog.open();
            if (result == 0) {
                this.resRefViewer.refresh();
                Object[] newRefs = this.getResRefs(owner);
                Object newSel = ReferenceSnippetsHelper.getNewObject(refs, newRefs);
                if (newSel != null) {
                    StructuredSelection selection = new StructuredSelection(newSel);
                    this.resRefViewer.setSelection((ISelection)selection, true);
                }
            }
        }
    }

    protected void setDefaultRefType(IWizard wizard) {
        String defaultRefType = this.getDefaultRefType();
        ResourceReferenceWizardPage page = (ResourceReferenceWizardPage)wizard.getPage("pageOne");
        Combo combo = page.getTypeValue();
        int index = this.getRefTypeIndex(combo, defaultRefType);
        if (index != -1) {
            combo.select(index);
            combo.setEnabled(false);
        } else {
            combo.setEnabled(true);
        }
    }

    protected String getDefaultRefType() {
        return "javax.jms.QueueConnectionFactory";
    }

    private IWizard createNewEJBReferenceWizard(Object anObject) {
        ResourceReferenceDataModel dataModel = new ResourceReferenceDataModel();
        dataModel.setProperty("ReferenceDataModel.OWNER", anObject);
        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)J2EEProjectUtilities.getProject((Object)anObject).getName());
        return new ResourceReferenceWizard(dataModel);
    }

    private int getRefTypeIndex(Combo combo, String type) {
        String[] comboItems = combo.getItems();
        int i = 0;
        while (i < comboItems.length) {
            if (comboItems[i].equals(type)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void enter() {
        Object owner = this.model.getProperty("J2EEReferenceSnippetDataModel.owner");
        this.resRefViewer.setInput(owner);
        if (this.labelProvider != null) {
            this.ownerImage.setImage(this.labelProvider.getImage(owner));
            this.ownerLabel.setText(this.labelProvider.getText(owner));
            this.ownerImage.setSize(this.ownerImage.computeSize(-1, -1));
            this.ownerLabel.setVisible(true);
            this.ownerLabel.setSize(this.ownerLabel.computeSize(-1, -1));
        }
        super.enter();
    }
}

