/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.insertions.wizards;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.common.ui.wizards.EJBReferenceWizard;
import com.ibm.etools.ejb.ui.insertions.wizards.EJBReferenceSelectionModel;
import com.ibm.etools.ejb.ui.nls.EJBUIResourceHandler;
import com.ibm.etools.emf.workbench.ui.wizard.datamodel.WTPWizardPage;
import com.ibm.etools.j2ee.reference.EJBReferenceDataModel;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.frameworks.internal.ui.ClosableWizardDialog;
import org.eclipse.wst.common.internal.emfworkbench.integration.DynamicAdapterFactory;

public class EJBReferenceSelectionPage
extends WTPWizardPage {
    protected static final Object[] EMPTY_ELEMENTS = new Object[0];
    protected TableViewer ejbRefViewer;
    protected Button newButton;
    private DynamicAdapterFactory adapterFactory;
    private Label ownerLabel;
    private AdapterFactoryLabelProvider labelProvider;
    private Label ownerImage;

    public EJBReferenceSelectionPage(String pageName, String title, EJBReferenceSelectionModel model) {
        super((WTPOperationDataModel)model, pageName, title, J2EEUIPlugin.getDefault().getImageDescriptor("ejb_ref_wiz"));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainLayout.verticalSpacing = 10;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(768));
        this.createOwnerControls(main);
        this.createEJBRefView(main);
        this.createNewButton(main);
        this.setMessage(EJBUIResourceHandler.SEL_EJB_REF);
        return main;
    }

    private void createOwnerControls(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        main.setLayout((Layout)mainLayout);
        main.setLayoutData((Object)new GridData(768));
        Label label = new Label(main, 0);
        label.setText(EJBUIResourceHandler.EJBREF_OWNER_LBL);
        this.ownerImage = new Label(main, 0);
        this.ownerLabel = new Label(main, 0);
        this.ownerLabel.setLayoutData((Object)new GridData(512));
    }

    private void createNewButton(Composite main) {
        this.newButton = new Button(main, SWT.BUTTON_MASK);
        GridData gd = new GridData(2);
        this.newButton.setLayoutData((Object)gd);
        this.newButton.setText(EJBUIResourceHandler.NEW_EJBREF);
        this.newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EJBReferenceSelectionPage.this.handleNewButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createEJBRefView(Composite parent) {
        this.ejbRefViewer = new TableViewer(parent, 2564);
        Table table = this.ejbRefViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        table.setLayoutData((Object)gd);
        this.createTableContentProvider();
        this.adapterFactory = new DynamicAdapterFactory(null);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        this.ejbRefViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.createToolTipHelper();
    }

    private void createToolTipHelper() {
        this.ejbRefViewer.getControl().addListener(32, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 32) {
                    TableItem item = EJBReferenceSelectionPage.this.ejbRefViewer.getTable().getItem(new Point(event.x, event.y));
                    if (item != null && item.getData() != null && item.getData() instanceof EjbRef) {
                        if (EJBReferenceSelectionPage.this.model.getBooleanProperty("EJBReferenceSelectionModel.useHome")) {
                            EJBReferenceSelectionPage.this.ejbRefViewer.getControl().setToolTipText("Interface: " + ((EjbRef)item.getData()).getHome());
                        } else {
                            EJBReferenceSelectionPage.this.ejbRefViewer.getControl().setToolTipText("Interface: " + ((EjbRef)item.getData()).getRemote());
                        }
                    } else {
                        EJBReferenceSelectionPage.this.ejbRefViewer.getControl().setToolTipText(null);
                    }
                }
            }
        });
    }

    protected void createTableContentProvider() {
        this.ejbRefViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return EJBReferenceSelectionPage.this.getEJBRefs(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
    }

    protected Object[] getEJBRefs(Object inputElement) {
        if (inputElement instanceof EnterpriseBean) {
            return this.getEJBRefs((EnterpriseBean)inputElement);
        }
        if (inputElement instanceof WebApp) {
            return this.getEJBRefs((WebApp)inputElement);
        }
        if (inputElement instanceof ApplicationClient) {
            return this.getEJBRefs((ApplicationClient)inputElement);
        }
        return EMPTY_ELEMENTS;
    }

    protected Object[] getEJBRefs(EnterpriseBean ejb) {
        EList refs = ejb.getEjbRefs();
        EList localRefs = ejb.getEjbLocalRefs();
        return this.combineEJBRefs((List)refs, (List)localRefs);
    }

    protected Object[] combineEJBRefs(List refs, List localRefs) {
        ArrayList result;
        if (refs.isEmpty()) {
            result = localRefs;
        } else if (localRefs.isEmpty()) {
            result = refs;
        } else {
            result = new ArrayList();
            result.addAll(localRefs);
            result.addAll(refs);
        }
        return result.toArray();
    }

    protected Object[] getEJBRefs(WebApp web) {
        EList refs = web.getEjbRefs();
        EList localRefs = web.getEjbLocalRefs();
        return this.combineEJBRefs((List)refs, (List)localRefs);
    }

    protected Object[] getEJBRefs(ApplicationClient appClient) {
        return appClient.getEjbReferences().toArray();
    }

    protected void addListeners() {
        this.ejbRefViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (sel instanceof EjbRef) {
                    EJBReferenceSelectionPage.this.model.setProperty("J2EEReferenceSnippetDataModel.selectedReference", sel);
                }
                EJBReferenceSelectionPage.this.validatePage();
            }
        });
        this.ejbRefViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!EJBReferenceSelectionPage.this.isPageComplete()) {
                    return;
                }
                if (EJBReferenceSelectionPage.this.model.getProperty("J2EEReferenceSnippetDataModel.selectedReference") != null) {
                    IWizardPage nextPage = EJBReferenceSelectionPage.this.getNextPage();
                    if (nextPage == null && EJBReferenceSelectionPage.this.getWizard().getContainer() instanceof ClosableWizardDialog) {
                        Method method = (Method)EJBReferenceSelectionPage.this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
                        if (method != null && method.getParameters().isEmpty() && EJBReferenceSelectionPage.this.getWizard().performFinish()) {
                            ((ClosableWizardDialog)EJBReferenceSelectionPage.this.getWizard().getContainer()).finishAndClose();
                        }
                    } else {
                        EJBReferenceSelectionPage.this.getContainer().showPage(nextPage);
                    }
                }
            }
        });
        this.newButton.addListener(13, (Listener)this);
    }

    protected void handleNewButtonPressed() {
        Object owner = this.model.getProperty("J2EEReferenceSnippetDataModel.owner");
        if (!(owner instanceof EObject)) {
            return;
        }
        IProject owningProject = ProjectUtilities.getProject((EObject)((EObject)owner));
        ArtifactEdit edit = null;
        try {
            edit = ArtifactEdit.getArtifactEditForWrite((IProject)owningProject);
            Object[] refs = this.getEJBRefs(owner);
            IWizard wizard = this.createNewEJBReferenceWizard(owner);
            if (wizard != null) {
                WizardDialog dialog = new WizardDialog(this.getShell(), wizard);
                dialog.create();
                dialog.getShell().setSize(400, 500);
                int result = dialog.open();
                if (result == 0) {
                    this.ejbRefViewer.refresh();
                    Object[] newRefs = this.getEJBRefs(owner);
                    Object newSel = this.getNewObject(refs, newRefs);
                    if (newSel != null) {
                        StructuredSelection selection = new StructuredSelection(newSel);
                        this.ejbRefViewer.setSelection((ISelection)selection, true);
                    }
                }
            }
        }
        finally {
            if (edit != null) {
                edit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                edit.dispose();
            }
        }
    }

    private Object getNewObject(Object[] oldObjects, Object[] newObjects) {
        if (oldObjects != null && newObjects != null && oldObjects.length < newObjects.length) {
            int i = 0;
            while (i < newObjects.length) {
                boolean found = false;
                Object object = newObjects[i];
                int j = 0;
                while (j < oldObjects.length) {
                    if (oldObjects[j] == object) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    return object;
                }
                ++i;
            }
        }
        return null;
    }

    private IWizard createNewEJBReferenceWizard(Object anObject) {
        WebApp webApp;
        EJBReferenceDataModel dataModel = new EJBReferenceDataModel();
        dataModel.setProperty("ReferenceDataModel.OWNER", anObject);
        IProject project = (IProject)this.getModel().getProperty("J2EEReferenceSnippetDataModel.project");
        dataModel.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)project.getName());
        if (anObject instanceof EnterpriseBean) {
            EnterpriseBean ejb = (EnterpriseBean)anObject;
            if (ejb.getVersionID() <= 11) {
                dataModel.setProperty("EJBReferenceDataModel.LOCAL_REMOTE_TYPE", (Object)"Remote");
            }
        } else if (anObject instanceof ApplicationClient) {
            dataModel.setProperty("EJBReferenceDataModel.LOCAL_REMOTE_TYPE", (Object)"Remote");
        } else if (anObject instanceof WebApp && (webApp = (WebApp)anObject).getVersionID() <= 22) {
            dataModel.setProperty("EJBReferenceDataModel.LOCAL_REMOTE_TYPE", (Object)"Remote");
        }
        return new EJBReferenceWizard(dataModel);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"J2EEReferenceSnippetDataModel.selectedReference"};
    }

    public void dispose() {
        super.dispose();
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
    }

    protected void enter() {
        Object owner = this.model.getProperty("J2EEReferenceSnippetDataModel.owner");
        this.ejbRefViewer.setInput(owner);
        if (this.labelProvider != null) {
            this.ownerImage.setImage(this.labelProvider.getImage(owner));
            this.ownerLabel.setText(this.labelProvider.getText(owner));
            this.ownerImage.setSize(this.ownerImage.computeSize(-1, -1));
            this.ownerLabel.setVisible(true);
            this.ownerLabel.setSize(this.ownerLabel.computeSize(-1, -1));
        }
        super.enter();
    }
}

