/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.insertions;

import com.ibm.etools.ejb.ui.insertions.UpdateMDBSnippetJARDependenciesOperation;
import com.ibm.etools.ejb.ui.insertions.wizards.MDBResourceReferenceSelectionModel;
import com.ibm.etools.j2ee.internal.java.insertion.JavaInsertionHelper;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class MDBServiceJavaHelperInitializer {
    protected MDBResourceReferenceSelectionModel model;
    protected JavaInsertionHelper helper;
    protected static String PROV_URL_FIELD_TEMPLATE = "private final static String STATIC_PROV_URL = \"{0}\";\n";
    protected static String SERV_TYPE_FIELD_TEMPLATE = "private final static String STATIC_SERV_TYPE = \"{0}\";\n";
    protected static String CONN_REF_NAME_FIELD_TEMPLATE = "private final static String STATIC_CONNECTION_FACTORY_REF_NAME = \"{0}\";\n";
    protected static String QUEUE_REF_NAME_FIELD_TEMPLATE = "private final static String STATIC_QUEUE_REF_NAME = \"{0}\";\n";
    protected static String LOOKUP_CONN_FACT = "QueueConnectionFactory qConnectionFactory = ServiceLocatorManager.lookupQueueConnectionFactory(STATIC_CONNECTION_FACTORY_REF_NAME);\n";
    protected static String LOOKUP_QUEUE = "Queue queue = ServiceLocatorManager.lookupQueue(STATIC_QUEUE_REF_NAME);\n";
    protected static String LOOKUP_CONN_FACTWITH_PROPS_TEMPLATE = "QueueConnectionFactory qConnectionFactory = ServiceLocatorManager.lookupQueueConnectionFactory(STATIC_CONNECTION_FACTORY_REF_NAME, STATIC_PROV_URL, STATIC_SERV_TYPE);\n";
    protected static String LOOKUP_QUEUE_WITH_PROPS_TEMPLATE = "Queue queue = ServiceLocatorManager.lookupQueue(STATIC_QUEUE_REF_NAME, STATIC_PROV_URL, STATIC_SERV_TYPE);\n";
    protected static String BODY = "QueueConnection qConnection = qConnectionFactory.createQueueConnection();\nQueueSession qSession = qConnection.createQueueSession( false, Session.AUTO_ACKNOWLEDGE );\nQueueSender sender = qSession.createSender(queue);\nTextMessage message = qSession.createTextMessage();\r\nmessage.setText(\"Foo Sample Queue message\");\nsender.send(message);\r\nsender.close();\nqSession.close();\r\nqConnection.close();\n}";
    protected static String TRY = "try {\n";
    protected static String CATCH_EXCEPTION = "catch(JMSException jmse){\r\n// TODO Auto-generated catch block\r\njmse.printStackTrace();\n}\r\n}";
    protected static String SEND_QUEUEMETHOD_SIG = "protected void send{0}Message() ";
    protected static String SEND_QUEUEMETHOD_CALL = "send{0}Message(";

    public MDBServiceJavaHelperInitializer() {
    }

    public MDBServiceJavaHelperInitializer(MDBResourceReferenceSelectionModel model, JavaInsertionHelper helper) {
        this.model = model;
        this.helper = helper;
    }

    public JavaInsertionHelper initializeHelper() {
        if (this.helper == null) {
            this.helper = new JavaInsertionHelper();
        }
        ResourceRef connFactoryRef = (ResourceRef)this.model.getProperty("EJBReferenceSelectionModel.queueConnectionFactoryResRef");
        ResourceRef queueRef = (ResourceRef)this.model.getProperty("EJBReferenceSelectionModel.queueNameResRef");
        if (connFactoryRef != null && queueRef != null) {
            this.helper.setInsertionString(this.createInsertionString());
            this.initializeHelperMethods();
            this.initializeHelperImports();
            this.initializeHelperFields();
            this.initializeExtendedOperations();
        }
        return this.helper;
    }

    private void initializeExtendedOperations() {
        UpdateMDBSnippetJARDependenciesOperation op = new UpdateMDBSnippetJARDependenciesOperation(this.model);
        this.helper.addExtendedOperation((IHeadlessRunnableWithProgress)op);
    }

    protected void initializeHelperImports() {
        this.helper.addImport("com.ibm.etools.service.locator.ServiceLocatorManager");
        this.helper.addImport("javax.jms.*");
        this.helper.addImport("javax.naming.*");
    }

    protected void initializeHelperFields() {
        ResourceRef connFactoryRef = (ResourceRef)this.model.getProperty("EJBReferenceSelectionModel.queueConnectionFactoryResRef");
        ResourceRef queueRef = (ResourceRef)this.model.getProperty("EJBReferenceSelectionModel.queueNameResRef");
        this.helper.addFieldFromSourceString(this.formatString(CONN_REF_NAME_FIELD_TEMPLATE, new String[]{connFactoryRef.getName()}));
        this.helper.addFieldFromSourceString(this.formatString(QUEUE_REF_NAME_FIELD_TEMPLATE, new String[]{queueRef.getName()}));
        if (this.model.hasContextProperties()) {
            this.helper.addFieldFromSourceString(this.formatString(PROV_URL_FIELD_TEMPLATE, new String[]{this.model.getStringProperty("J2EEReferenceSnippetDataModel.providerURL")}));
            this.helper.addFieldFromSourceString(this.formatString(SERV_TYPE_FIELD_TEMPLATE, new String[]{this.model.getStringProperty("J2EEReferenceSnippetDataModel.nameServiceType")}));
        }
    }

    protected String createInsertionString() {
        StringBuffer b = new StringBuffer();
        this.addInsertionMethodCall(b);
        b.append(");");
        return b.toString();
    }

    protected void addInsertionMethodCall(StringBuffer b) {
        ResourceRef queueRef = (ResourceRef)this.model.getProperty("EJBReferenceSelectionModel.queueNameResRef");
        String clientName = this.tokenize(queueRef.getName());
        String[] args = new String[]{clientName};
        b.append(this.formatString(SEND_QUEUEMETHOD_CALL, args));
    }

    protected String formatString(String pattern, String[] arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected void initializeHelperMethods() {
        this.addSendMsgToQueueMethod();
    }

    protected void addSendMsgToQueueMethod() {
        StringBuffer b = new StringBuffer();
        this.addToSendMsgToQueueMethod(b);
        this.helper.addMethodFromSourceString(b.toString());
    }

    private String tokenize(String str) {
        StringTokenizer st = new StringTokenizer(str, "/");
        StringBuffer b = new StringBuffer();
        while (st.hasMoreTokens()) {
            b.append("_");
            b.append(st.nextToken());
        }
        return b.toString();
    }

    protected void addToSendMsgToQueueMethod(StringBuffer b) {
        ResourceRef queueRef = (ResourceRef)this.model.getProperty("EJBReferenceSelectionModel.queueNameResRef");
        ResourceRef connFactoryRef = (ResourceRef)this.model.getProperty("EJBReferenceSelectionModel.queueConnectionFactoryResRef");
        String clientName = this.tokenize(queueRef.getName());
        String[] temp = new String[]{clientName};
        b.append(this.formatString(SEND_QUEUEMETHOD_SIG, temp));
        b.append("{\r\n");
        b.append(TRY);
        String connFact = connFactoryRef.getName();
        String[] sigArgs = new String[]{connFact};
        String queueName = queueRef.getName();
        String[] temp2 = new String[]{queueName};
        if (this.model.hasContextProperties()) {
            b.append(this.formatString(LOOKUP_CONN_FACTWITH_PROPS_TEMPLATE, sigArgs));
            b.append(this.formatString(LOOKUP_QUEUE_WITH_PROPS_TEMPLATE, temp2));
        } else {
            b.append(this.formatString(LOOKUP_CONN_FACT, sigArgs));
            b.append(this.formatString(LOOKUP_QUEUE, temp2));
        }
        b.append(BODY);
        b.append(CATCH_EXCEPTION);
    }

    public boolean requiresContextProperties() {
        return true;
    }
}

