/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.gef.widgets;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

public class RelationshipComboCellEditor
implements CellEditorLocator {
    private Label label;
    private static int WIN_X_OFFSET = -4;
    private static int WIN_W_OFFSET = 5;
    private static int GTK_X_OFFSET = 0;
    private static int GTK_W_OFFSET = 0;
    private static int MAC_X_OFFSET = -3;
    private static int MAC_W_OFFSET = 9;
    private static int MAC_Y_OFFSET = -3;
    private static int MAC_H_OFFSET = 6;

    public RelationshipComboCellEditor(Label label) {
        this.setLabel(label);
    }

    public void relocate(CellEditor celleditor) {
        Text text = (Text)celleditor.getControl();
        Rectangle rect = this.label.getClientArea().getCopy();
        this.label.translateToAbsolute((Translatable)rect);
        int xOffset = 0;
        int wOffset = 0;
        int yOffset = 0;
        int hOffset = 0;
        if (SWT.getPlatform().equalsIgnoreCase("gtk")) {
            xOffset = GTK_X_OFFSET;
            wOffset = GTK_W_OFFSET;
        } else if (SWT.getPlatform().equalsIgnoreCase("carbon")) {
            xOffset = MAC_X_OFFSET;
            wOffset = MAC_W_OFFSET;
            yOffset = MAC_Y_OFFSET;
            hOffset = MAC_H_OFFSET;
        } else {
            xOffset = WIN_X_OFFSET;
            wOffset = WIN_W_OFFSET;
        }
        text.setBounds(rect.x + xOffset + 4, rect.y + yOffset, rect.width + wOffset - 3, rect.height + hOffset);
    }

    protected Label getLabel() {
        return this.label;
    }

    protected void setLabel(Label label) {
        this.label = label;
    }
}

