/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.gef.widgets;

import com.ibm.etools.ejb.ui.gef.widgets.DropShadowBorder;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class RelClassFigure
extends Figure
implements HandleBounds {
    protected static final Color COLOR_BACKGROUND = new Color(null, 235, 255, 220);
    public static final Font FONT_TITLE = new Font(null, new FontData("Helvetica", 9, 1));
    private Label title;
    private Figure contentPane;

    public RelClassFigure() {
        this.init();
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    public Rectangle getHandleBounds() {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBounds());
        r.crop(this.getInsets());
        r.expand(1, 1);
        return r;
    }

    private Label getLabel() {
        return this.title;
    }

    protected void init() {
        this.setBorder((Border)new DropShadowBorder());
        this.setOpaque(true);
        this.setBackgroundColor(COLOR_BACKGROUND);
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.title = new Label();
        this.title.setBorder((Border)new TitleBorder());
        this.title.setFont(FONT_TITLE);
        this.contentPane = new Figure();
        this.contentPane.setBackgroundColor(ColorConstants.black);
        this.contentPane.setOpaque(true);
        ToolbarLayout tb = new ToolbarLayout();
        tb.setSpacing(1);
        this.contentPane.setLayoutManager((LayoutManager)tb);
        ScrollPane scrollpane = new ScrollPane();
        scrollpane.setContents((IFigure)this.contentPane);
        scrollpane.getViewport().setContentsTracksWidth(true);
        scrollpane.setHorizontalScrollBarVisibility(0);
        scrollpane.setVerticalScrollBarVisibility(0);
        this.add((IFigure)this.title);
        this.add((IFigure)scrollpane);
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBounds());
        r.crop(super.getInsets());
        g.fillRectangle(r);
    }

    public void setIcon(Image image) {
        this.getLabel().setIcon(image);
    }

    public void setTitle(String text) {
        this.getLabel().setText(text);
    }

    static class TitleBorder
    extends AbstractBorder {
        private static final Insets insets = new Insets(1, 2, 3, 2);

        TitleBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return insets;
        }

        public boolean isOpaque() {
            return true;
        }

        public void paint(IFigure f, Graphics g, Insets i) {
            Rectangle r = AbstractBorder.getPaintRectangle((IFigure)f, (Insets)i);
            g.drawLine(r.x, r.bottom() - 1, r.right(), r.bottom() - 1);
        }
    }
}

