/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class PackageContainerSelectionGroup
extends Composite {
    private Listener listener;
    private boolean allowNewContainerName = true;
    private IContainer selectedContainer;
    private Text containerNameField;
    private TreeViewer treeViewer;
    private IContainer rootElement;
    private static final String DEFAULT_MSG_NEW_ALLOWED = IDEWorkbenchMessages.ContainerGroup_message;
    private static final String DEFAULT_MSG_SELECT_ONLY = IDEWorkbenchMessages.ContainerGroup_selectFolder;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 125;
    private static final int SIZING_SELECTION_PANE_WIDTH = 200;

    public PackageContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName) {
        this(parent, listener, allowNewContainerName, null);
    }

    public PackageContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message) {
        super(parent, 0);
        this.listener = listener;
        this.allowNewContainerName = allowNewContainerName;
        this.setFont(parent.getFont());
        if (message != null) {
            this.createContents(message);
        } else if (allowNewContainerName) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY);
        }
    }

    public PackageContainerSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, IContainer rootElement) {
        super(parent, 0);
        this.rootElement = rootElement;
        this.listener = listener;
        this.allowNewContainerName = allowNewContainerName;
        this.setFont(parent.getFont());
        if (message != null) {
            this.createContents(message);
        } else if (allowNewContainerName) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY);
        }
    }

    public void containerSelectionChanged(IContainer container) {
        this.selectedContainer = container;
        if (this.allowNewContainerName) {
            if (container == null) {
                this.containerNameField.setText("");
            } else {
                this.containerNameField.setText(container.getFullPath().makeRelative().toString());
            }
        }
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        if (this.allowNewContainerName) {
            this.containerNameField = new Text((Composite)this, 2052);
            this.containerNameField.setLayoutData((Object)new GridData(768));
            this.containerNameField.addListener(24, this.listener);
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer();
    }

    protected void createTreeViewer() {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 200;
        spec.heightHint = 125;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new ContainerContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PackageContainerSelectionGroup.this.containerSelectionChanged((IContainer)selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (PackageContainerSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        PackageContainerSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        PackageContainerSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)this.rootElement);
    }

    public IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String pathName = this.containerNameField.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        return this.selectedContainer.getFullPath();
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedContainer(IContainer container) {
        this.selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }
}

