/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.ui.decorators;

import com.ibm.etools.ejb.ui.decorators.OverlayIcon;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class J2EEProjectDecorator
extends LabelProvider
implements ILabelDecorator {
    private Hashtable imageCache = new Hashtable();

    public Image decorateImage(Image image, Object element) {
        if (element instanceof IJavaProject) {
            element = ((IJavaProject)element).getProject();
        }
        if (element instanceof IProject) {
            String overlayImageName = "";
            this.findImage(image, overlayImageName);
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    private Image findImage(Image baseImage, String overlayImageName) {
        Object lookupKey = this.getImageKey(baseImage, overlayImageName);
        Image image = (Image)this.imageCache.get(lookupKey);
        if (image == null) {
            ImageDescriptor[] overlays = new ImageDescriptor[]{this.getImageDescriptor(overlayImageName)};
            int[] locations = new int[1];
            DecoratorOverlayIcon imageDescriptor = new DecoratorOverlayIcon(baseImage, overlays, locations);
            image = imageDescriptor.createImage();
            this.imageCache.put(lookupKey, image);
        }
        return image;
    }

    private Object getImageKey(Image baseImage, String overlayImageName) {
        return String.valueOf(baseImage.hashCode()) + overlayImageName;
    }

    private ImageDescriptor getImageDescriptor(String imageFileName) {
        if (imageFileName != null) {
            return J2EEUIPlugin.getDefault().getImageDescriptor(imageFileName);
        }
        return null;
    }

    private static class DecoratorOverlayIcon
    extends OverlayIcon {
        public DecoratorOverlayIcon(Image base, ImageDescriptor[] overlays, int[] locations) {
            super(base, overlays, locations, new Point(base.getBounds().width, base.getBounds().height));
        }

        @Override
        protected void drawOverlays(ImageDescriptor[] overlays, int[] locations) {
            Point size = this.getSize();
            int i = 0;
            while (i < overlays.length) {
                ImageDescriptor overlay = overlays[i];
                if (overlay != null) {
                    ImageData overlayData = overlay.getImageData();
                    switch (locations[i]) {
                        case 0: {
                            this.drawImage(overlayData, 0, 0);
                            break;
                        }
                        case 1: {
                            this.drawImage(overlayData, size.x - overlayData.width, 0);
                            break;
                        }
                        case 2: {
                            this.drawImage(overlayData, 0, size.y - overlayData.height);
                            break;
                        }
                        case 3: {
                            this.drawImage(overlayData, size.x - overlayData.width, size.y - overlayData.height);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

