/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.creation.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModel;

public class ProjectHierarchyScope
implements IJavaSearchScope {
    protected IJavaSearchScope hierarchyScope;
    protected IJavaSearchScope javaSearchScope;
    List subTypes;
    Vector paths;
    List resources;

    public ProjectHierarchyScope(IType aType, IJavaProject javaProject) {
        this.initializeScopes(aType, javaProject);
    }

    protected void initializeScopes(IType aType, IJavaProject aJavaProject) {
        try {
            ITypeHierarchy h = aType.newTypeHierarchy(null);
            IType[] types = h.getAllSubtypes(aType);
            this.subTypes = Arrays.asList(types);
            this.paths = new Vector();
            this.resources = new ArrayList();
            for (IType type : this.subTypes) {
                IPackageFragmentRoot root;
                if (type.getResource() != null && !this.resources.contains(type.getResource())) {
                    this.resources.add(type.getResource());
                }
                if ((root = (IPackageFragmentRoot)type.getPackageFragment().getParent()) instanceof JarPackageFragmentRoot) {
                    String zipFileName;
                    JarPackageFragmentRoot jar = (JarPackageFragmentRoot)root;
                    IPath jarPath = jar.getPath();
                    Object target = JavaModel.getTarget((IPath)jarPath, (boolean)true);
                    if (target instanceof IFile) {
                        zipFileName = jarPath.toString();
                    } else {
                        if (!(target instanceof File)) continue;
                        zipFileName = ((File)target).getPath();
                    }
                    String resourcePath = String.valueOf(zipFileName) + "|" + type.getFullyQualifiedName().replace('.', '/') + ".class";
                    this.paths.add(resourcePath);
                    continue;
                }
                String typePath = type.getPath().toString();
                this.paths.add(typePath);
            }
            this.hierarchyScope = SearchEngine.createHierarchyScope((IType)aType);
        }
        catch (JavaModelException javaModelException) {}
        this.javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{aJavaProject}, (boolean)true);
    }

    public boolean encloses(String resourcePath) {
        int separatorIndex = resourcePath.indexOf("|");
        if (separatorIndex != -1) {
            return this.paths.contains(resourcePath) && this.javaSearchScope.encloses(resourcePath);
        }
        int i = 0;
        while (i < this.paths.size()) {
            if (this.paths.contains(resourcePath)) {
                return this.javaSearchScope.encloses(resourcePath);
            }
            ++i;
        }
        return false;
    }

    public boolean encloses(IJavaElement element) {
        if (this.hierarchyScope == null) {
            return this.javaSearchScope.encloses(element);
        }
        return this.hierarchyScope.encloses(element) && this.javaSearchScope.encloses(element);
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.javaSearchScope.enclosingProjectsAndJars();
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }
}

