/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.clientjarcreation;

import com.ibm.etools.ejb.clientjarcreation.AbstractClientJARAction;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;
import org.eclipse.wst.validation.internal.operations.ValidationOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorSubsetOperation;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;

public class EJBClientRemovalAction
extends AbstractClientJARAction {
    public static String LABEL = J2EEUIPlugin.getDefault().getDescriptor().getResourceString("%ejb.client.jar.remove.action.description_ui_");

    public EJBClientRemovalAction() {
        this.setText(LABEL);
    }

    protected void primRun(Shell shell) {
        if (!this.checkClientExists(shell)) {
            return;
        }
        if (!this.checkBinaryProject(shell)) {
            return;
        }
        if (!this.confirmProceed(shell)) {
            return;
        }
    }

    protected void runValidationOperation(ProgressMonitorDialog dlg) {
        WorkspaceModifyComposedOperation runnable = new WorkspaceModifyComposedOperation();
        ValidatorSubsetOperation sop = new ValidatorSubsetOperation(this.getProject(), true, false);
        sop.setValidators(new String[]{"org.eclipse.jst.j2ee.core.internal.validation.EJBValidator"});
        runnable.addRunnable(ValidationUIPlugin.getRunnableWithProgress((ValidationOperation)sop));
        try {
            dlg.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            J2EEUIPlugin.logError(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean checkClientExists(Shell shell) {
        if (this.getClientProject() == null) {
            MessageDialog.openError((Shell)shell, (String)NO_CLIENT_JAR_TITLE, (String)NO_CLIENT_JAR_MSG);
            return false;
        }
        return true;
    }

    private boolean confirmProceed(Shell shell) {
        String message = MessageFormat.format(REMOVE_MESSAGE, this.getClientProject().getName());
        return MessageDialog.openQuestion((Shell)shell, (String)REMOVE_TITLE, (String)message);
    }

    private IProject getClientProject() {
        return null;
    }

    private boolean checkBinaryProject(Shell shell) {
        if (JemProjectUtilities.isBinaryProject((IProject)this.getProject())) {
            MessageDialog.openError((Shell)shell, (String)REMOVE_ERROR_TITLE, (String)BINARY_EJB_PROJECT);
            return false;
        }
        if (JemProjectUtilities.isBinaryProject((IProject)this.getClientProject())) {
            MessageDialog.openError((Shell)shell, (String)REMOVE_ERROR_TITLE, (String)BINARY_CLIENT_PROJECT);
            return false;
        }
        return true;
    }
}

