/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.ui.wizards.dialogs;

import com.ibm.etools.web.ui.nls.WebUIResourceHandler;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class HierarchySelection
extends TwoPaneElementSelector {
    public static final int TYPES = 0;
    public static final int CLASSES = 1;
    public static final int INTERFACES = 2;
    public static final int IMPLEMENTING_CLASSES = 3;
    public static final int IMPLEMENTING_CLASSES_AND_SUBCLASSES = 4;
    public static final int SUPERTYPES = 5;
    public static final int SUBTYPES = 6;
    public static final int SUPERCLASSES = 7;
    public static final int SUBCLASSES = 8;
    public static final int SUPERINTERFACES = 9;
    public static final int SUB_INTERFACES = 10;
    private boolean fIsEmpty;
    private String fErrorMessage = "";
    private String fHelpCode;

    public HierarchySelection(Shell parent, String typeName, IProject project, int searchStyle) {
        super(parent, (ILabelProvider)new TypeRenderer(), (ILabelProvider)new PackageRenderer());
        Object[] types = null;
        IJavaProject jp = this.getJavaProject(project);
        try {
            IType type = jp.findType(typeName);
            if (type != null) {
                ITypeHierarchy tH = type.newTypeHierarchy(jp, null);
                types = this.getTypes(tH, type, searchStyle);
            }
        }
        catch (JavaModelException javaModelException) {}
        this.fIsEmpty = types == null || types.length < 1;
        this.setElements(types);
        this.setInitialSelections(new Object[]{""});
    }

    public HierarchySelection(Shell parent, String typeName, IProject[] projects, int searchStyle) {
        super(parent, (ILabelProvider)new TypeRenderer(), (ILabelProvider)new PackageRenderer());
        IType[] types = null;
        ArrayList<IType> allTypes = new ArrayList<IType>();
        int i = 0;
        while (i < projects.length) {
            types = null;
            IJavaProject jp = this.getJavaProject(projects[i]);
            try {
                IType type = jp.findType(typeName);
                if (type != null) {
                    ITypeHierarchy tH = type.newTypeHierarchy(jp, null);
                    types = this.getTypes(tH, type, searchStyle);
                    int j = 0;
                    while (j < types.length) {
                        allTypes.add(types[j]);
                        ++j;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        this.fIsEmpty = types == null || types.length < 1;
        this.setElements(allTypes.toArray());
        this.setInitialSelections(new Object[]{""});
    }

    public HierarchySelection(Shell parent, String[] typeNames, IProject project, int searchStyle) {
        super(parent, (ILabelProvider)new TypeRenderer(), (ILabelProvider)new PackageRenderer());
        ArrayList<Object> allTypes = new ArrayList<Object>();
        IJavaProject jp = this.getJavaProject(project);
        Object[] types = null;
        try {
            int i = 0;
            while (i < typeNames.length) {
                ITypeHierarchy tH;
                IType type = jp.findType(typeNames[i]);
                if (type != null && (types = this.getTypes(tH = type.newTypeHierarchy(jp, null), type, searchStyle)) != null) {
                    int j = 0;
                    while (j < types.length) {
                        if (!allTypes.contains(types[j])) {
                            allTypes.add(types[j]);
                        }
                        ++j;
                    }
                    types = null;
                }
                ++i;
            }
            types = allTypes.toArray(new IType[allTypes.size()]);
        }
        catch (JavaModelException javaModelException) {}
        this.fIsEmpty = types == null || types.length < 1;
        this.setElements(types);
        this.setInitialSelections(new Object[]{""});
    }

    public HierarchySelection(Shell parent, IType[] types) {
        super(parent, (ILabelProvider)new TypeRenderer(), (ILabelProvider)new PackageRenderer());
        this.fIsEmpty = types == null || types.length < 1;
        this.setElements(types);
        this.setInitialSelections(new Object[]{""});
    }

    protected void computeResult() {
        IType type;
        Object lowerSelection = this.getLowerSelectedElement();
        IType iType = type = lowerSelection == null ? null : (IType)this.getLowerSelectedElement();
        if (type == null) {
            String title = WebUIResourceHandler.SELECT_CLASS_TITLE;
            String message = WebUIResourceHandler.MAP_CLASS_NAME_TO_CLASS_ERROR_MSG;
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            this.setResult(null);
        } else {
            ArrayList<IType> result = new ArrayList<IType>(1);
            result.add(type);
            this.setResult(result);
        }
    }

    public int open() {
        if (!this.fIsEmpty) {
            return super.open();
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)WebUIResourceHandler.EMPTY_LIST_MSG, (String)this.fErrorMessage);
        return 1;
    }

    public void setHelp(String helpCode) {
        this.fHelpCode = "org.eclipse.jst.j2ee.webapplicationedit." + helpCode;
    }

    private IType[] getTypes(ITypeHierarchy tH, IType type, int searchStyle) {
        IType[] types = null;
        ArrayList<IType> aL = new ArrayList<IType>();
        try {
            int i;
            switch (searchStyle) {
                case 0: {
                    types = tH.getAllTypes();
                    break;
                }
                case 5: {
                    types = tH.getAllSupertypes(type);
                    aL.add(type);
                    break;
                }
                case 6: {
                    types = tH.getAllSubtypes(type);
                    aL.add(type);
                    break;
                }
                case 1: {
                    types = tH.getAllClasses();
                    break;
                }
                case 7: {
                    types = tH.getAllSuperclasses(type);
                    aL.add(type);
                    break;
                }
                case 8: {
                    types = tH.getSubclasses(type);
                    aL.add(type);
                    break;
                }
                case 2: {
                    types = tH.getAllInterfaces();
                    break;
                }
                case 9: {
                    types = tH.getAllSuperInterfaces(type);
                    aL.add(type);
                    break;
                }
                case 3: {
                    types = tH.getImplementingClasses(type);
                    break;
                }
                case 10: {
                    types = tH.getAllSubtypes(type);
                    i = 0;
                    while (i < types.length) {
                        if (types[i].isInterface()) {
                            aL.add(types[i]);
                        }
                        ++i;
                    }
                    types = aL.toArray(new IType[aL.size()]);
                    aL = null;
                    break;
                }
                case 4: {
                    types = tH.getAllSubtypes(type);
                    i = 0;
                    while (i < types.length) {
                        if (types[i].isClass() && !aL.contains(types[i])) {
                            aL.add(types[i]);
                        }
                        ++i;
                    }
                    types = aL.toArray(new IType[aL.size()]);
                    aL = null;
                }
            }
            if (aL != null && aL.size() > 0) {
                if (types != null) {
                    i = 0;
                    while (i < types.length) {
                        aL.add(types[i]);
                        ++i;
                    }
                }
                types = aL.toArray(new IType[aL.size()]);
            }
        }
        catch (JavaModelException javaModelException) {}
        return types;
    }

    private IJavaProject getJavaProject(IProject project) {
        IResource resource;
        IJavaProject jp = null;
        IJavaElement jelem = null;
        IProject proj = null;
        jelem = (IJavaElement)project.getAdapter(IJavaElement.class);
        if (jelem == null && (resource = (IResource)project.getAdapter(IResource.class)) != null && (proj = resource.getProject()) != null) {
            jelem = JavaCore.create((IProject)proj);
        }
        if (jelem != null) {
            jp = jelem.getJavaProject();
        }
        return jp;
    }

    public void setErrorMessage(String message) {
        this.fErrorMessage = message;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.fHelpCode != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(contents, this.fHelpCode);
        }
        return contents;
    }

    private static class PackageRenderer
    extends LabelProvider {
        private final Image PACKAGE_ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.package_obj.gif");

        private PackageRenderer() {
        }

        public String getText(Object element) {
            IType type = (IType)element;
            String p = type.getPackageFragment().getElementName();
            if ("".equals(p)) {
                p = WebUIResourceHandler.DEFAULT_PACKAGE;
            }
            return String.valueOf(p) + " - " + type.getPackageFragment().getParent().getPath().toString();
        }

        public Image getImage(Object element) {
            return this.PACKAGE_ICON;
        }
    }

    private static class TypeRenderer
    extends LabelProvider {
        private final Image CLASS_ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif");
        private final Image INTFC_ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.int_obj.gif");

        private TypeRenderer() {
        }

        public String getText(Object element) {
            return ((IType)element).getElementName();
        }

        public Image getImage(Object element) {
            Image i = null;
            try {
                i = ((IType)element).isClass() ? this.CLASS_ICON : this.INTFC_ICON;
            }
            catch (JavaModelException javaModelException) {}
            return i;
        }
    }
}

