/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.java;

import com.ibm.etools.common.java.DirectoryClasspath;
import com.ibm.etools.common.java.JarClasspath;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class JavaNameEnvironment
implements INameEnvironment {
    Classpath[] classpaths;
    String[] knownFileNames;

    public JavaNameEnvironment(String[] classpathNames, String[] initialFileNames) {
        int classpathSize = classpathNames.length;
        this.classpaths = new Classpath[classpathSize];
        String[] pathNames = new String[classpathSize];
        int problemsOccured = 0;
        int i = 0;
        while (i < classpathSize) {
            try {
                File file = new File(this.convertPathSeparators(classpathNames[i]));
                if (file.exists()) {
                    if (file.isDirectory()) {
                        this.classpaths[i] = new DirectoryClasspath(file);
                        pathNames[i] = ((DirectoryClasspath)this.classpaths[i]).path;
                    } else if (classpathNames[i].endsWith(".jar") | classpathNames[i].endsWith(".zip")) {
                        this.classpaths[i] = new JarClasspath(file);
                        pathNames[i] = classpathNames[i].substring(0, classpathNames[i].lastIndexOf(46));
                    }
                }
            }
            catch (IOException iOException) {
                this.classpaths[i] = null;
            }
            if (this.classpaths[i] == null) {
                ++problemsOccured;
            }
            ++i;
        }
        if (problemsOccured > 0) {
            Classpath[] newPaths = new Classpath[classpathSize - problemsOccured];
            String[] newNames = new String[classpathSize - problemsOccured];
            int i2 = 0;
            int current = 0;
            while (i2 < classpathSize) {
                if (this.classpaths[i2] != null) {
                    newPaths[current] = this.classpaths[i2];
                    newNames[current++] = pathNames[i2];
                }
                ++i2;
            }
            classpathSize = newPaths.length;
            this.classpaths = newPaths;
            pathNames = newNames;
        }
        this.knownFileNames = new String[initialFileNames.length];
        i = initialFileNames.length;
        while (--i >= 0) {
            String fileName = initialFileNames[i];
            String matchingPathName = null;
            if (fileName.lastIndexOf(".") != -1) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            fileName = this.convertPathSeparators(fileName);
            int j = 0;
            while (j < classpathSize) {
                if (fileName.startsWith(pathNames[j])) {
                    matchingPathName = pathNames[j];
                }
                ++j;
            }
            this.knownFileNames[i] = matchingPathName == null ? fileName : fileName.substring(matchingPathName.length());
        }
    }

    static String assembleName(char[] fileName, char[][] packageName, char separator) {
        return new String(CharOperation.concatWith((char[][])packageName, (char[])fileName, (char)separator));
    }

    static String assembleName(String fileName, char[][] packageName, char separator) {
        return new String(CharOperation.concatWith((char[][])packageName, (char[])(fileName == null ? null : fileName.toCharArray()), (char)separator));
    }

    public void cleanup() {
        int len = this.classpaths.length;
        int i = 0;
        while (i < len) {
            if (this.classpaths[i].getType() == 1) {
                this.classpaths[i].close();
            }
            ++i;
        }
    }

    private String convertPathSeparators(String path) {
        if (File.separatorChar == '/') {
            return path.replace('\\', '/');
        }
        return path.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(char[] name, char[][] packageName) {
        String fullName = JavaNameEnvironment.assembleName(name, packageName, File.separatorChar);
        int i = 0;
        int length = this.knownFileNames.length;
        while (i < length) {
            if (fullName.equals(this.knownFileNames[i])) {
                return null;
            }
            ++i;
        }
        String filename = new String(name);
        String binaryFilename = String.valueOf(filename) + ".class";
        String sourceFilename = String.valueOf(filename) + ".java";
        int i2 = 0;
        int length2 = this.classpaths.length;
        while (i2 < length2) {
            boolean sourceExists;
            Classpath classpath = this.classpaths[i2];
            boolean binaryExists = classpath.exists(binaryFilename, packageName);
            if (binaryExists == (sourceExists = classpath.exists(sourceFilename, packageName))) {
                if (binaryExists) {
                    long sourceModified;
                    long binaryModified = classpath.lastModified(binaryFilename, packageName);
                    if (binaryModified > (sourceModified = classpath.lastModified(sourceFilename, packageName))) {
                        return classpath.readClassFile(binaryFilename, packageName);
                    }
                    if (sourceModified > 0L) {
                        return classpath.readJavaFile(sourceFilename, packageName);
                    }
                }
            } else {
                if (binaryExists) {
                    return classpath.readClassFile(binaryFilename, packageName);
                }
                return classpath.readJavaFile(sourceFilename, packageName);
            }
            ++i2;
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        if (compoundName == null) {
            return null;
        }
        return this.findClass(compoundName[compoundName.length - 1], CharOperation.subarray((char[][])compoundName, (int)0, (int)(compoundName.length - 1)));
    }

    public NameEnvironmentAnswer findType(char[] name, char[][] compoundName) {
        if (name == null) {
            return null;
        }
        return this.findClass(name, compoundName);
    }

    public boolean isPackage(char[][] compoundName, char[] packageName) {
        if (compoundName == null) {
            compoundName = new char[0][];
        }
        int i = 0;
        int length = this.classpaths.length;
        while (i < length) {
            if (this.classpaths[i].isPackage((char[][])compoundName, packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static interface Classpath {
        public static final int DIR_TYPE = 0;
        public static final int JAR_TYPE = 1;

        public int getType();

        public boolean exists(String var1, char[][] var2);

        public long lastModified(String var1, char[][] var2);

        public NameEnvironmentAnswer readClassFile(String var1, char[][] var2);

        public NameEnvironmentAnswer readJavaFile(String var1, char[][] var2);

        public boolean isPackage(char[][] var1, char[] var2);

        public void close();
    }
}

