/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.java;

import com.ibm.etools.common.java.JavaNameEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;

class JarClasspath
implements JavaNameEnvironment.Classpath {
    ZipFile zipFile;
    Hashtable directoryCache;
    final int type = 1;

    JarClasspath(File file) throws IOException {
        this.zipFile = ArchiveUtil.newZipFile((File)file);
        this.buildDirectoryStructure();
    }

    void buildDirectoryStructure() {
        this.directoryCache = new Hashtable(101);
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            if (last <= 0 || this.directoryCache.get(fileName.substring(0, last)) != null) continue;
            int i = 0;
            while (i <= last) {
                String packageName = fileName.substring(0, i = fileName.indexOf(47, i));
                if (this.directoryCache.get(packageName) == null) {
                    this.directoryCache.put(packageName, packageName);
                }
                ++i;
            }
        }
    }

    @Override
    public void close() {
        try {
            this.zipFile.close();
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean exists(String filename, char[][] packageName) {
        return this.zipFile.getEntry(JavaNameEnvironment.assembleName(filename, packageName, '/')) != null;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean isPackage(char[][] compoundName, char[] packageName) {
        return this.directoryCache.get(JavaNameEnvironment.assembleName(packageName, compoundName, '/')) != null;
    }

    @Override
    public long lastModified(String filename, char[][] packageName) {
        ZipEntry entry = this.zipFile.getEntry(JavaNameEnvironment.assembleName(filename, packageName, '/'));
        if (entry == null) {
            return -1L;
        }
        return entry.getTime();
    }

    @Override
    public NameEnvironmentAnswer readClassFile(String filename, char[][] packageName) {
        try {
            return new NameEnvironmentAnswer((IBinaryType)ClassFileReader.read((ZipFile)this.zipFile, (String)JavaNameEnvironment.assembleName(filename, packageName, '/')), null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public NameEnvironmentAnswer readJavaFile(String filename, char[][] packageName) {
        try {
            String fullName = JavaNameEnvironment.assembleName(filename, packageName, '/');
            ZipEntry entry = this.zipFile.getEntry(fullName);
            InputStreamReader reader = new InputStreamReader(this.zipFile.getInputStream(entry));
            int length = (int)entry.getSize();
            char[] contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len, length - len);
                len += readSize;
            }
            reader.close();
            CompilerOptions compilerOptions = new CompilerOptions((Map)JavaCore.getOptions());
            return new NameEnvironmentAnswer((ICompilationUnit)new CompilationUnit(contents, fullName, compilerOptions.defaultEncoding), null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return "Classpath for jar file " + this.zipFile;
    }
}

