/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.insertions;

import com.ibm.etools.common.insertions.ServiceReferenceSelectionModel;
import com.ibm.etools.ejb.codegen.EJBGenHelpers;
import com.ibm.etools.ejb.ui.insertions.AddServiceLocatorManagerJAROperation;
import com.ibm.etools.j2ee.internal.java.insertion.JavaInsertionHelper;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;

public class ServiceReferenceJavaHelperInitializer {
    private static final String A_PREFIX = "a";
    private static final String AN_PREFIX = "an";
    protected static String REF_NAME_FIELD_TEMPLATE = "private final static String STATIC_{0}_REF_NAME = \"{1}\";\n";
    protected static String REF_HOME_CLASS_FIELD_TEMPLATE = "private final static Class STATIC_{0}_CLASS = {0}.class;\n";
    protected static String PROV_URL_FIELD_TEMPLATE = "private final static String STATIC_{0}_PROV_URL = \"{1}\";\n";
    protected static String SERV_TYPE_FIELD_TEMPLATE = "private final static String STATIC_{0}_SERV_TYPE = \"{1}\";\n";
    protected static String LOOKUP_SEI_WITH_PROPS_TEMPLATE = "{0} {1} = ({0})ModelService locator = (ModelService)  ServiceLocatorManager.getServiceLookup(STATIC_{0}_REF_NAME, STATIC_{0}_CLASS, STATIC_{0}_PROV_URL, STATIC_{0}_SERV_TYPE);\n";
    private static String LOOKUP_METHOD_SIG = "protected {0} lookup{0}({1}) ";
    private static String LOOKUP_TEMP1 = "{0} {1} = lookup{0}(";
    private static String LOOKUP_TEMP2 = "return {0};\n}";
    protected static String TRY = "try {\n";
    protected static String CATCH_REMOTE = " catch (RemoteException re) {\n// TODO Auto-generated catch block\nre.printStackTrace();\n}";
    protected static String CATCH_SERVICE = " catch (ServiceException re) {\n// TODO Auto-generated catch block\nre.printStackTrace();\nreturn null;\n}";
    protected static String GET_SEI_LOOKUP = "Service locator = (Service)  ServiceLocatorManager.getServiceLookup(STATIC_{0}_REF_NAME, STATIC_{0}_CLASS);\n";
    protected static String LOOKUP_SEI_TEMPLATE = "{0} {1} = ({0})locator.getPort(STATIC_{0}_CLASS);\n";
    protected String seiName = null;
    protected ServiceReferenceSelectionModel model;
    protected JavaInsertionHelper helper;

    public ServiceReferenceJavaHelperInitializer(ServiceReferenceSelectionModel model, JavaInsertionHelper helper) {
        this.model = model;
        this.helper = helper;
    }

    public JavaInsertionHelper initializeHelper() {
        ServiceRef ref;
        if (this.helper == null) {
            this.helper = new JavaInsertionHelper();
        }
        if ((ref = (ServiceRef)this.model.getProperty("J2EEReferenceSnippetDataModel.selectedReference")) != null) {
            JavaClass sei = (JavaClass)this.model.getProperty("ServiceReferenceSelectionModel.SEI");
            this.seiName = sei.getName();
            this.helper.setInsertionString(this.createInsertionString(this.seiName));
            this.initializeHelperMethods(this.seiName);
            this.initializeHelperFields(this.seiName);
            this.initializeHelperImports();
            this.initializeExtendedOperations();
        }
        return this.helper;
    }

    protected String createInsertionString(String homeName) {
        StringBuffer b = new StringBuffer();
        this.addInsertionMethodCall(b);
        b.append(");\n");
        b.append(TRY);
        b.append(this.createParameterName(this.seiName));
        b.append(".");
        b.append(String.valueOf(this.addMethodCall()) + "(");
        this.appendParameterValues(b);
        b.append(");\n} ");
        b.append(CATCH_REMOTE);
        return b.toString();
    }

    private String addMethodCall() {
        Method meth = (Method)this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
        return meth.getName();
    }

    protected void addInsertionMethodCall(StringBuffer b) {
        JavaClass sei = (JavaClass)this.model.getProperty("ServiceReferenceSelectionModel.SEI");
        String seiName = sei.getName();
        seiName = Signature.getSimpleName((String)seiName);
        String[] args = new String[]{seiName, this.createParameterName(seiName)};
        b.append(this.formatString(LOOKUP_TEMP1, args));
    }

    protected void initializeHelperMethods(String sei) {
        this.addLookupMethod(sei);
    }

    protected void addLookupMethod(String sei) {
        StringBuffer b = new StringBuffer();
        this.addToLookupMethodString(b, sei);
        this.helper.addMethodFromSourceString(b.toString());
    }

    protected void addToLookupMethodString(StringBuffer b, String sei) {
        this.addToLookupMethodString(b, sei, false);
    }

    protected void addToLookupMethodString(StringBuffer b, String sei, boolean addParameters) {
        String clientName = Signature.getSimpleName((String)this.seiName);
        String params = addParameters ? this.getSelectedMethodParametersString() : "";
        String[] sigArgs = new String[]{clientName, params};
        b.append(this.formatString(LOOKUP_METHOD_SIG, sigArgs));
        b.append("{\n");
        b.append(TRY);
        this.addServiceLocatorSEILookup(b, sei, false);
        b.append(this.formatString(LOOKUP_TEMP2, new String[]{this.createParameterName(this.seiName)}));
        b.append("\n");
        b.append(CATCH_SERVICE);
        b.append("\n}");
    }

    protected String getSelectedMethodParametersString() {
        Method method = (Method)this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
        EList parms = method.getParameters();
        if (parms.isEmpty()) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        Iterator it = parms.iterator();
        JavaHelpers type = null;
        while (it.hasNext()) {
            JavaParameter parm = (JavaParameter)it.next();
            type = parm.getJavaType();
            b.append(type.getName()).append(" ");
            if (!type.isPrimitive()) {
                this.helper.addImport(type.getQualifiedName());
            }
            b.append(parm.getName());
            if (!it.hasNext()) continue;
            b.append(", ");
        }
        return b.toString();
    }

    protected void addServiceLocatorSEILookup(StringBuffer b, String seiName, boolean isLocal) {
        b.append(this.formatString(GET_SEI_LOOKUP, new String[]{seiName, this.createParameterName(seiName)}));
        String insertTemplate = this.model.hasContextProperties() ? LOOKUP_SEI_WITH_PROPS_TEMPLATE : LOOKUP_SEI_TEMPLATE;
        b.append(this.formatString(insertTemplate, new String[]{seiName, this.createParameterName(seiName)}));
    }

    protected void appendParameterValues(StringBuffer b) {
        Method method = (Method)this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
        if (method == null) {
            return;
        }
        EList parms = method.getParameters();
        if (!parms.isEmpty()) {
            Iterator it = parms.iterator();
            while (it.hasNext()) {
                JavaParameter parm = (JavaParameter)it.next();
                b.append(this.model.getParamValue(parm));
                if (!it.hasNext()) continue;
                b.append(", ");
            }
        }
    }

    protected void appendParameterNames(StringBuffer b) {
        Method method = (Method)this.model.getProperty("MethodBasedReferenceSnippetDataModel.selectedMethod");
        EList parms = method.getParameters();
        if (parms.isEmpty()) {
            return;
        }
        Iterator it = parms.iterator();
        while (it.hasNext()) {
            JavaParameter parm = (JavaParameter)it.next();
            b.append(parm.getName());
            if (!it.hasNext()) continue;
            b.append(", ");
        }
    }

    protected String createParameterName(String aClassName) {
        if (aClassName != null && aClassName.length() > 0) {
            if (EJBGenHelpers.isVowel((char)aClassName.charAt(0))) {
                return AN_PREFIX + aClassName;
            }
            return A_PREFIX + aClassName;
        }
        return aClassName;
    }

    protected String formatString(String pattern, String[] arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected void initializeHelperFields(String sei) {
        ServiceRef ref = (ServiceRef)this.model.getProperty("J2EEReferenceSnippetDataModel.selectedReference");
        this.helper.addFieldFromSourceString(this.formatString(REF_NAME_FIELD_TEMPLATE, new String[]{sei, ref.getServiceRefName()}));
        this.helper.addFieldFromSourceString(this.formatString(REF_HOME_CLASS_FIELD_TEMPLATE, new String[]{sei}));
        if (this.model.hasContextProperties()) {
            this.helper.addFieldFromSourceString(this.formatString(PROV_URL_FIELD_TEMPLATE, new String[]{sei, this.model.getStringProperty("J2EEReferenceSnippetDataModel.providerURL")}));
            this.helper.addFieldFromSourceString(this.formatString(SERV_TYPE_FIELD_TEMPLATE, new String[]{sei, this.model.getStringProperty("J2EEReferenceSnippetDataModel.nameServiceType")}));
        }
    }

    protected void initializeHelperImports() {
        this.helper.addImport("com.ibm.etools.service.locator.ServiceLocatorManager");
        this.helper.addImport("java.rmi.RemoteException");
        this.helper.addImport("javax.xml.rpc.ServiceException");
        this.helper.addImport("javax.xml.rpc.Service");
        ServiceRef ref = (ServiceRef)this.model.getProperty("J2EEReferenceSnippetDataModel.selectedReference");
        JavaClass sei = (JavaClass)this.model.getProperty("ServiceReferenceSelectionModel.SEI");
        if (ref != null && sei != null) {
            this.helper.addImport(sei.getJavaName());
        }
    }

    private void initializeExtendedOperations() {
        IProject selectedProject = (IProject)this.model.getProperty("J2EEReferenceSnippetDataModel.project");
        if (selectedProject != null) {
            AddServiceLocatorManagerJAROperation op = new AddServiceLocatorManagerJAROperation(selectedProject);
            this.helper.addExtendedOperation((IHeadlessRunnableWithProgress)op);
        }
    }
}

