/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.application.action;

import com.ibm.etools.j2ee.common.operations.AddModuleToEARProjectCommand;
import com.ibm.etools.j2ee.common.operations.AddSecurityRoleOperation;
import com.ibm.etools.j2ee.common.operations.AddSecurityRoleOperationDataModel;
import com.ibm.etools.j2ee.common.operations.RemoveModuleFromEARProjectCommand;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.internal.impl.ApplicationFactoryImpl;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.Identity;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.jst.j2ee.common.SecurityIdentity;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.common.internal.impl.CommonFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.operations.EARComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModelModifier;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class ApplicationHelper {
    public static final int MODULE_APPLICATION_CLIENT = 1;
    public static final int MODULE_EJB = 2;
    public static final int MODULE_WEB = 3;
    public static final int MODULE_CONNECTOR = 4;

    public static void addModuleToApplication(EditingDomain editingDomain, IProject moduleProject, IProject earProject, String uri, String contextRoot, String altDD) {
        AddModuleToEARProjectCommand command = new AddModuleToEARProjectCommand(moduleProject, earProject, uri, contextRoot, altDD);
        command = ApplicationHelper.chainAddEjbClientProjectMappingCommandIfNecessary((Command)command, earProject, moduleProject, uri);
        editingDomain.getCommandStack().execute((Command)command);
    }

    public static void removeModuleFromApplication(EARArtifactEdit earArtifactEdit, EditingDomain editingDomain, List modules, IProject earProject) {
        Object command = null;
        int i = 0;
        while (i < modules.size()) {
            Module module = (Module)modules.get(i);
            if (module != null) {
                command = command == null ? new RemoveModuleFromEARProjectCommand(earArtifactEdit, module, earProject) : command.chain((Command)new RemoveModuleFromEARProjectCommand(earArtifactEdit, module, earProject));
                command = ApplicationHelper.chainRemoveEjbClientProjectMappingCommandIfNecessary((Command)command, editingDomain, earProject, module);
            }
            ++i;
        }
        if (command != null) {
            editingDomain.getCommandStack().execute(command);
        }
    }

    private static Command chainAddEjbClientProjectMappingCommandIfNecessary(Command aCommand, IProject earProject, IProject moduleProject, String moduleUri) {
        return aCommand;
    }

    private static Command chainRemoveEjbClientProjectMappingCommandIfNecessary(Command aCommand, EditingDomain domain, IProject earProject, Module module) {
        return aCommand;
    }

    public static boolean addSecurityRole(EditingDomain editingDomain, EObject owner, String roleName, String roleDescription) {
        ModifierHelper helper = new ModifierHelper();
        helper.addAttribute((EStructuralFeature)CommonFactoryImpl.getPackage().getSecurityRole_RoleName(), (Object)roleName);
        helper.addAttribute((EStructuralFeature)CommonFactoryImpl.getPackage().getSecurityRole_Description(), (Object)roleDescription);
        helper.setOwner(owner);
        if (owner instanceof Application) {
            helper.setFeature((EStructuralFeature)ApplicationHelper.getApplicationPackage().getApplication_SecurityRoles());
        } else if (owner instanceof AssemblyDescriptor) {
            helper.setFeature((EStructuralFeature)EjbPackage.eINSTANCE.getAssemblyDescriptor_SecurityRoles());
        } else if (owner instanceof WebApp) {
            helper.setFeature((EStructuralFeature)WebapplicationPackage.eINSTANCE.getWebApp_SecurityRoles());
        } else if (owner instanceof MethodPermission) {
            helper.setFeature((EStructuralFeature)EjbPackage.eINSTANCE.getMethodPermission_Roles());
        } else {
            return false;
        }
        ModelModifier modifier = new ModelModifier(editingDomain);
        return modifier.execute(helper);
    }

    public static void collectEJB20IdentitiesForRoleNamed(EJBJar ejbJar, String roleName, List identityList, List beanList) {
        EList allBeanList = ejbJar.getEnterpriseBeans();
        int i = 0;
        while (i < allBeanList.size()) {
            Identity identity;
            SecurityIdentity id;
            EnterpriseBean bean = (EnterpriseBean)allBeanList.get(i);
            if (bean != null && (id = bean.getSecurityIdentity()) != null && id instanceof RunAsSpecifiedIdentity && roleName.equals((identity = ((RunAsSpecifiedIdentity)id).getIdentity()).getRoleName())) {
                identityList.add(identity);
                beanList.add(bean);
            }
            ++i;
        }
    }

    public static List collectMethodPermissionsForRoleNamed(EJBJar ejbJar, String roleName) {
        ArrayList<MethodPermission> methodPermissionList = new ArrayList<MethodPermission>();
        AssemblyDescriptor ad = ejbJar.getAssemblyDescriptor();
        EList methodPermissions = ad.getMethodPermissions();
        int i = 0;
        int n = methodPermissions.size();
        while (i < n) {
            MethodPermission ms = (MethodPermission)methodPermissions.get(i);
            if (ms.getSecurityRole(roleName) != null) {
                methodPermissionList.add(ms);
            }
            ++i;
        }
        return methodPermissionList;
    }

    public static void collectSecurityRoleRefsForRoleNamed(EJBJar ejbJar, String roleName, List securityRoleRefList, List beanList) {
        EList beans = ejbJar.getEnterpriseBeans();
        int i = 0;
        int n = beans.size();
        while (i < n) {
            EnterpriseBean bean = (EnterpriseBean)beans.get(i);
            EList securityRoleRefs = bean.getSecurityRoleRefs();
            int j = 0;
            int m = securityRoleRefs.size();
            while (j < m) {
                SecurityRoleRef securityRoleRef = (SecurityRoleRef)securityRoleRefs.get(j);
                if (securityRoleRef != null && roleName.equals(securityRoleRef.getLink())) {
                    securityRoleRefList.add(securityRoleRef);
                    beanList.add(bean);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void collectSecurityRoleRefsForRoleNamed(WebApp webApp, String roleName, List securityRoleRefList, List servletList) {
        EList servlets = webApp.getServlets();
        int i = 0;
        int n = servlets.size();
        while (i < n) {
            Servlet servlet = (Servlet)servlets.get(i);
            EList securityRoleRefs = servlet.getSecurityRoleRefs();
            int j = 0;
            int m = securityRoleRefs.size();
            while (j < m) {
                SecurityRoleRef securityRoleRef = (SecurityRoleRef)securityRoleRefs.get(j);
                if (securityRoleRef != null && roleName.equals(securityRoleRef.getLink())) {
                    securityRoleRefList.add(securityRoleRef);
                    servletList.add(servlet);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void collectAuthConstraintsForRoleNamed(WebApp webApp, String roleName, List authList, List constraintList) {
        EList constraints = webApp.getConstraints();
        int i = 0;
        int n = constraints.size();
        while (i < n) {
            EList roleNames;
            SecurityConstraint constraint = (SecurityConstraint)constraints.get(i);
            AuthConstraint authConstraint = constraint.getAuthConstraint();
            if (authConstraint != null && (roleNames = authConstraint.getRoles()).contains(roleName)) {
                authList.add(authConstraint);
                constraintList.add(constraint);
            }
            ++i;
        }
    }

    public static void consolidateSecurityRole(EARArtifactEdit artifactEdit, EditingDomain editingDomain, IProject earProject, SecurityRole originalRole, SecurityRole replaceRole) {
        ArrayList<Module> moduleList = new ArrayList<Module>();
        ArrayList roleList = new ArrayList();
        try {
            EARFile earFile = ApplicationHelper.getEARFile(artifactEdit, true, false);
            EList modules = earFile.getDeploymentDescriptor().getModules();
            int nModule = modules.size();
            if (nModule == 0) {
                return;
            }
            int i = 0;
            while (i < nModule) {
                Module module = (Module)modules.get(i);
                if (module.isEjbModule() || module.isWebModule()) {
                    List roles = ApplicationHelper.getSecurityRolesFromModule(artifactEdit, earProject, module);
                    int j = 0;
                    int nRole = roles.size();
                    while (j < nRole) {
                        moduleList.add(module);
                        roleList.add(roles.get(j));
                        ++j;
                    }
                }
                ++i;
            }
            int nRole = roleList.size();
            if (nRole == 0) {
                return;
            }
            ArrayList<Integer> affectedIndexes = new ArrayList<Integer>();
            int i2 = 0;
            while (i2 < nRole) {
                SecurityRole affectedRole = (SecurityRole)roleList.get(i2);
                if (originalRole.getRoleName().equals(affectedRole.getRoleName())) {
                    affectedIndexes.add(new Integer(i2));
                }
                ++i2;
            }
            int nAffected = affectedIndexes.size();
            if (nAffected == 0) {
                return;
            }
            int i3 = 0;
            while (i3 < nAffected) {
                int index = (Integer)affectedIndexes.get(i3);
                SecurityRole role = (SecurityRole)roleList.get(index);
                ApplicationHelper.modifyAttribute(editingDomain, (EObject)role, (EStructuralFeature)CommonFactoryImpl.getPackage().getSecurityRole_RoleName(), replaceRole.getRoleName());
                ApplicationHelper.modifyAttribute(editingDomain, (EObject)role, (EStructuralFeature)CommonFactoryImpl.getPackage().getSecurityRole_Description(), replaceRole.getDescription());
                Application application = earFile.getDeploymentDescriptor();
                ApplicationHelper.removeAttribute(editingDomain, (EObject)application, (EStructuralFeature)ApplicationHelper.getApplicationPackage().getApplication_SecurityRoles(), originalRole);
                ++i3;
            }
        }
        catch (OpenFailureException e) {
            J2EEUIPlugin.logError(e);
        }
    }

    public static ModifierHelper createHelperForAddSecurityRole(EObject owner, String roleName, String roleDescription) {
        ModifierHelper helper = new ModifierHelper();
        helper.addAttribute((EStructuralFeature)CommonFactoryImpl.getPackage().getSecurityRole_RoleName(), (Object)roleName);
        helper.addAttribute((EStructuralFeature)CommonFactoryImpl.getPackage().getSecurityRole_Description(), (Object)roleDescription);
        helper.setOwner(owner);
        if (owner instanceof Application) {
            helper.setFeature((EStructuralFeature)ApplicationHelper.getApplicationPackage().getApplication_SecurityRoles());
        } else if (owner instanceof AssemblyDescriptor) {
            helper.setFeature((EStructuralFeature)EjbPackage.eINSTANCE.getAssemblyDescriptor_SecurityRoles());
        } else if (owner instanceof WebApp) {
            helper.setFeature((EStructuralFeature)WebapplicationPackage.eINSTANCE.getWebApp_SecurityRoles());
        } else if (owner instanceof MethodPermission) {
            helper.setFeature((EStructuralFeature)EjbPackage.eINSTANCE.getMethodPermission_Roles());
        } else {
            return null;
        }
        return helper;
    }

    public static ModifierHelper createHelperForModifyAttribute(EObject owner, EStructuralFeature feature, Object value) {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner(owner);
        helper.setFeature(feature);
        helper.setValue(value);
        return helper;
    }

    public static ModifierHelper createHelperForRemoveAttribute(EObject owner, EStructuralFeature feature, Object value) {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner(owner);
        helper.setFeature(feature);
        helper.setValue(value);
        helper.doUnsetValue();
        return helper;
    }

    public static boolean executeModifierForCompoundCommand(ModelModifier modifier) {
        return modifier.execute();
    }

    public static ApplicationPackage getApplicationPackage() {
        return ApplicationFactoryImpl.getPackage();
    }

    public static CommonPackage getCommonPackage() {
        return (CommonPackage)EPackage.Registry.INSTANCE.getEPackage("common.xmi");
    }

    public static void getModuleRoleRelations(EARArtifactEdit artifactEdit, IProject earProject, List moduleList, List roleList) {
        try {
            EARFile earFile = ApplicationHelper.getEARFile(artifactEdit, true, false);
            EList modules = earFile.getDeploymentDescriptor().getModules();
            int nModule = modules.size();
            if (nModule == 0) {
                return;
            }
            int i = 0;
            while (i < nModule) {
                Module module = (Module)modules.get(i);
                IVirtualComponent comp = ApplicationHelper.getVirtualComponentFromModule(artifactEdit, module);
                if (comp != null && (module.isEjbModule() || module.isWebModule())) {
                    List roles = ApplicationHelper.getSecurityRolesFromModule(artifactEdit, earProject, module);
                    int j = 0;
                    int nRole = roles.size();
                    while (j < nRole) {
                        moduleList.add(module);
                        roleList.add(roles.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (OpenFailureException e) {
            J2EEUIPlugin.logError(e);
        }
    }

    public static List getModulesForRoleNamed(EARArtifactEdit artifactEdit, IProject earProject, String roleName) {
        ArrayList<Module> moduleList = new ArrayList<Module>();
        EList modules = artifactEdit.getApplication().getModules();
        int nModule = modules.size();
        if (nModule == 0) {
            return moduleList;
        }
        int i = 0;
        while (i < nModule) {
            Module module = (Module)modules.get(i);
            IVirtualComponent comp = ApplicationHelper.getVirtualComponentFromModule(artifactEdit, module);
            if (comp != null && (module.isEjbModule() || module.isWebModule())) {
                List roles = ApplicationHelper.getSecurityRolesFromModule(artifactEdit, earProject, module);
                int j = 0;
                int nRole = roles.size();
                while (j < nRole) {
                    SecurityRole role = (SecurityRole)roles.get(j);
                    if (role.getRoleName().equals(roleName)) {
                        moduleList.add(module);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return moduleList;
    }

    public static String getModuleUriNameWithDefaultFileExtension(int moduleType, String uriName) {
        if (uriName == null) {
            uriName = "";
        }
        String newUriName = null;
        if (uriName.length() > 0) {
            int index = uriName.lastIndexOf(".");
            if (index == -1) {
                switch (moduleType) {
                    case 3: {
                        newUriName = String.valueOf(uriName) + ".war";
                        break;
                    }
                    case 4: {
                        newUriName = String.valueOf(uriName) + ".rar";
                        break;
                    }
                    default: {
                        newUriName = String.valueOf(uriName) + ".jar";
                        break;
                    }
                }
            } else {
                String fileExt = uriName.substring(index + 1);
                switch (moduleType) {
                    case 3: {
                        if (fileExt.equalsIgnoreCase("war")) break;
                        newUriName = String.valueOf(uriName.substring(0, index + 1)) + "war";
                        break;
                    }
                    case 4: {
                        if (fileExt.equalsIgnoreCase("rar")) break;
                        newUriName = String.valueOf(uriName.substring(0, index + 1)) + "rar";
                        break;
                    }
                    default: {
                        if (fileExt.equalsIgnoreCase("jar")) break;
                        newUriName = String.valueOf(uriName.substring(0, index + 1)) + "jar";
                    }
                }
            }
        }
        if (newUriName == null) {
            newUriName = uriName;
        }
        return newUriName;
    }

    public static List getVirtualComponentsFromEAR(EnterpriseArtifactEdit artifactEdit) {
        IProject earProject = artifactEdit.getProject();
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        IVirtualReference[] refs = earComp.getReferences();
        ArrayList<IVirtualComponent> compList = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < refs.length) {
            compList.add(refs[i].getReferencedComponent());
            ++i;
        }
        return compList;
    }

    public static IVirtualComponent getVirtualComponentFromModule(EARArtifactEdit artifactEdit, Module module) {
        if (module.getUri() != null) {
            return artifactEdit.getModuleByManifestURI(module.getUri());
        }
        return null;
    }

    public static IProject getProjectFromUtilJarMapping(UtilityJARMapping utilJarMapping) {
        if (utilJarMapping != null) {
            String projectName = utilJarMapping.getProjectName();
            return ProjectUtilities.getProject((String)projectName);
        }
        return null;
    }

    public static String[] getSecurityRoleNamesForApplication(Application rootObject) {
        EList existingRoles = rootObject.getSecurityRoles();
        int n = existingRoles.size();
        String[] roleNames = new String[n];
        int i = 0;
        while (i < n) {
            SecurityRole role = (SecurityRole)existingRoles.get(i);
            roleNames[i] = role.getRoleName();
            ++i;
        }
        return roleNames;
    }

    public static List getSecurityRolesFromAllModules(EARArtifactEdit artifactEdit, IProject earProject) {
        ArrayList roleList = new ArrayList();
        IVirtualReference[] moduleList = artifactEdit.getJ2EEModuleReferences();
        int i = 0;
        while (i < moduleList.length) {
            List roles;
            IVirtualComponent comp = moduleList[i].getReferencedComponent();
            String compType = J2EEProjectUtilities.getJ2EEProjectType((IProject)comp.getProject());
            if (compType.equals("jst.ejb") && (roles = ApplicationHelper.getSecurityRolesFromEJBComponent(comp)) != null && roles.size() > 0) {
                roleList.addAll(roles);
            }
            if (compType.equals("jst.web") && (roles = ApplicationHelper.getSecurityRolesFromWebComponent(comp)) != null && roles.size() > 0) {
                roleList.addAll(roles);
            }
            ++i;
        }
        return roleList;
    }

    private static List getSecurityRolesFromEJBComponent(IVirtualComponent comp) {
        EJBArtifactEdit edit = null;
        EList roles = new ArrayList();
        try {
            edit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)comp);
            AssemblyDescriptor ad = edit.getEJBJar().getAssemblyDescriptor();
            if (ad != null) {
                roles = ad.getSecurityRoles();
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return roles;
    }

    private static List getSecurityRolesFromWebComponent(IVirtualComponent comp) {
        WebArtifactEdit edit = null;
        EList roles = new ArrayList();
        try {
            edit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)comp);
            roles = edit.getWebApp().getSecurityRoles();
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return roles;
    }

    public static List getSecurityRolesFromModule(EARArtifactEdit artifactEdit, IProject earProject, Module module) {
        List roleList = new ArrayList();
        IVirtualComponent comp = ApplicationHelper.getVirtualComponentFromModule(artifactEdit, module);
        if (module.isEjbModule()) {
            roleList = ApplicationHelper.getSecurityRolesFromEJBComponent(comp);
        } else if (module.isWebModule()) {
            roleList = ApplicationHelper.getSecurityRolesFromWebComponent(comp);
        }
        return roleList;
    }

    public static ModelModifier initializeModifierForCompoundCommand(EditingDomain editingDomain) {
        ModelModifier modifier = new ModelModifier(editingDomain);
        return modifier;
    }

    public static boolean modifyAttribute(EditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value) {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner(owner);
        helper.setFeature(feature);
        helper.setValue(value);
        ModelModifier modifier = new ModelModifier(editingDomain);
        return modifier.execute(helper);
    }

    public static boolean removeAttribute(EditingDomain editingDomain, EObject owner, EStructuralFeature feature, Object value) {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner(owner);
        helper.setFeature(feature);
        helper.setValue(value);
        helper.doUnsetValue();
        ModelModifier modifier = new ModelModifier(editingDomain);
        return modifier.execute(helper);
    }

    public static void rollupRoles(EARArtifactEdit artifactEdit, EditingDomain editingDomain, IProject earProject) {
        try {
            EARFile earFile = ApplicationHelper.getEARFile(artifactEdit, true, false);
            earFile.rollUpRoles();
        }
        catch (OpenFailureException e) {
            J2EEUIPlugin.logError(e);
        }
    }

    public static int rollupRoles(EARArtifactEdit artifactEdit, List roleList, IProject earProject) {
        Application applicaiton = artifactEdit.getApplication();
        EList earRoleList = applicaiton.getSecurityRoles();
        ArrayList<String> earRoleNameList = new ArrayList<String>();
        if (earRoleList != null && earRoleList.size() > 0) {
            int i = 0;
            while (i < earRoleList.size()) {
                earRoleNameList.add(((SecurityRole)earRoleList.get(i)).getRoleName());
                ++i;
            }
        }
        int count = 0;
        int i = 0;
        int n = roleList.size();
        while (i < n) {
            SecurityRole role = (SecurityRole)roleList.get(i);
            String roleName = role.getRoleName();
            if (!earRoleNameList.contains(roleName)) {
                AddSecurityRoleOperationDataModel model = new AddSecurityRoleOperationDataModel();
                IProject project = artifactEdit.getProject();
                model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", (Object)project.getName());
                model.setProperty("AddSecurityRoleOperationDataModel.ROLE_NAME", (Object)role.getRoleName());
                model.setProperty("AddSecurityRoleOperationDataModel.ROLE_DESCRIPTION", (Object)role.getDescription());
                AddSecurityRoleOperation op = new AddSecurityRoleOperation(model);
                try {
                    op.run(null);
                }
                catch (InvocationTargetException e) {
                    J2EEUIPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    J2EEUIPlugin.logError(e);
                }
                earRoleNameList.add(roleName);
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static EARFile getEARFile(EARArtifactEdit artifactEdit, boolean exportSource, boolean mergeDependents) throws OpenFailureException {
        IVirtualComponent comp = artifactEdit.getComponent();
        IProject proj = comp.getProject();
        if (proj == null) {
            return null;
        }
        ArchiveOptions options = new ArchiveOptions();
        options.setIsReadOnly(true);
        EARComponentLoadStrategyImpl loader = new EARComponentLoadStrategyImpl(comp);
        options.setLoadStrategy((LoadStrategy)loader);
        Application app = artifactEdit.getApplication();
        loader.setResourceSet(app.eResource().getResourceSet());
        loader.setExportSource(true);
        return CommonarchiveFactory.eINSTANCE.openEARFile(options, proj.getName());
    }

    public static Object[] getReferencingEARsForGivenModuleProject(IProject aModuleproject) {
        ArrayList<Application> earCompList = new ArrayList<Application>();
        if (aModuleproject == null) {
            return earCompList.toArray();
        }
        IProject[] projects = J2EEProjectUtilities.getReferencingEARProjects((IProject)aModuleproject);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            EARArtifactEdit earArtifactEdit = null;
            try {
                earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)project);
                Application earRoot = earArtifactEdit.getApplication();
                earCompList.add(earRoot);
            }
            finally {
                if (earArtifactEdit != null) {
                    earArtifactEdit.dispose();
                }
            }
            ++i;
        }
        return earCompList.toArray();
    }

    public static HashMap getEARArtifactEditMapForModuleProject(IProject aModuleproject) {
        HashMap<Application, EARArtifactEdit> earArtifactEditMap = new HashMap<Application, EARArtifactEdit>();
        IProject[] projects = J2EEProjectUtilities.getReferencingEARProjects((IProject)aModuleproject);
        if (projects.length > 0) {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                EARArtifactEdit earArtifactEdit = null;
                earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)project);
                Application earRoot = earArtifactEdit.getApplication();
                if (earRoot != null) {
                    earArtifactEditMap.put(earRoot, earArtifactEdit);
                }
                ++i;
            }
        }
        return earArtifactEditMap;
    }

    public static Object[] getReferencingEARsForGivenModuleComponent(IVirtualComponent moduleComp) {
        ArrayList<Resource> earCompList = new ArrayList<Resource>();
        if (moduleComp == null) {
            return earCompList.toArray();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            String projectTypeId = J2EEProjectUtilities.getJ2EEProjectType((IProject)project);
            if (projectTypeId.equals("jst.ear")) {
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                IVirtualReference[] refs = component.getReferences();
                int j = 0;
                while (j < refs.length) {
                    IVirtualComponent refComp = refs[j].getReferencedComponent();
                    if (refComp != null && refComp.equals(moduleComp)) {
                        EARArtifactEdit earArtifactEdit = null;
                        try {
                            earArtifactEdit = EARArtifactEdit.getEARArtifactEditForWrite((IVirtualComponent)component);
                            Application earRoot = earArtifactEdit.getApplication();
                            Resource res = earRoot.eResource();
                            earCompList.add(res);
                        }
                        finally {
                            if (earArtifactEdit != null) {
                                earArtifactEdit.dispose();
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return earCompList.toArray();
    }
}

