/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal.actions;

import com.ibm.etools.j2ee.migration.internal.ComposedMigrationConfig;
import com.ibm.etools.j2ee.migration.internal.J2EEMigrationUIResourceHandler;
import com.ibm.etools.j2ee.migration.ui.internal.actions.ClientMigrationWizardPage;
import com.ibm.etools.j2ee.migration.ui.internal.actions.ConnectorMigrationWizardPage;
import com.ibm.etools.j2ee.migration.ui.internal.actions.EARMigrationWizardPage;
import com.ibm.etools.j2ee.migration.ui.internal.actions.EJBBeanMigrationWizardPage;
import com.ibm.etools.j2ee.migration.ui.internal.actions.EJBModuleMigrationWizardPage;
import com.ibm.etools.j2ee.migration.ui.internal.actions.MigrationStatusDialog;
import com.ibm.etools.j2ee.migration.ui.internal.actions.MigrationWelcomeWizardPage;
import com.ibm.etools.j2ee.migration.ui.internal.actions.WebMigrationWizardPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.internal.J2EEStatus;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public class J2EEMigrationWizard
extends DataModelWizard {
    public static final String CLIENT_MODULE_PAGE_NAME = "clientModulePage";
    public static final String EAR_PAGE_NAME = "earPage";
    public static final String EJB_BEAN_PAGE_NAME = "ejbBeanPage";
    public static final String EJB_MODULE_PAGE_NAME = "ejbModulePage";
    public static final String WEB_MODULE_PAGE_NAME = "webModulePage";
    public static final String CONNECTOR_PAGE_NAME = "connectorPage";
    public static final String WELCOME_PAGE_NAME = "welcomePage";
    protected ClientMigrationWizardPage clientPage;
    protected IDataModel composedConfig;
    protected EARMigrationWizardPage earPage;
    protected EJBBeanMigrationWizardPage ejbBeanPage;
    protected EJBModuleMigrationWizardPage ejbModulePage;
    protected IStructuredSelection selection;
    protected WebMigrationWizardPage webMigPage;
    protected MigrationWelcomeWizardPage welcomePage;
    protected ConnectorMigrationWizardPage connectorPage;
    protected IWorkbench workbench;
    protected String j2eeVersion = "1.2";
    protected List pageList = new ArrayList();

    public J2EEMigrationWizard() {
        this.setDataModel(this.composedConfig);
        this.setWindowTitle(J2EEMigrationUIResourceHandler.Migration_Wizard_Title_);
    }

    public void addPage(IWizardPage page) {
        super.addPage(page);
        this.pageList.add(page.getName());
    }

    public void doAddPages() {
        this.welcomePage = new MigrationWelcomeWizardPage(this.composedConfig, WELCOME_PAGE_NAME);
        this.addPage((IWizardPage)this.welcomePage);
        this.earPage = new EARMigrationWizardPage(EAR_PAGE_NAME, this.composedConfig);
        this.addPage((IWizardPage)this.earPage);
        this.ejbModulePage = new EJBModuleMigrationWizardPage(EJB_MODULE_PAGE_NAME, this.composedConfig);
        this.addPage((IWizardPage)this.ejbModulePage);
        this.ejbBeanPage = new EJBBeanMigrationWizardPage(EJB_BEAN_PAGE_NAME, this.composedConfig);
        this.addPage((IWizardPage)this.ejbBeanPage);
        this.webMigPage = new WebMigrationWizardPage(WEB_MODULE_PAGE_NAME, this.composedConfig);
        this.addPage((IWizardPage)this.webMigPage);
        this.clientPage = new ClientMigrationWizardPage(CLIENT_MODULE_PAGE_NAME, this.composedConfig);
        this.addPage((IWizardPage)this.clientPage);
        if (this.isValidVersionForConnector()) {
            this.connectorPage = new ConnectorMigrationWizardPage(CONNECTOR_PAGE_NAME, this.composedConfig);
            this.addPage((IWizardPage)this.connectorPage);
        }
    }

    private boolean isValidVersionForConnector() {
        return this.j2eeVersion.equals("1.3") || this.j2eeVersion.equals("1.0") || this.j2eeVersion.equals("1.5") || this.j2eeVersion.equals("1.4");
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() != this.welcomePage && super.canFinish();
    }

    private boolean confirmFinish() {
        return this.ejbBeanPage.confirmAllRequiredBeansSelected();
    }

    protected IDataModel createDefaultModel() {
        return DataModelFactory.createDataModel((IDataModelProvider)this.getDefaultProvider());
    }

    public void dispose() {
        super.dispose();
        if (this.composedConfig != null) {
            this.composedConfig.dispose();
        }
    }

    public IDataModel getMigrationConfig() {
        return this.composedConfig;
    }

    public String getNextPage(String currentPageName, String expectedNextPageName) {
        if (this.shouldBeVisible(expectedNextPageName)) {
            return expectedNextPageName;
        }
        Iterator iterator = this.pageList.iterator();
        boolean expectedFound = false;
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (expectedFound) {
                if (!this.shouldBeVisible(next)) continue;
                return next;
            }
            if (!next.equals(expectedNextPageName)) continue;
            expectedFound = true;
        }
        return null;
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.workbench = aWorkbench;
        this.selection = aSelection;
        this.setDefaultPageImageDescriptor(J2EEUIPlugin.getDefault().getImageDescriptor("versionmigrate3_wiz"));
    }

    private void initConfigFromProjects(List components) {
        try {
            if (components.size() == 1) {
                IVirtualComponent comp = (IVirtualComponent)components.get(0);
                IProject project = comp.getProject();
                this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", (Object)comp.getName());
                this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT", (Object)comp);
                this.getDataModel().setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)project.getName());
                String projectType = J2EEProjectUtilities.getJ2EEProjectType((IProject)project);
                if (projectType.equals("jst.ear")) {
                    this.getDataModel().setProperty("J2EEMigrationConfig.deploymentDesType", (Object)"jst.ear");
                    this.composedConfig = this.getDataModel();
                    this.setNestedServerTargetDMProperties(project, projectType);
                    return;
                }
                this.setNestedServerTargetDMProperties(project, projectType);
            }
            this.getDataModel().setProperty("IComposedMigrationConfigProperties.components", (Object)components);
            this.getDataModel().setProperty("J2EEMigrationConfig.deploymentDesType", (Object)"");
            this.composedConfig = this.getDataModel();
        }
        finally {
            this.setDataModel(this.composedConfig);
        }
    }

    private void setNestedServerTargetDMProperties(IProject project, String projectType) {
        IDataModel nestedModel = this.getDataModel().getNestedModel("J2EEMigrationConfig.NESTED_MODEL_SERVER_TARGET");
        nestedModel.setStringProperty("IJ2EEProjectServerTargetDataModelProperties.DD_TYPE_ID", projectType);
        nestedModel.setStringProperty("IJ2EEProjectServerTargetDataModelProperties.J2EE_VERSION_ID", "5.0");
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    protected void postPerformFinish() {
        this.showMigrationReport((J2EEStatus)this.composedConfig.getProperty("J2EEMigrationConfig.migrationStatus"));
    }

    protected boolean prePerformFinish() {
        if (!this.confirmFinish()) {
            return false;
        }
        return super.prePerformFinish();
    }

    public void setComponents(List components) {
        this.initConfigFromProjects(components);
    }

    protected boolean shouldBeVisible(String aPage) {
        if (aPage == WELCOME_PAGE_NAME) {
            return true;
        }
        boolean isEar = this.composedConfig.getBooleanProperty("J2EEMigrationConfig.isEARComponent");
        IVirtualComponent comp = (IVirtualComponent)this.composedConfig.getProperty("IArtifactEditOperationDataModelProperties.TARGET_COMPONENT");
        String type = JavaEEProjectUtilities.getJ2EEComponentType((IVirtualComponent)comp);
        if (aPage == EAR_PAGE_NAME) {
            return isEar;
        }
        if (aPage == EJB_MODULE_PAGE_NAME) {
            return type.equals("jst.ejb") || isEar && this.composedConfig.getBooleanProperty("IComposedMigrationConfigProperties.hasEJBJarChildren");
        }
        if (aPage == EJB_BEAN_PAGE_NAME) {
            return type.equals("jst.ejb") && this.ejbModulePage.isAddLocalClientSelected() && this.ejbBeanPage.hasApplicableBeans() || isEar && this.composedConfig.getBooleanProperty("IComposedMigrationConfigProperties.hasEJBJarChildren") && this.ejbModulePage.isAddLocalClientSelected() && this.ejbBeanPage.hasApplicableBeans();
        }
        if (aPage == WEB_MODULE_PAGE_NAME) {
            return type.equals("jst.web") || isEar && this.composedConfig.getBooleanProperty("IComposedMigrationConfigProperties.hasWEBChildren");
        }
        if (aPage == CLIENT_MODULE_PAGE_NAME) {
            return type.equals("jst.appclient") || isEar && this.composedConfig.getBooleanProperty("IComposedMigrationConfigProperties.hasAppClientChildren");
        }
        if (aPage == CONNECTOR_PAGE_NAME) {
            return type.equals("jst.connector") || isEar && this.composedConfig.getBooleanProperty("IComposedMigrationConfigProperties.hasConnectorChildren");
        }
        return true;
    }

    private void showMigrationReport(J2EEStatus status) {
        if (status != null) {
            MigrationStatusDialog.openDialog(this.getShell(), null, null, status);
        }
    }

    public void setJ2eeVersion(String version) {
        this.j2eeVersion = version;
    }

    protected IDataModelProvider getDefaultProvider() {
        return new ComposedMigrationConfig();
    }
}

