/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.migration.ui.internal;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.migration.classpath.J2EEClasspathValidator;
import com.ibm.etools.j2ee.migration.internal.OldJ2EESettings;
import com.ibm.etools.j2ee.migration.ui.internal.plugin.MigrationUIPlugin;
import com.ibm.etools.j2ee.migration.validation.IBackwardMigrationConstants;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.internal.WTPProjectUtilities;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;

public class RemoveCompatibilityOperation
extends WTPOperation
implements IBackwardMigrationConstants {
    private IProject moduleProject;
    private static List removedProjects = null;

    public RemoveCompatibilityOperation(IProject project) {
        this.moduleProject = project;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                removedProjects = new ArrayList();
                RemoveCompatibilityOperation.this.remove(monitor);
                ValidatorManager manager = ValidatorManager.getManager();
                int i = 0;
                while (i < removedProjects.size()) {
                    IProject project = (IProject)removedProjects.get(i);
                    if (manager.isEnabled(project, "com.ibm.etools.j2ee.migration.classpath.J2EEClasspathValidator")) {
                        J2EEClasspathValidator.runValidator(project, true);
                    }
                    ++i;
                }
                removedProjects = null;
            }
        };
        try {
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            MigrationUIPlugin.logError(e);
        }
        catch (InterruptedException e) {
            MigrationUIPlugin.logError(e);
        }
    }

    protected void remove(IProgressMonitor monitor) {
        String compId = J2EEProjectUtilities.getJ2EEProjectType((IProject)this.moduleProject);
        try {
            if (removedProjects.contains(this.moduleProject)) {
                return;
            }
            removedProjects.add(this.moduleProject);
            IFile projectFile = this.moduleProject.getFile(".project");
            if (!projectFile.isSynchronized(0)) {
                projectFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            if (compId.equals("jst.ear")) {
                IVirtualComponent component = ComponentCore.createComponent((IProject)this.moduleProject);
                IVirtualReference[] references = component.getReferences();
                int i = 0;
                while (i < references.length) {
                    IProject childModuleProject;
                    IVirtualReference reference = references[i];
                    if (!J2EEProjectUtilities.getJ2EEComponentType((IVirtualComponent)reference.getReferencedComponent()).equals("") && (childModuleProject = reference.getReferencedComponent().getProject()) != null && childModuleProject.exists() && !childModuleProject.equals((Object)this.moduleProject)) {
                        RemoveCompatibilityOperation op = new RemoveCompatibilityOperation(childModuleProject);
                        op.remove(monitor);
                    }
                    ++i;
                }
                this.removeNatureIfExists("com.ibm.wtp.j2ee.EARNature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.EAR13Nature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.EARNature");
                this.removeDotFileIfExists("META-INF/.modulemaps");
                ArrayList<String> builderNames = new ArrayList<String>();
                builderNames.add("com.ibm.etools.common.migration.MigrationBuilder");
                builderNames.add("com.ibm.wtp.migration.MigrationBuilder");
                builderNames.add("com.ibm.etools.validation.validationbuilder");
                builderNames.add("com.ibm.sse.model.structuredbuilder");
                this.removeBuildersIfExists(builderNames);
            } else if (compId.equals("jst.appclient")) {
                this.removeNatureIfExists("com.ibm.wtp.j2ee.ApplicationClientNature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.ApplicationClient_J2EE13_Nature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.ApplicationClientNature");
                this.removeCommonBuildersIfExists();
            } else if (compId.equals("jst.ejb")) {
                this.removeNatureIfExists("com.ibm.wtp.ejb.EJBNature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.EJB2_0Nature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.EJBNature");
                this.removeCommonBuildersIfExists();
            } else if (compId.equals("jst.web") || compId.equals("wst.web")) {
                IVirtualComponent component = ComponentCore.createComponent((IProject)this.moduleProject);
                IVirtualReference[] references = component.getReferences();
                int i = 0;
                while (i < references.length) {
                    IProject childModuleProject;
                    IVirtualReference reference = references[i];
                    if (!J2EEProjectUtilities.getJ2EEComponentType((IVirtualComponent)reference.getReferencedComponent()).equals("") && (childModuleProject = reference.getReferencedComponent().getProject()) != null && childModuleProject.exists() && !childModuleProject.equals((Object)this.moduleProject)) {
                        RemoveCompatibilityOperation op = new RemoveCompatibilityOperation(childModuleProject);
                        op.remove(monitor);
                    }
                    ++i;
                }
                this.removeNatureIfExists("com.ibm.wtp.web.WebNature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.WebNature");
                this.removeNatureIfExists("com.ibm.wtp.web.StaticWebNature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.StaticWebNature");
                this.removeDotFileIfExists(".websettings");
                ArrayList<String> builderNames = new ArrayList<String>();
                builderNames.add("com.ibm.etools.common.migration.MigrationBuilder");
                builderNames.add("com.ibm.wtp.migration.MigrationBuilder");
                builderNames.add("com.ibm.etools.validation.validationbuilder");
                builderNames.add("com.ibm.sse.model.structuredbuilder");
                builderNames.add("com.ibm.wtp.j2ee.LibCopyBuilder");
                builderNames.add("com.ibm.etools.j2ee.LibCopyBuilder");
                builderNames.add("com.ibm.etools.j2ee.ui.LibDirBuilder");
                builderNames.add("com.ibm.etools.webtools.additions.linksbuilder");
                builderNames.add("com.ibm.etools.webtools.additions.jspcompilationbuilder");
                this.removeBuildersIfExists(builderNames);
            } else if (compId.equals("jst.connector")) {
                this.removeNatureIfExists("com.ibm.wtp.jca.ConnectorNature");
                this.removeNatureIfExists("com.ibm.etools.j2ee.ConnectorNature");
                this.removeCommonBuildersIfExists();
            } else if (compId.equals("jst.utility")) {
                this.removeCommonBuildersIfExists();
            }
            this.removeNatureIfExists("com.ibm.etools.beaninfo.BeaninfoNature");
            this.removeDotFileIfExists(OldJ2EESettings.J2EE_SETTINGS_FILE_NAME);
            this.removeDotFileIfExists(".compatibility");
        }
        catch (Exception e) {
            MigrationUIPlugin.logError(e);
        }
    }

    private void removeNatureIfExists(String natureId) throws CoreException {
        if (this.moduleProject.getDescription().hasNature(natureId)) {
            WTPProjectUtilities.removeNatureFromProject((IProject)this.moduleProject, (String)natureId);
        }
    }

    protected void removeDotFileIfExists(String dotFileName) throws CoreException {
        IFile dotFile = this.moduleProject.getFile(dotFileName);
        if (dotFile.exists()) {
            if (!dotFile.isSynchronized(0)) {
                dotFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            dotFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void removeCommonBuildersIfExists() {
        ArrayList<String> builderNames = new ArrayList<String>();
        builderNames.add("com.ibm.etools.common.migration.MigrationBuilder");
        builderNames.add("com.ibm.wtp.migration.MigrationBuilder");
        builderNames.add("com.ibm.etools.validation.validationbuilder");
        builderNames.add("com.ibm.sse.model.structuredbuilder");
        builderNames.add("com.ibm.wtp.j2ee.LibCopyBuilder");
        builderNames.add("com.ibm.etools.j2ee.LibCopyBuilder");
        builderNames.add("com.ibm.etools.ctc.serviceprojectbuilder");
        this.removeBuildersIfExists(builderNames);
    }

    protected void removeBuildersIfExists(List builderNames) {
        try {
            IFile projectFile = this.moduleProject.getFile(".project");
            if (!projectFile.isSynchronized(0)) {
                projectFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            IProjectDescription description = this.moduleProject.getDescription();
            ICommand[] builders = description.getBuildSpec();
            int n = builders.length;
            ArrayList<ICommand> newBuilderList = new ArrayList<ICommand>();
            int i = 0;
            while (i < n) {
                if (!builderNames.contains(builders[i].getBuilderName())) {
                    newBuilderList.add(builders[i]);
                }
                ++i;
            }
            n = newBuilderList.size();
            ICommand[] newBuilders = new ICommand[n];
            int i2 = 0;
            while (i2 < n) {
                newBuilders[i2] = (ICommand)newBuilderList.get(i2);
                ++i2;
            }
            description.setBuildSpec(newBuilders);
            this.moduleProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MigrationUIPlugin.logError(e);
        }
    }
}

