/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee13.commands;

import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee13.commands.Persistent20RoleCommand;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.CMRField;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;

public class UpdatePersistent20RoleCommand
extends Persistent20RoleCommand {
    protected boolean wasForward;

    public UpdatePersistent20RoleCommand(IRootCommand parent, EJBRelationshipRole aRole) {
        super(parent, aRole.getName());
        this.initializeFromRole(aRole);
    }

    public UpdatePersistent20RoleCommand(IRootCommand parent, EJBRelationshipRole aRole, boolean shouldGenJava) {
        super(parent, aRole.getName(), shouldGenJava);
        this.initializeFromRole(aRole);
    }

    public UpdatePersistent20RoleCommand(IRootCommand parent, EJBRelationshipRole aRole, boolean shouldGenJava, boolean shouldGenMetadata) {
        super(parent, aRole.getName(), shouldGenJava, shouldGenMetadata);
        this.initializeFromRole(aRole);
    }

    protected void initializeFromRole(EJBRelationshipRole aRole) {
        if (aRole != null) {
            this.setIsMany(aRole.getMultiplicity().getValue() == 1);
            this.setIsCascadeDelete(aRole.isCascadeDelete());
            CMRField field = aRole.getCmrField();
            if (field != null) {
                this.setCmrFieldName(field.getName());
                this.setCmrFieldCollectionTypeName(field.getCollectionTypeName());
            }
            this.wasForward = aRole.isForward();
            this.setCommonRole((CommonRelationshipRole)aRole);
        }
    }

    @Override
    protected void executeForMetadataGeneration() {
        super.executeForMetadataGeneration();
        EJBRelationshipRole aRole = this.getEJBRelationshipRole();
        if (aRole != null) {
            aRole.setRoleName(this.getName());
            this.setRoleMultiplicity(aRole);
            this.updateCmrFieldInformation(aRole);
            if (this.isCascadeDelete()) {
                aRole.setCascadeDelete(true);
            } else {
                aRole.unsetCascadeDelete();
            }
            boolean removedAttributes = this.removeAttributesIfNecessary();
            this.updateForwardFlag(aRole);
            if (!removedAttributes) {
                aRole.reconcileAttributes();
            }
        }
    }

    private boolean removeAttributesIfNecessary() {
        if (this.wasForward && !this.isForward()) {
            EList attributes = this.getCommonRole().getAttributes();
            if (!attributes.isEmpty()) {
                ContainerManagedEntity cmp = this.getCommonRole().getSourceEntity();
                if (cmp != null) {
                    cmp.getPersistentAttributes().removeAll((Collection)attributes);
                    cmp.getKeyAttributes().removeAll((Collection)attributes);
                }
                attributes.clear();
            }
            return true;
        }
        return false;
    }

    protected void updateForwardFlag(EJBRelationshipRole aRole) {
        EJBRelation relation;
        boolean currentForwardFlag = aRole.isForward();
        if (currentForwardFlag != this.isForward() && (relation = aRole.getRelationship()) != null && this.isForward()) {
            relation.setFoward(aRole);
        }
    }

    protected void updateCmrFieldInformation(EJBRelationshipRole aRole) {
        CMRField field = aRole.getCmrField();
        aRole.setName(null);
        boolean createdField = false;
        if (field == null && this.hasCmrFieldUpdates()) {
            field = this.getEJBFactory().createCMRField();
            createdField = true;
        }
        if (field == null) {
            return;
        }
        if (this.getCmrFieldName() != null) {
            field.setName(this.getCmrFieldName());
            if (this.getCmrFieldCollectionTypeName() != null) {
                field.setCollectionTypeName(this.getCmrFieldCollectionTypeName());
            } else {
                field.setCollectionType(null);
            }
        } else {
            aRole.setCmrField(null);
        }
        if (createdField) {
            aRole.setCmrField(field);
        }
    }

    protected boolean hasCmrFieldUpdates() {
        return this.getCmrFieldName() != null || this.getCmrFieldCollectionTypeName() != null;
    }

    @Override
    protected void setupHelper() {
        super.setupHelper();
        this.getHelper().setUpdate();
    }

    @Override
    protected void setupInverseHelper() {
        super.setupInverseHelper();
        this.getInverseHelper().setUpdate();
    }

    @Override
    protected void undoMetadataGeneration() {
        super.undoMetadataGeneration();
    }
}

