/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb.operations;

import com.ibm.etools.j2ee.ejb.operations.AbstractEJBClientJAROperation;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.ClientJARCreationConstants;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public class EJBClientJARRemovalOperation
extends AbstractEJBClientJAROperation {
    protected IPath clientProjectPath;
    protected IPath ejbProjectPath;
    protected List sourceContainers;
    protected List libraryContainers;
    protected IContainer ejbSourceContainer;
    protected IPath ejbSourcePath;
    protected IPath outputPath;
    protected boolean shouldDelete = true;
    protected boolean yesToAll = false;

    public EJBClientJARRemovalOperation(IDataModel dataModel, IOperationHandler opHandler) {
        super(dataModel, opHandler);
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected void addAdditionalFilesForValidateEdit(final List roFiles) throws CoreException {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.isDerived()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 4: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                    case 1: {
                        if (!resource.isReadOnly()) break;
                        roFiles.add(resource);
                        break;
                    }
                }
                return false;
            }
        };
        this.clientProject.accept(visitor);
    }

    protected void initializeEARNatures() {
    }

    protected void execute(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor = aMonitor;
        this.initialize();
        if (!this.verifyFilesInSync()) {
            this.monitor.done();
            throw new OperationCanceledException();
        }
        this.monitor.beginTask(ClientJARCreationConstants.REMOVING_CLIENT_JAR, 10);
        this.ensureEJBJARInAllEARs();
        this.updateEJBModuleJARDependencies();
        this.copyOutgoingClasspathEntries(this.clientProject, this.ejbProject, false);
        this.moveIncomingJARDependencies();
        this.updateDD();
        this.removeClientProjectFromEARs();
        this.moveFiles();
        this.addSourceContainersToClassPath();
        if (this.moveResourceMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.deleteClientProject();
    }

    private void addSourceContainersToClassPath() throws JavaModelException {
        int x = 0;
        while (x < this.sourceContainers.size()) {
            if (this.sourceContainers.get(x) instanceof IResource) {
                IResource resource = (IResource)this.sourceContainers.get(x);
                if (this.clientProject == resource) {
                    return;
                }
                IPath srcPath = this.ejbProjectPath.append(resource.getProjectRelativePath());
                IFolder existing = this.workspace.getRoot().getFolder(srcPath);
                if (existing != null && existing.exists()) {
                    JemProjectUtilities.appendJavaClassPath((IProject)this.ejbProject, (IClasspathEntry)JavaCore.newSourceEntry((IPath)srcPath));
                }
            }
            ++x;
        }
    }

    private void updateDD() {
    }

    private void ensureEJBJARInAllEARs() {
    }

    private void updateEJBModuleJARDependencies() throws InvocationTargetException, InterruptedException {
    }

    private void moveIncomingJARDependencies() throws InvocationTargetException, InterruptedException {
    }

    private void moveFiles() throws CoreException {
        this.moveResourceMonitor = this.createSubProgressMonitor(1);
        IResourceVisitor visitor = this.getRootResourceVisitor();
        this.clientProject.accept(visitor);
    }

    private IResourceVisitor getRootResourceVisitor() {
        return new IResourceVisitor(){
            private boolean projectIsSource;
            {
                this.projectIsSource = EJBClientJARRemovalOperation.this.sourceContainers.contains(EJBClientJARRemovalOperation.this.clientProject);
            }

            public boolean visit(IResource resource) throws CoreException {
                if (EJBClientJARRemovalOperation.this.moveResourceMonitor.isCanceled()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 1: {
                        if (!resource.isDerived()) {
                            this.visitFile((IFile)resource);
                        }
                        return false;
                    }
                    case 2: {
                        return this.visitFolder((IFolder)resource);
                    }
                    case 4: {
                        return true;
                    }
                }
                return false;
            }

            private void visitFile(IFile file) throws CoreException {
                if (this.isMetaFile(file)) {
                    return;
                }
                if (this.projectIsSource) {
                    EJBClientJARRemovalOperation.this.moveFile(file, EJBClientJARRemovalOperation.this.clientProjectPath, EJBClientJARRemovalOperation.this.ejbSourcePath);
                } else {
                    EJBClientJARRemovalOperation.this.moveFile(file, EJBClientJARRemovalOperation.this.clientProjectPath, EJBClientJARRemovalOperation.this.ejbProjectPath);
                }
            }

            private boolean isMetaFile(IFile file) {
                String segment = file.getProjectRelativePath().toString();
                return ".classpath".equals(segment) || ".project".equals(segment) || ".runtime".equals(segment);
            }

            private boolean visitFolder(IFolder folder) throws CoreException {
                if (this.isSourceFolder(folder)) {
                    this.visitSourceFolder(folder);
                    return false;
                }
                if (this.isOutputFolder(folder)) {
                    return false;
                }
                if (this.isClassesFolder(folder)) {
                    this.visitClassesFolder(folder);
                    return false;
                }
                return true;
            }

            private boolean isOutputFolder(IFolder folder) {
                IPath path = folder.getProjectRelativePath();
                while (path.segmentCount() > 0 && EJBClientJARRemovalOperation.this.outputPath != null) {
                    if (path.equals((Object)EJBClientJARRemovalOperation.this.outputPath)) {
                        return true;
                    }
                    path = path.removeLastSegments(1);
                }
                return false;
            }

            private boolean isSourceFolder(IFolder folder) {
                return EJBClientJARRemovalOperation.this.sourceContainers.contains(folder);
            }

            private void visitSourceFolder(IFolder folder) throws CoreException {
                folder.accept(EJBClientJARRemovalOperation.this.getFolderResourceVisitor(folder.getFullPath(), this.computeEJBSourceFolder(folder)));
            }

            private IPath computeEJBSourceFolder(IFolder clientProjectFolder) {
                IPath clientFolderRelativePath = clientProjectFolder.getProjectRelativePath();
                return EJBClientJARRemovalOperation.this.ejbProjectPath.append(clientFolderRelativePath);
            }

            private boolean isClassesFolder(IFolder folder) {
                return EJBClientJARRemovalOperation.this.libraryContainers.contains(folder);
            }

            protected void visitClassesFolder(IFolder folder) throws CoreException {
                IPath classesPath = this.getEJBClassesPath();
                folder.accept(EJBClientJARRemovalOperation.this.getFolderResourceVisitor(folder.getFullPath(), classesPath));
            }

            private IPath getEJBClassesPath() throws CoreException {
                IFolder folder = EJBClientJARRemovalOperation.this.ejbProject.getFolder("imported_classes");
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                JemProjectUtilities.appendJavaClassPath((IProject)EJBClientJARRemovalOperation.this.ejbProject, (IClasspathEntry)JavaCore.newLibraryEntry((IPath)folder.getFullPath(), null, null, (boolean)true));
                return folder.getFullPath();
            }
        };
    }

    private IResourceVisitor getFolderResourceVisitor(final IPath sourceRoot, final IPath destinationRoot) {
        return new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (EJBClientJARRemovalOperation.this.moveResourceMonitor.isCanceled()) {
                    return false;
                }
                switch (resource.getType()) {
                    case 1: {
                        if (!resource.isDerived() && !this.isManifest(sourceRoot, resource.getFullPath())) {
                            EJBClientJARRemovalOperation.this.moveFile((IFile)resource, sourceRoot, destinationRoot);
                        }
                        return false;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }

            private boolean isManifest(IPath new_sourceRoot, IPath path) {
                String relativeURI = path.removeFirstSegments(new_sourceRoot.segmentCount()).toString();
                return "META-INF/MANIFEST.MF".equals(relativeURI);
            }
        };
    }

    private void moveFile(IFile file, IPath sourceRoot, IPath destinationRoot) throws CoreException {
        IPath filePath = file.getFullPath();
        IPath relativeFilePath = filePath.removeFirstSegments(sourceRoot.segmentCount());
        IPath newPath = destinationRoot.append(relativeFilePath);
        this.mkdirs(newPath, this.workspace.getRoot());
        IFile existing = this.workspace.getRoot().getFile(newPath);
        if (!this.yesToAll && existing.exists()) {
            String message = this.format(ClientJARCreationConstants.SHOULD_OVERWRITE, new String[]{filePath.toString(), newPath.toString()});
            int answer = 1;
            if (this.operationHandler != null) {
                answer = this.operationHandler.canContinueWithAllCheckAllowCancel(message);
            }
            switch (answer) {
                case 0: {
                    break;
                }
                case 1: {
                    this.yesToAll = true;
                    break;
                }
                case 2: {
                    return;
                }
                case 3: {
                    this.moveResourceMonitor.setCanceled(true);
                    return;
                }
            }
        }
        if (!existing.exists()) {
            file.move(newPath, true, this.moveResourceMonitor);
        } else {
            existing.setContents(file.getContents(), true, true, this.moveResourceMonitor);
        }
    }

    private void removeClientProjectFromEARs() {
    }

    private void deleteClientProject() throws CoreException {
        if (this.shouldDelete) {
            this.clientProject.delete(true, true, this.createSubProgressMonitor(1));
        }
    }
}

