/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb.operations;

import com.ibm.etools.ejb.creation.EjbModificationOperation;
import com.ibm.etools.j2ee.commands.AddPrimaryKeyClassCommand;
import com.ibm.etools.j2ee.commands.CreatePrimaryKeyClassCommand;
import com.ibm.etools.j2ee.commands.DeletePrimaryKeyClassCommand;
import com.ibm.etools.j2ee.commands.IEJBCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee.commands.UpdateContainerManagedEntityCommand;
import com.ibm.etools.j2ee.commands.UpdateEntityCommand;
import com.ibm.etools.j2ee.ejb.EjbPlugin;
import com.ibm.etools.j2ee.ejb.operations.ChangeKeyClassInfoProvider;
import com.ibm.etools.j2ee.ejb.operations.IChangeKeyClassDataModelProperties;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class ChangeKeyClassOperation
extends EjbModificationOperation
implements IChangeKeyClassDataModelProperties {
    public ChangeKeyClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected IEJBCommand createCommand() {
        IRootCommand root;
        IRootCommand merged = null;
        if (this.shouldDeleteObsoleteKeyClass() && !this.getInfoProvider().shouldUsePrimitiveKeyAttributeType()) {
            root = this.createRootCommand();
            if (root != null) {
                this.createDeleteKeyCommand(root);
            }
            merged = root;
        }
        if ((root = this.createRootCommand()) != null) {
            this.createDependentCommands(root);
            merged = merged != null ? merged.append(root) : root;
        }
        return merged;
    }

    private boolean shouldDeleteObsoleteKeyClass() {
        EnterpriseBean ejb = this.getInfoProvider().getEnterpriseBean();
        return this.getInfoProvider().shouldDeleteObsoleteKeyClass() && (ejb.isBeanManagedEntity() || ((ContainerManagedEntity)ejb).getPrimKeyField() == null);
    }

    protected void createDeleteKeyCommand(IRootCommand root) {
        Entity entity = (Entity)this.getInfoProvider().getEnterpriseBean();
        new DeletePrimaryKeyClassCommand(root, entity.getPrimaryKey());
    }

    protected void createDependentCommands(IRootCommand aRootCommand) {
        if (this.getInfoProvider().shouldUsePrimitiveKeyAttributeType()) {
            this.createKeyClassCommandForPrimitive(aRootCommand);
        } else if (this.getInfoProvider().isExistingKeyClass()) {
            this.createKeyClassCommandForExisting(aRootCommand);
        } else {
            this.createKeyClassCommandForNew(aRootCommand);
        }
    }

    protected void createKeyClassCommandForExisting(IRootCommand aRootCommand) {
        new AddPrimaryKeyClassCommand(aRootCommand, this.getInfoProvider().getKeyClassName(), this.getInfoProvider().getKeyClassPackageName());
    }

    protected void createKeyClassCommandForNew(IRootCommand aRootCommand) {
        new CreatePrimaryKeyClassCommand(aRootCommand, this.getInfoProvider().getKeyClassName(), this.getInfoProvider().getKeyClassPackageName());
    }

    protected void createKeyClassCommandForPrimitive(IRootCommand aRootCommand) {
        EnterpriseBean ejb = this.getInfoProvider().getEnterpriseBean();
        if (ejb.isContainerManagedEntity()) {
            ContainerManagedEntity cmp = (ContainerManagedEntity)ejb;
            DeletePrimaryKeyClassCommand command = new DeletePrimaryKeyClassCommand(aRootCommand, cmp.getPrimaryKey());
            if (!this.getInfoProvider().shouldDeleteObsoleteKeyClass()) {
                command.setGenerateJava(false);
            }
        }
    }

    protected IRootCommand createRootCommand() {
        EnterpriseBean ejb = this.getInfoProvider().getEnterpriseBean();
        return this.primCreateRootCommand(ejb);
    }

    protected IRootCommand primCreateRootCommand(EnterpriseBean ejb) {
        if (ejb.isBeanManagedEntity()) {
            return new UpdateEntityCommand(ejb, this.getEJBArtifactEdit());
        }
        if (ejb.isContainerManagedEntity()) {
            return new UpdateContainerManagedEntityCommand(ejb, this.getEJBArtifactEdit());
        }
        return null;
    }

    @Override
    protected String errorMessage() {
        return null;
    }

    protected ChangeKeyClassInfoProvider getInfoProvider() {
        return (ChangeKeyClassInfoProvider)this.model.getProperty("IChangeKeyClassInfoProviderProperties.INFO_PROVIDER");
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            super.doExecute(monitor);
        }
        catch (CoreException ce) {
            EjbPlugin.logError(ce);
        }
        catch (InvocationTargetException ite) {
            EjbPlugin.logError(ite);
        }
        catch (InterruptedException ie) {
            EjbPlugin.logError(ie);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

