/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb.creation.operations;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.internal.util.MethodElementHelper;
import org.eclipse.jst.j2ee.internal.EjbModuleExtensionHelper;
import org.eclipse.jst.j2ee.internal.IEJBModelExtenderManager;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class PushDownHelper {
    private static EClass META_ASSEMBLY_DESCRIPTOR = EjbPackage.eINSTANCE.getAssemblyDescriptor();
    public static final PushDownHelper INSTANCE = new PushDownHelper();

    protected AssemblyDescriptor getAssemblyDescriptor(EnterpriseBean bean) {
        if (bean.getEjbJar() == null) {
            return null;
        }
        return bean.getEjbJar().getAssemblyDescriptor();
    }

    public void pushDownAssemblyData(EnterpriseBean originalSupertype, EnterpriseBean aSubtype) {
        AssemblyDescriptor descriptor = this.getAssemblyDescriptor(originalSupertype);
        if (descriptor == null) {
            return;
        }
        this.pushDownMethodElements(originalSupertype, aSubtype, descriptor);
        List generalizationsForSub = this.getSubtypes(aSubtype);
        int size = generalizationsForSub.size();
        int i = 0;
        while (i < size) {
            EnterpriseBean sub = (EnterpriseBean)generalizationsForSub.get(i);
            this.pushDownAssemblyData(originalSupertype, sub);
            ++i;
        }
    }

    protected AssemblyDescriptor getAssemblyDescriptor(MethodElement aMethodElement) {
        MethodElement container = aMethodElement;
        while ((container = container.eContainer()) != null && container.eClass() != META_ASSEMBLY_DESCRIPTOR) {
        }
        return (AssemblyDescriptor)container;
    }

    public boolean pushDownMethodElement(MethodElement aMethodElement) {
        EnterpriseBean bean = aMethodElement.getEnterpriseBean();
        List subtypes = this.getSubtypes(bean);
        if (subtypes != null && !subtypes.isEmpty()) {
            int i = 0;
            while (i < subtypes.size()) {
                this.pushDownMethodElement(aMethodElement, (EnterpriseBean)subtypes.get(i));
                ++i;
            }
            return true;
        }
        return false;
    }

    protected void pushDownMethodElement(MethodElement aMethodElement, EnterpriseBean subtype) {
        AssemblyDescriptor dd = this.getAssemblyDescriptor(aMethodElement);
        if (dd == null) {
            return;
        }
        this.pushDownMethodElement(aMethodElement, subtype, dd);
        List generalizationsForSub = this.getSubtypes(subtype);
        int size = generalizationsForSub.size();
        int i = 0;
        while (i < size) {
            generalizationsForSub.get(i);
            this.pushDownMethodElement(aMethodElement, subtype);
            ++i;
        }
    }

    public void removePushedDownAssemblyData(EnterpriseBean originalSupertype, EnterpriseBean aSubtype) {
        AssemblyDescriptor dd = this.getAssemblyDescriptor(originalSupertype);
        if (dd == null) {
            return;
        }
        this.removePushedDownMethodElements(originalSupertype, aSubtype, dd);
        List generalizationsForSub = this.getSubtypes(aSubtype);
        int size = generalizationsForSub.size();
        int i = 0;
        while (i < size) {
            EnterpriseBean gen = (EnterpriseBean)generalizationsForSub.get(i);
            this.removePushedDownAssemblyData(originalSupertype, gen);
            ++i;
        }
    }

    protected void removePushedDownMethodElement(MethodElement aMethodElement) {
        EnterpriseBean bean = aMethodElement.getEnterpriseBean();
        List subtypes = this.getSubtypes(bean);
        int i = 0;
        while (i < subtypes.size()) {
            this.removePushedDownMethodElement(aMethodElement, (EnterpriseBean)subtypes.get(i));
            ++i;
        }
    }

    protected void removePushedDownMethodElement(MethodElement aMethodElement, EnterpriseBean subtype) {
        AssemblyDescriptor dd = this.getAssemblyDescriptor(aMethodElement);
        if (dd == null) {
            return;
        }
        this.removePushedDownMethodElement(aMethodElement, subtype, dd);
        List generalizationsForSub = this.getSubtypes(subtype);
        int size = generalizationsForSub.size();
        int i = 0;
        while (i < size) {
            EnterpriseBean gen = (EnterpriseBean)generalizationsForSub.get(i);
            this.removePushedDownMethodElement(aMethodElement, gen);
            ++i;
        }
    }

    private List getSubtypes(EnterpriseBean bean) {
        if (bean == null) {
            return Collections.EMPTY_LIST;
        }
        EjbModuleExtensionHelper modHelper = IEJBModelExtenderManager.INSTANCE.getEJBModuleExtension(null);
        return modHelper == null ? Collections.EMPTY_LIST : modHelper.getSubtypes(bean);
    }

    protected void pushDownMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        if (aMethodElement == null || subEJB == null) {
            return;
        }
        int type = MethodElementHelper.getContainedType((MethodElement)aMethodElement);
        switch (type) {
            case 1: {
                this.pushDownMethodPermissionMethodElement(aMethodElement, subEJB, ad);
            }
            case 2: {
                this.pushDownMethodTransactionMethodElement(aMethodElement, subEJB, ad);
            }
        }
    }

    protected void pushDownMethodElements(EnterpriseBean superEJB, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        if (superEJB == null || subEJB == null) {
            return;
        }
        this.pushDownMethodPermissionMethodElements(superEJB, subEJB, ad);
        this.pushDownMethodTransactionMethodElements(superEJB, subEJB, ad);
    }

    protected void pushDownMethodPermissionMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        this.pushDownMethodPermissionMethodElement(aMethodElement, subEJB, ad.getMethodPermissionMethodElements(subEJB));
    }

    protected void pushDownMethodPermissionMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, List allMEs) {
        boolean containsME = false;
        int j = 0;
        while (j < allMEs.size()) {
            MethodElement subME = (MethodElement)allMEs.get(j);
            if (subME.equalSignature(aMethodElement) && ((MethodPermission)subME.eContainer()).isEquivalent((MethodPermission)aMethodElement.eContainer())) {
                containsME = true;
                break;
            }
            ++j;
        }
        if (!containsME) {
            this.createMethodElement(aMethodElement, subEJB, EjbPackage.eINSTANCE.getMethodPermission_MethodElements());
        }
    }

    protected void pushDownMethodPermissionMethodElements(EnterpriseBean superEJB, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        List subMethodElements = ad.getMethodPermissionMethodElements(subEJB);
        List superMethodElements = ad.getMethodPermissionMethodElements(superEJB);
        int i = 0;
        while (i < superMethodElements.size()) {
            MethodElement superME = (MethodElement)superMethodElements.get(i);
            this.pushDownMethodPermissionMethodElement(superME, subEJB, subMethodElements);
            ++i;
        }
    }

    protected void pushDownMethodTransactionMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        this.pushDownMethodTransactionMethodElement(aMethodElement, subEJB, ad.getMethodTransactionMethodElements(subEJB));
    }

    protected void pushDownMethodTransactionMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, List allMEs) {
        boolean containsME = false;
        int j = 0;
        while (j < allMEs.size()) {
            MethodElement subME = (MethodElement)allMEs.get(j);
            if (subME.equalSignature(aMethodElement) && ((MethodTransaction)subME.eContainer()).isEquivalent((MethodTransaction)aMethodElement.eContainer())) {
                containsME = true;
                break;
            }
            ++j;
        }
        if (!containsME) {
            this.createMethodElement(aMethodElement, subEJB, EjbPackage.eINSTANCE.getMethodTransaction_MethodElements());
        }
    }

    protected void pushDownMethodTransactionMethodElements(EnterpriseBean superEJB, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        if (superEJB == null || subEJB == null) {
            return;
        }
        List subMethodElements = ad.getMethodTransactionMethodElements(subEJB);
        List superMethodElements = ad.getMethodTransactionMethodElements(superEJB);
        int i = 0;
        while (i < superMethodElements.size()) {
            MethodElement superME = (MethodElement)superMethodElements.get(i);
            this.pushDownMethodTransactionMethodElement(superME, subEJB, subMethodElements);
            ++i;
        }
    }

    protected void removePushedDownMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, AssemblyDescriptor dd) {
        if (aMethodElement == null || subEJB == null) {
            return;
        }
        int type = MethodElementHelper.getContainedType((MethodElement)aMethodElement);
        switch (type) {
            case 1: {
                this.removePushedDownMethodPermissionMethodElement(aMethodElement, subEJB, dd);
            }
            case 2: {
                this.removePushedDownMethodTransactionMethodElement(aMethodElement, subEJB, dd);
            }
        }
    }

    protected void removePushedDownMethodElements(EnterpriseBean superEJB, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        this.removePushedDownMethodPermissionMethodElements(superEJB, subEJB, ad);
        this.removePushedDownMethodTransactionMethodElements(superEJB, subEJB, ad);
    }

    protected void removePushedDownMethodPermissionMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        this.removePushedDownMethodPermissionMethodElement(aMethodElement, subEJB, ad.getMethodPermissionMethodElements(subEJB));
    }

    protected void removePushedDownMethodPermissionMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, List allMEs) {
        int j = 0;
        while (j < allMEs.size()) {
            MethodElement subME = (MethodElement)allMEs.get(j);
            if (subME.equalSignature(aMethodElement) && ((MethodPermission)subME.eContainer()).isEquivalent((MethodPermission)aMethodElement.eContainer())) {
                allMEs.remove(j);
                MethodPermission mp = (MethodPermission)subME.eContainer();
                if (mp.getMethodElements().size() > 1) {
                    mp.getMethodElements().remove((Object)subME);
                    break;
                }
                mp.getAssemblyDescriptor().getMethodPermissions().remove((Object)mp);
                break;
            }
            ++j;
        }
    }

    protected void removePushedDownMethodPermissionMethodElements(EnterpriseBean superEJB, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        if (superEJB == null || subEJB == null) {
            return;
        }
        List subMethodElements = ad.getMethodPermissionMethodElements(subEJB);
        List superMethodElements = ad.getMethodPermissionMethodElements(superEJB);
        int i = 0;
        while (i < superMethodElements.size()) {
            MethodElement superME = (MethodElement)superMethodElements.get(i);
            this.removePushedDownMethodPermissionMethodElement(superME, subEJB, subMethodElements);
            ++i;
        }
    }

    protected void removePushedDownMethodTransactionMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        this.removePushedDownMethodTransactionMethodElement(aMethodElement, subEJB, ad.getMethodTransactionMethodElements(subEJB));
    }

    protected void removePushedDownMethodTransactionMethodElement(MethodElement aMethodElement, EnterpriseBean subEJB, List allMEs) {
        int j = 0;
        while (j < allMEs.size()) {
            MethodElement subME = (MethodElement)allMEs.get(j);
            if (subME.equalSignature(aMethodElement) && ((MethodTransaction)subME.eContainer()).isEquivalent((MethodTransaction)aMethodElement.eContainer())) {
                allMEs.remove(j);
                MethodTransaction mt = (MethodTransaction)subME.eContainer();
                if (mt.getMethodElements().size() > 1) {
                    mt.getMethodElements().remove((Object)subME);
                    break;
                }
                mt.getAssemblyDescriptor().getMethodTransactions().remove((Object)mt);
                break;
            }
            ++j;
        }
    }

    protected void removePushedDownMethodTransactionMethodElements(EnterpriseBean superEJB, EnterpriseBean subEJB, AssemblyDescriptor ad) {
        List subMethodElements = ad.getMethodTransactionMethodElements(subEJB);
        List superMethodElements = ad.getMethodTransactionMethodElements(superEJB);
        int i = 0;
        while (i < superMethodElements.size()) {
            MethodElement superME = (MethodElement)superMethodElements.get(i);
            this.removePushedDownMethodTransactionMethodElement(superME, subEJB, subMethodElements);
            ++i;
        }
    }

    protected MethodElement createMethodElement(MethodElement originalMethodElement, EnterpriseBean anEJB, EReference aContainerReference) {
        if (originalMethodElement == null) {
            return null;
        }
        MethodElement newME = EjbPackage.eINSTANCE.getEjbFactory().createMethodElement();
        newME.setName(originalMethodElement.getName());
        newME.setParms(originalMethodElement.getParms());
        newME.setType(originalMethodElement.getType());
        newME.setEnterpriseBean(anEJB);
        ExtendedEcoreUtil.eSetOrAdd((EObject)originalMethodElement.eContainer(), (EStructuralFeature)aContainerReference, (Object)newME);
        return newME;
    }
}

