/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb.creation.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.ejb.creation.operations.AddMessageDestinationOperation;
import com.ibm.etools.j2ee.ejb.creation.operations.Messages;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.MessageDestination;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class MessageDestinationCreationDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String NAME = "MessageDestinationCreationDataModel.DESTINATION_NAME";
    public static final String DESCRIPTION = "MessageDestinationCreationDataModel.DESCRIPTION";

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(NAME);
        this.addValidBaseProperty(DESCRIPTION);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(NAME)) {
            return this.validateDestinationName(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateDestinationName(String roleName) {
        if (roleName.length() == 0) {
            String msg = Messages.MessageDestinationCreationDataModel_0;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        boolean exists = this.destinationExists(roleName, this.getDeploymentDescriptorRoot());
        if (exists) {
            String msg = Messages.MessageDestinationCreationDataModel_1;
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private boolean destinationExists(String roleName, EObject root) {
        switch (this.getDeploymentDescriptorType()) {
            case 1: {
                return this.destinationExists(roleName, (ApplicationClient)root);
            }
            case 3: {
                return this.destinationExists(roleName, (EJBJar)root);
            }
            case 4: {
                return this.destinationExists(roleName, (WebApp)root);
            }
        }
        return false;
    }

    private boolean destinationExists(String roleName, EJBJar jar) {
        AssemblyDescriptor descriptor = jar.getAssemblyDescriptor();
        if (descriptor == null) {
            return false;
        }
        EList messageDest = descriptor.getMessageDestinations();
        if (messageDest == null || messageDest.isEmpty()) {
            return false;
        }
        return this.messageDestNameExist((List)messageDest, roleName);
    }

    private boolean destinationExists(String roleName, ApplicationClient appClient) {
        return this.messageDestNameExist((List)appClient.getMessageDestinations(), roleName);
    }

    private boolean destinationExists(String roleName, WebApp webApp) {
        return this.messageDestNameExist((List)webApp.getMessageDestinations(), roleName);
    }

    private boolean messageDestNameExist(List messageDest, String roleName) {
        int i = 0;
        while (i < messageDest.size()) {
            MessageDestination dest = (MessageDestination)messageDest.get(i);
            if (dest.getName() != null && dest.getName().equals(roleName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public WTPOperation getDefaultOperation() {
        return new AddMessageDestinationOperation(this);
    }
}

