/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb.creation.operations;

import com.ibm.etools.j2ee.commands.EJBRelationshipCommand;
import com.ibm.etools.j2ee.commands.IEJBCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee.commands.PersistentRoleCommand;
import com.ibm.etools.j2ee.commands.UpdateContainerManagedEntityCommand;
import com.ibm.etools.j2ee.commands.UpdateEntityCommand;
import com.ibm.etools.j2ee.commands.UpdateSessionCommand;
import com.ibm.etools.j2ee.ejb.creation.operations.EJBRelationshipDataModel;
import com.ibm.etools.j2ee.ejb.operations.EJBArtifactEditOperation;
import com.ibm.etools.j2ee13.commands.CreateEJB20RelationshipCommand;
import com.ibm.etools.j2ee13.commands.CreatePersistent20RoleCommand;
import com.ibm.etools.j2ee13.commands.Persistent20RoleCommand;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.ejb.provider.EJBProviderLibrariesResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;

public class EJBRelationshipCreationOperation
extends EJBArtifactEditOperation {
    protected EJBRelationshipCommand relationshipCommand;
    protected EJBRelationshipDataModel model;

    public EJBRelationshipCreationOperation(EJBRelationshipDataModel operationDataModel) {
        super(operationDataModel);
        this.model = operationDataModel;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IEJBCommand command = this.createCommand();
        if (command != null) {
            if (command.isRootCommand()) {
                ((IRootCommand)command).setProgressMonitor(monitor);
            }
            try {
                try {
                    this.getCommandStack().execute((Command)command);
                }
                catch (Exception e) {
                    throw new CoreException(J2EEPlugin.newErrorStatus((String)this.errorMessage(), (Throwable)e));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected IEJBCommand createCommand() {
        IRootCommand merged = null;
        IRootCommand aSource = this.createARoleSourceEjbCommand();
        IRootCommand bSource = this.createBRoleSourceEjbCommand();
        PersistentRoleCommand aRole = this.createARoleCommand(aSource);
        PersistentRoleCommand bRole = this.createBRoleCommand(bSource);
        if (aSource != null) {
            merged = aSource.append(bSource);
        }
        this.relationshipCommand = this.create20RelationshipCommand(aRole, bRole);
        if (merged == null) {
            return this.relationshipCommand;
        }
        if (this.relationshipCommand != null) {
            merged.append(this.relationshipCommand);
        }
        return merged;
    }

    protected EJBRelationshipCommand create20RelationshipCommand(PersistentRoleCommand aRoleCommand, PersistentRoleCommand bRoleCommand) {
        CreateEJB20RelationshipCommand cmd = new CreateEJB20RelationshipCommand(this.model.getStringProperty("EJBRelationshipDataModel.RELATIONSHIP_NAME"), aRoleCommand, bRoleCommand);
        cmd.setRelationshipDescription(this.model.getStringProperty("EJBRelationshipDataModel.DESCRIPTION"));
        return cmd;
    }

    protected IRootCommand createARoleSourceEjbCommand() {
        return this.createEjbUpdateCommand((EnterpriseBean)this.model.getProperty("EJBRelationshipDataModel.BEAN_B"));
    }

    protected IRootCommand createEjbUpdateCommand(EnterpriseBean anEJB) {
        if (anEJB.isEntity()) {
            if (anEJB.isContainerManagedEntity()) {
                return new UpdateContainerManagedEntityCommand(anEJB, (EJBArtifactEdit)this.getArtifactEdit());
            }
            return new UpdateEntityCommand(anEJB, (EJBArtifactEdit)this.getArtifactEdit());
        }
        return new UpdateSessionCommand(anEJB, (EJBArtifactEdit)this.getArtifactEdit());
    }

    protected PersistentRoleCommand createARoleCommand(IRootCommand root) {
        if (root == null) {
            return null;
        }
        return this.createARole20Command(root);
    }

    protected PersistentRoleCommand createARole20Command(IRootCommand root) {
        CreatePersistent20RoleCommand command = new CreatePersistent20RoleCommand(root, this.model.getStringProperty("EJBRelationshipDataModel.BEAN_A_ROLE_NAME"));
        this.updateARole20Command(command);
        return command;
    }

    protected void updateARole20Command(Persistent20RoleCommand command) {
        command.setForward(this.model.getBooleanProperty("EJBRelationshipDataModel.BEAN_A_FOREIGN_KEY"));
        command.setNavigable(this.model.getBooleanProperty("EJBRelationshipDataModel.BEAN_A_NAVIGABILITY"));
        command.setIsMany(this.model.getBooleanProperty("EJBRelationshipDataModel.BEAN_B_IS_MANY"));
        String fieldName = this.model.getStringProperty("EJBRelationshipDataModel.BEAN_A_CMR_NAME");
        if (!fieldName.equals("")) {
            command.setCmrFieldName(this.model.getStringProperty("EJBRelationshipDataModel.BEAN_A_CMR_NAME"));
        } else {
            command.setCmrFieldName(null);
        }
        String fieldType = this.model.getStringProperty("EJBRelationshipDataModel.BEAN_A_CMR_TYPE");
        if (!fieldType.equals("")) {
            command.setCmrFieldCollectionTypeName(this.model.getStringProperty("EJBRelationshipDataModel.BEAN_A_CMR_TYPE"));
        } else {
            command.setCmrFieldCollectionTypeName(null);
        }
        command.setIsCascadeDelete(this.model.getBooleanProperty("EJBRelationshipDataModel.BEAN_B_CASCADE_DELETE"));
    }

    protected IRootCommand createBRoleSourceEjbCommand() {
        return this.createEjbUpdateCommand((EnterpriseBean)this.model.getProperty("EJBRelationshipDataModel.BEAN_A"));
    }

    protected PersistentRoleCommand createBRoleCommand(IRootCommand root) {
        if (root == null) {
            return null;
        }
        return this.createBRole20Command(root);
    }

    protected PersistentRoleCommand createBRole20Command(IRootCommand root) {
        CreatePersistent20RoleCommand command = new CreatePersistent20RoleCommand(root, this.model.getStringProperty("EJBRelationshipDataModel.BEAN_B_ROLE_NAME"));
        this.updateBRole20Command(command);
        return command;
    }

    protected void updateBRole20Command(Persistent20RoleCommand command) {
        command.setForward(this.model.getBooleanProperty("EJBRelationshipDataModel.BEAN_B_FOREIGN_KEY"));
        command.setNavigable(this.model.getBooleanProperty("EJBRelationshipDataModel.BEAN_B_NAVIGABILITY"));
        command.setIsMany(this.model.getBooleanProperty("EJBRelationshipDataModel.BEAN_A_IS_MANY"));
        String fieldName = this.model.getStringProperty("EJBRelationshipDataModel.BEAN_B_CMR_NAME");
        if (!fieldName.equals("")) {
            command.setCmrFieldName(this.model.getStringProperty("EJBRelationshipDataModel.BEAN_B_CMR_NAME"));
        } else {
            command.setCmrFieldName(null);
        }
        String fieldType = this.model.getStringProperty("EJBRelationshipDataModel.BEAN_B_CMR_TYPE");
        if (!fieldType.equals("")) {
            command.setCmrFieldCollectionTypeName(this.model.getStringProperty("EJBRelationshipDataModel.BEAN_B_CMR_TYPE"));
        } else {
            command.setCmrFieldCollectionTypeName(null);
        }
        command.setIsCascadeDelete(this.model.getBooleanProperty("EJBRelationshipDataModel.BEAN_A_CASCADE_DELETE"));
    }

    protected String errorMessage() {
        return EJBProviderLibrariesResourceHandler.getString((String)"An_error_has_occurred_crea_ERROR_");
    }
}

