/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb.creation.operations;

import com.ibm.etools.j2ee.ejb.EjbPlugin;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBCreationResourceHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CreateSourceFolderOperation
extends AbstractDataModelOperation {
    private String folderName;
    private IVirtualComponent component;

    public CreateSourceFolderOperation(String newFolderName, IVirtualComponent component) {
        this.setFolderName(newFolderName);
        this.setVirtualComponent(component);
    }

    protected String getFolderName() {
        return this.folderName;
    }

    protected void setFolderName(String newFolderName) {
        this.folderName = newFolderName;
    }

    protected IVirtualComponent getVirtualComponent() {
        return this.component;
    }

    protected void setVirtualComponent(IVirtualComponent component) {
        this.component = component;
    }

    protected IFolder createFolder() {
        try {
            return ComponentUtilities.createFolderInComponent((IVirtualComponent)this.component, (String)this.folderName);
        }
        catch (CoreException e) {
            EjbPlugin.logError(e);
            return null;
        }
    }

    protected void addSourceClasspathEntry(IFolder aFolder, IProgressMonitor monitor) throws JavaModelException {
        IPath path;
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)this.component.getProject());
        IPackageFragmentRoot root = javaProject.findPackageFragmentRoot(path = aFolder.getFullPath());
        if (root == null) {
            monitor.subTask(NLS.bind((String)EJBCreationResourceHandler.Creating_source_folder__1, (Object[])new Object[]{this.getFolderName()}));
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int nEntries = entries.length;
            IClasspathEntry[] newEntries = new IClasspathEntry[nEntries + 1];
            int i = 0;
            while (i < nEntries) {
                newEntries[i] = entries[i];
                ++i;
            }
            newEntries[nEntries] = JavaCore.newSourceEntry((IPath)path);
            javaProject.setRawClasspath(newEntries, null);
        }
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IFolder folder = this.createFolder();
        if (folder != null && folder.exists()) {
            try {
                this.addSourceClasspathEntry(folder, monitor);
            }
            catch (JavaModelException je) {
                EjbPlugin.logError((CoreException)((Object)je));
            }
        }
        return OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

