/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.ejb.creation.operations;

import com.ibm.etools.ejb.codegen.helpers.EJBCodegenHandlerExtensionReader;
import com.ibm.etools.ejb.codegen.helpers.IEJBCodegenHandler;
import com.ibm.etools.j2ee.commands.AddBeanClassCommand;
import com.ibm.etools.j2ee.commands.CreateBeanClassCommand;
import com.ibm.etools.j2ee.commands.EnterpriseBeanCommand;
import com.ibm.etools.j2ee.commands.IRootCommand;
import com.ibm.etools.j2ee.ejb.EjbPlugin;
import com.ibm.etools.j2ee.ejb.creation.operations.CreateEnterpriseBeanTemplateModel;
import com.ibm.etools.j2ee.ejb.creation.operations.CreateSourceFolderOperation;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyManager;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.WTPJETEmitter;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditProviderOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.operations.IOperationHandler;

public abstract class CreateEnterpriseBeanOperation
extends ArtifactEditProviderOperation {
    protected EJBArtifactEdit ejbArtifactEdit;
    public static final int TYPE_NEW = 1;
    public static final int TYPE_SOURCE = 2;
    public static final int TYPE_BINARY = 3;
    protected static final String TEMPLATE_DIR = "/templates/";

    public CreateEnterpriseBeanOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public CreateEnterpriseBeanOperation() {
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.createSourceFolder(monitor);
        this.createEnterpriseBean(monitor);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            this.createEnterpriseBean(monitor);
        }
        catch (CoreException e) {
            EjbPlugin.logError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            EjbPlugin.logError(e.getMessage());
        }
        return OK_STATUS;
    }

    private final void createSourceFolder(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            String folderName = this.model.getStringProperty("ICreateEnterpriseBeanDataModelProperties.sourceFolderName");
            if (folderName != null && folderName.length() > 0) {
                CreateSourceFolderOperation op = new CreateSourceFolderOperation(folderName, this.getTargetComponent());
                op.execute(monitor, null);
            }
        }
        catch (ExecutionException re) {
            EjbPlugin.logError(re);
        }
    }

    private final void createEnterpriseBean(IProgressMonitor monitor) throws WFTWrappedException, CoreException {
        if (this.useAnnotations()) {
            this.generateUsingTemplates(monitor);
        } else {
            Command command = this.createCommand(monitor);
            if (command != null) {
                this.artifactEdit.getCommandStack().execute(command);
            }
        }
    }

    private void generateUsingTemplates(IProgressMonitor monitor) throws WFTWrappedException, CoreException {
        WorkingCopyManager mgr;
        String source;
        CreateEnterpriseBeanTemplateModel tempModel = this.createTemplateModel();
        IFile annotatedFile = null;
        try {
            source = this.generateTemplateSource(tempModel, monitor);
        }
        catch (JETException e) {
            throw new WFTWrappedException((Throwable)e);
        }
        IPackageFragment fragment = this.getOrCreatePackageFragment(tempModel.getBeanClassPackageName(), monitor);
        if (fragment != null) {
            String javaFileName = String.valueOf(tempModel.getSimpleBeanClassName()) + ".java";
            ICompilationUnit cu = fragment.getCompilationUnit(javaFileName);
            if (cu == null || !cu.exists()) {
                cu = fragment.createCompilationUnit(javaFileName, source, true, monitor);
            }
            annotatedFile = (IFile)cu.getResource();
            ((EJBArtifactEdit)this.artifactEdit).getWorkingCopy(cu, true);
        }
        if ((mgr = ((EJBArtifactEdit)this.artifactEdit).getWorkingCopyManager()) != null && annotatedFile != null) {
            mgr.saveOnlyNewCompilationUnits((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            AnnotationsController controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(this.getTargetProject());
            if (controller != null) {
                controller.process((IResource)annotatedFile);
            }
        }
    }

    private IPackageFragment getOrCreatePackageFragment(String packageName, IProgressMonitor monitor) throws JavaModelException {
        IFolder source = (IFolder)this.model.getProperty("ICreateEnterpriseBeanDataModelProperties.sourceFolder");
        IPackageFragmentRoot root = (IPackageFragmentRoot)JavaCore.create((IFolder)source);
        IPackageFragment fragment = root.getPackageFragment(packageName);
        if (!fragment.exists()) {
            fragment = root.createPackageFragment(packageName, false, monitor);
        }
        return fragment;
    }

    private String generateTemplateSource(CreateEnterpriseBeanTemplateModel tempModel, IProgressMonitor monitor) throws JETException {
        URL templateURL = null;
        if (this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations")) {
            templateURL = EjbPlugin.getDefault().find((IPath)new Path(TEMPLATE_DIR + this.getTemplateFileName()));
        }
        this.cleanUpOldEmitterProject();
        if (templateURL != null) {
            WTPJETEmitter emitter = new WTPJETEmitter(templateURL.toString(), ((Object)((Object)this)).getClass().getClassLoader());
            emitter.setIntelligentLinkingEnabled(true);
            emitter.addVariable("IBM_EJB_PLUGIN", "com.ibm.etools.j2ee.ejb");
            return emitter.generate(monitor, new Object[]{tempModel});
        }
        return null;
    }

    private void cleanUpOldEmitterProject() {
        IProject project = ProjectUtilities.getProject((String)".JETEmitters");
        if (project == null || !project.exists()) {
            return;
        }
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
            int i = 0;
            int l = markers.length;
            while (i < l) {
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            EjbPlugin.logError(e);
        }
    }

    protected abstract CreateEnterpriseBeanTemplateModel createTemplateModel();

    protected abstract String getTemplateFileName();

    private boolean useAnnotations() {
        return this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations");
    }

    private Command createCommand(IProgressMonitor monitor) {
        String beanName = (String)this.model.getProperty("ICreateEnterpriseBeanDataModelProperties.beanName");
        EnterpriseBeanCommand ejbCommand = this.createRootCommand(beanName);
        if (ejbCommand != null) {
            ejbCommand.setArtifactEdit((EJBArtifactEdit)this.artifactEdit);
            this.initializeRootCommand(ejbCommand);
            this.createDependentCommands(ejbCommand);
            ejbCommand.setArtifactEdit((EJBArtifactEdit)this.artifactEdit);
        }
        return ejbCommand;
    }

    protected void createDependentCommands(EnterpriseBeanCommand ejbCommand) {
        this.createEJBClassCommand(ejbCommand);
        this.createEJBInheritanceCommand(ejbCommand);
    }

    private void createEJBInheritanceCommand(EnterpriseBeanCommand ejbCommand) {
        EnterpriseBean superEJB = (EnterpriseBean)this.model.getProperty("ICreateEnterpriseBeanDataModelProperties.beanSuperEJB");
        if (superEJB != null) {
            IEJBCodegenHandler handler = this.getCodegenHandler();
            handler.createEJBInheritanceCommand(superEJB, ejbCommand);
        }
    }

    private void createEJBClassCommand(EnterpriseBeanCommand ejbCommand) {
        String beanClassName = this.model.getStringProperty("ICreateEnterpriseBeanDataModelProperties.beanClassName");
        JavaClass beanClass = this.reflectJavaClass(beanClassName);
        if (this.shouldGenerateClass("ICreateEnterpriseBeanDataModelProperties.beanClassName")) {
            CreateBeanClassCommand beanClassCommand = new CreateBeanClassCommand((IRootCommand)ejbCommand, beanClass);
            beanClassCommand.setSuperclassName((String)this.model.getProperty("ICreateEnterpriseBeanDataModelProperties.beanClassSuperclass"));
        } else {
            new AddBeanClassCommand((IRootCommand)ejbCommand, beanClass);
        }
    }

    protected JavaClass reflectJavaClass(String qualifiedName) {
        return (JavaClass)JavaRefFactory.eINSTANCE.reflectType(qualifiedName, this.artifactEdit.getContentModelRoot());
    }

    protected boolean shouldGenerateClass(String classPropertyName) {
        IDataModel ejbModel = this.getDataModel();
        ejbModel.setProperty("ICreateEnterpriseBeanDataModelProperties.checkTypeExistsName", (Object)ejbModel.getStringProperty(classPropertyName));
        return !ejbModel.getBooleanProperty("ICreateEnterpriseBeanDataModelProperties.typeExists");
    }

    protected void initializeRootCommand(EnterpriseBeanCommand ejbCommand) {
        ejbCommand.setVersion2_X(this.getBeanVersion());
        ejbCommand.setOperationHandler((IOperationHandler)this.model.getProperty("ICreateEnterpriseBeanDataModelProperties.operationHandler"));
        ejbCommand.setDefaultPackageFragmentRootName(this.model.getStringProperty("ICreateEnterpriseBeanDataModelProperties.sourceFolderName"));
    }

    protected boolean getBeanVersion() {
        return this.model.getBooleanProperty("ICreateEnterpriseBeanDataModelProperties.isVersion2xOrGreater");
    }

    protected abstract EnterpriseBeanCommand createRootCommand(String var1);

    private IEJBCodegenHandler getCodegenHandler() {
        return EJBCodegenHandlerExtensionReader.getInstance().getEJBExtHandler(this.getTargetProject());
    }
}

